/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.analyze;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.diskanalyze.analyze.IDiskLoader;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.rule.BasicInfoFlag;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class DefaultDiskLoader
implements IDiskLoader {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DefaultDiskLoader.class);
    private static final String SHOW_DISK_GENERAL = "show disk general disk_id";
    private static final String DISK_ID = "=";
    private static final String DISK_SN = "Serial Number";
    private static final String SHOW_DISK_GENERAL_ORIGINAL = "show disk general";
    private static final String DISK_SN_FILTER = "Serial\\sNumber";
    private static final String DISK_ID_FILTER = "ID";
    private static final String DISK_FILTER_INCLUDE = "filterColumn include columnList";
    private static final String BLANK = " ";
    private List<Integer> serialNum = new ArrayList<Integer>();

    @Override
    public void loadBasicInfo(AnalyzeDevice dev) {
        ArrayList<String> showrgList = new ArrayList<String>();
        ArrayList<String> showdiskList = new ArrayList<String>();
        ArrayList<Integer> startNum = new ArrayList<Integer>();
        ArrayList<String> diskList = new ArrayList<String>();
        ArrayList<Integer> startTypeNum = new ArrayList<Integer>();
        ArrayList<Integer> startManuNum = new ArrayList<Integer>();
        this.initSectionNum(startNum);
        this.initSectionNum(this.serialNum);
        this.initSectionNum(startTypeNum);
        this.initSectionNum(startManuNum);
        InputStream in = this.getBasicInputStream(dev);
        this.getSnAndSlotStr(showrgList, diskList, showdiskList, startNum, startTypeNum, startManuNum, in);
        this.writeInfo(showdiskList, startNum, dev);
        this.saveTypeAndManu(diskList, startTypeNum, startManuNum, dev);
        if (dev.getDeviceInfo().isDstorage()) {
            this.loadDstorageEnclosureSlotInfo(dev);
        }
        if (dev.getEnclosureSlotInfo().isEmpty()) {
            this.loadBasicNewType(dev);
        }
        if (dev.getEnclosureSlotInfo().isEmpty()) {
            this.loadBasicFilterType(dev);
        }
    }

    private void loadDstorageEnclosureSlotInfo(AnalyzeDevice dev) {
        Map<String, KeyValue<String, String>> enclosureSlotInfo = dev.getEnclosureSlotInfo();
        boolean isStartFlag = false;
        try (InputStream in = this.getBasicInputStream(dev);
             BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (this.judgeLine(line)) {
                    isStartFlag = true;
                    continue;
                }
                if (isStartFlag && StringUtils.isNULLStr((String)line)) continue;
                if (isStartFlag) {
                    this.parseEnclosureAndSlotInfo(enclosureSlotInfo, line);
                }
                if (!isStartFlag || !this.isInfoEnd(line)) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("not found basic info file");
        }
        catch (IOException e) {
            LOGGER.error("loadBasicInfo Read error.", (Throwable)e);
        }
    }

    private void parseEnclosureAndSlotInfo(Map<String, KeyValue<String, String>> enclosureSlotInfo, String line) {
        String serialNo;
        String slotNo;
        int spaceIndex = line.indexOf(BLANK);
        if (spaceIndex == -1) {
            return;
        }
        String ipAndSlot = line.split(BLANK)[0];
        int colonIndex = ipAndSlot.lastIndexOf(":");
        if (colonIndex == -1 || colonIndex == ipAndSlot.length()) {
            return;
        }
        String enclosureNo = ipAndSlot.substring(0, colonIndex);
        if (!StringUtils.hasNULLStr((String[])new String[]{enclosureNo, slotNo = ipAndSlot.substring(colonIndex + 1), serialNo = line.substring(this.serialNum.get(2), this.getTheLastIndex(line, this.serialNum)).trim()})) {
            KeyValue slotInfo = new KeyValue((Object)enclosureNo, (Object)slotNo);
            enclosureSlotInfo.put(String.join((CharSequence)"_", serialNo, enclosureNo), (KeyValue<String, String>)slotInfo);
        }
    }

    private void saveTypeAndManu(List<String> diskList, List<Integer> startTypeNum, List<Integer> startManuNum, AnalyzeDevice dev) {
        try {
            for (int j = 0; j < diskList.size(); ++j) {
                this.setTypeManu(diskList.get(j), startTypeNum, startManuNum, dev);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("sava diskType and manufacturer failed", (Throwable)e);
        }
    }

    private void setTypeManu(String line, List<Integer> startTypeNum, List<Integer> startManuNum, AnalyzeDevice dev) {
        if (!this.isHavaDiskType(line)) {
            return;
        }
        String sn = "";
        String diskType = "";
        String manufacturer = "";
        Map<String, String> snType = dev.getSnType();
        Map<String, String> snManufacturer = dev.getSnManufacturer();
        sn = line.substring(this.serialNum.get(2), this.getTheLastIndex(line, this.serialNum)).trim();
        diskType = line.substring(startTypeNum.get(2), this.getTheLastIndex(line, startTypeNum)).trim();
        if (startManuNum.get(2) != 0) {
            manufacturer = line.substring(startManuNum.get(2), this.getTheLastIndex(line, startManuNum)).trim();
        }
        snType.put(sn, diskType);
        snManufacturer.put(sn, manufacturer);
    }

    private int getTheLastIndex(String line, List<Integer> num) {
        int lasdIndex = num.get(3);
        if (lasdIndex == 0) {
            lasdIndex = line.length();
        }
        return lasdIndex;
    }

    private void initSectionNum(List<Integer> startNum) {
        startNum.add(0);
        startNum.add(0);
        startNum.add(0);
        startNum.add(0);
    }

    private InputStream getBasicInputStream(AnalyzeDevice dev) {
        InputStream in = null;
        if (dev.isIs7ZPkg()) {
            String pkgPath = dev.getPkgPath();
            StringBuilder basicinfoPath = new StringBuilder();
            basicinfoPath.append(pkgPath);
            basicinfoPath.append(File.separator);
            basicinfoPath.append("DataCollect\\disksmartinfo\\");
            basicinfoPath.append("basicinfo.txt");
            try {
                in = new FileInputStream(new File(basicinfoPath.toString()));
            }
            catch (FileNotFoundException e) {
                LOGGER.error("loadBasicInfo build inputstream error  ");
            }
        } else {
            in = DiskHealthAssistant.getInstance().getTxtInputStream("basicinfo.txt", dev);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSnAndSlotStr(List<String> showrgList, List<String> diskList, List<String> showdiskList, List<Integer> startNum, List<Integer> startTypeNum, List<Integer> startManuNum, InputStream in) {
        boolean sign = false;
        BufferedReader br = null;
        BasicInfoFlag flag = BasicInfoFlag.OTHERS;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while (null != (line = br.readLine())) {
                if (this.isSelection(line)) {
                    String lineToUpperCase = line.toUpperCase(Locale.US);
                    sign = true;
                    String type = this.getDiskType(lineToUpperCase);
                    String manu = this.getDiskManu(lineToUpperCase);
                    this.serialNum.set(2, lineToUpperCase.lastIndexOf(DISK_SN.toUpperCase(Locale.US)));
                    int startSerialIndex = lineToUpperCase.lastIndexOf(DISK_SN.toUpperCase(Locale.US)) + DISK_SN.toUpperCase(Locale.US).length();
                    this.serialNum.set(3, this.getEndNum(lineToUpperCase, startSerialIndex));
                    LOGGER.info(String.format(Locale.ENGLISH, "Disk Type is:%s", type));
                    this.addTypeNum(startTypeNum, lineToUpperCase, type);
                    LOGGER.info(String.format(Locale.ENGLISH, "Disk Manu is:", manu));
                    this.addManuNum(startManuNum, lineToUpperCase, manu);
                }
                if (sign && this.isHavaDiskType(line)) {
                    diskList.add(line);
                }
                if (BasicInfoFlag.RAID_INFO.equals((Object)(flag = this.changeBasicInfoStauts(line, flag, startNum)))) {
                    showrgList.add(line);
                    continue;
                }
                if (!BasicInfoFlag.DISK_INFO.equals((Object)flag)) continue;
                showdiskList.add(line);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("loadBasicInfo Read error  ");
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, br);
                StreamUtils.closeStream(null, (InputStream)in);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)br);
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeResource(null, (Closeable)br);
        StreamUtils.closeStream(null, (InputStream)in);
    }

    private void addManuNum(List<Integer> startManuNum, String lineToUpperCase, String manu) {
        if (manu != null) {
            startManuNum.set(2, lineToUpperCase.lastIndexOf(manu));
            int startManuIndex = lineToUpperCase.lastIndexOf(manu) + manu.length();
            startManuNum.set(3, this.getEndNum(lineToUpperCase, startManuIndex));
        }
    }

    private void addTypeNum(List<Integer> startTypeNum, String lineToUpperCase, String type) {
        if (type != null) {
            int startTypeIndex = lineToUpperCase.lastIndexOf(type) + type.length();
            startTypeNum.set(3, this.getEndNum(lineToUpperCase, startTypeIndex));
            startTypeNum.set(2, lineToUpperCase.lastIndexOf(type));
        }
    }

    private String getDiskManu(String lineToUpperCase) {
        String manu = null;
        Locale locale = Locale.US;
        if (lineToUpperCase.contains("Manufacturer".toUpperCase(locale))) {
            manu = "Manufacturer".toUpperCase(locale);
        } else if (lineToUpperCase.contains("Vendor".toUpperCase(locale))) {
            manu = "Vendor".toUpperCase(locale);
        }
        return manu;
    }

    private String getDiskType(String lineToUpperCase) {
        String type = null;
        if (lineToUpperCase.contains("Physical Type".toUpperCase(Locale.US))) {
            type = "Physical Type".toUpperCase(Locale.US);
        } else if (lineToUpperCase.contains("Physical type".toUpperCase(Locale.US))) {
            type = "Physical type".toUpperCase(Locale.US);
        } else if (lineToUpperCase.contains("Type".toUpperCase(Locale.US))) {
            type = "Type".toUpperCase(Locale.US);
        }
        return type;
    }

    boolean isHavaDiskType(String line) {
        return Arrays.asList(DiskType.FC.toString(), DiskType.NVME.toString(), DiskType.SAS.toString(), DiskType.SATA.toString(), DiskType.QLC.toString(), DiskType.HSSD.toString(), DiskType.SCM.toString(), DiskType.SSD.toString()).stream().anyMatch(type -> line.contains((CharSequence)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBasicNewType(AnalyzeDevice dev) {
        InputStream in = this.getBasicInputStream(dev);
        BufferedReader br = null;
        Map<String, KeyValue<String, String>> enclosureSlotInfo = dev.getEnclosureSlotInfo();
        KeyValue<String, String> slotInfo = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while (null != (line = br.readLine())) {
                if (line.contains(SHOW_DISK_GENERAL)) {
                    slotInfo = this.parseSlotInfo(line);
                }
                if (!line.trim().startsWith(DISK_SN)) continue;
                int index = line.lastIndexOf(":");
                String sn = line.substring(1 + index).trim();
                enclosureSlotInfo.put(sn, slotInfo);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("loadBasicInfo Read error  ");
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, br);
                StreamUtils.closeStream(null, (InputStream)in);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)br);
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeResource(null, (Closeable)br);
        StreamUtils.closeStream(null, (InputStream)in);
    }

    private boolean judgeLine(String line) {
        return line.contains(SHOW_DISK_GENERAL_ORIGINAL) && line.contains(DISK_SN_FILTER) && line.contains(DISK_ID_FILTER) && line.contains(DISK_FILTER_INCLUDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBasicFilterType(AnalyzeDevice dev) {
        InputStream in = this.getBasicInputStream(dev);
        BufferedReader br = null;
        Map<String, KeyValue<String, String>> enclosureSlotInfo = dev.getEnclosureSlotInfo();
        boolean startFlag = false;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while (null != (line = br.readLine())) {
                String lineToUpperCase = line.toUpperCase(Locale.US);
                if (this.judgeLine(line)) {
                    startFlag = true;
                    continue;
                }
                if (startFlag && line.trim().equals("")) continue;
                if (startFlag && (this.serialNum.get(2) == 0 || this.serialNum.get(3) == 0)) {
                    this.serialNum.set(2, lineToUpperCase.lastIndexOf(DISK_SN.toUpperCase(Locale.US)));
                    int startSerialIndex = lineToUpperCase.lastIndexOf(DISK_SN.toUpperCase(Locale.US)) + DISK_SN.toUpperCase(Locale.US).length();
                    this.serialNum.set(3, this.getEndNum(lineToUpperCase, startSerialIndex));
                }
                if (startFlag && this.isInfoEnd(line)) break;
                if (!startFlag || !line.contains(".")) continue;
                this.parseSlotInfoByFilter(line, enclosureSlotInfo);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("loadBasicInfo Read error  ");
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, (InputStream)in);
                StreamUtils.closeResource(null, br);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)in);
            StreamUtils.closeResource(null, (Closeable)br);
        }
        StreamUtils.closeStream(null, (InputStream)in);
        StreamUtils.closeResource(null, (Closeable)br);
    }

    private void parseSlotInfoByFilter(String line, Map<String, KeyValue<String, String>> enclosureSlotInfo) {
        String[] slotStrs = line.trim().split(BLANK);
        String sn = null;
        KeyValue slotInfo = null;
        for (String info : slotStrs) {
            if (StringUtils.isNULLStr((String)info) || BLANK.equals(info) || !info.contains(".")) continue;
            int partIndex = info.lastIndexOf(".");
            String encNum = info.substring(0, partIndex).trim();
            String slotNum = info.substring(1 + partIndex).trim();
            slotInfo = new KeyValue((Object)encNum, (Object)slotNum);
        }
        sn = line.substring(this.serialNum.get(2), this.getTheLastIndex(line, this.serialNum)).trim();
        if (null != sn && null != slotInfo) {
            enclosureSlotInfo.put(sn, slotInfo);
        }
    }

    private KeyValue<String, String> parseSlotInfo(String line) {
        int slotInfoIndex = line.lastIndexOf(DISK_ID);
        String subStr = line.substring(1 + slotInfoIndex);
        int partIndex = subStr.lastIndexOf(".");
        String encNum = subStr.substring(0, partIndex).trim();
        String slotNum = subStr.substring(1 + partIndex).trim();
        return new KeyValue((Object)encNum, (Object)slotNum);
    }

    private void writeInfo(List<String> showdiskList, List<Integer> startNum, AnalyzeDevice dev) {
        String preSlotSn = null;
        for (int j = 1; j < showdiskList.size(); ++j) {
            if (showdiskList.get(j).length() < startNum.get(2) || showdiskList.get(j).length() < startNum.get(3)) continue;
            preSlotSn = this.setMapOfSlot(showdiskList.get(j), dev, startNum, preSlotSn);
        }
    }

    private BasicInfoFlag changeBasicInfoStauts(String line, BasicInfoFlag nowFlag, List<Integer> startNum) {
        if (this.isRaidInfo(line)) {
            startNum.set(0, line.lastIndexOf("Name"));
            int startIndex = line.lastIndexOf("Name") + "Name".length();
            int endNum = this.getEndNum(line, startIndex);
            startNum.set(1, endNum);
            return BasicInfoFlag.RAID_INFO;
        }
        if (this.isSlotInfo(line)) {
            int startIndex;
            startNum.set(2, line.lastIndexOf(DISK_SN));
            int endNum = 0;
            for (int i = startIndex = line.lastIndexOf(DISK_SN) + DISK_SN.length(); i < line.length(); ++i) {
                endNum = i;
                if (line.charAt(i) != ' ') break;
            }
            startNum.set(3, endNum);
            return BasicInfoFlag.DISK_INFO;
        }
        if (this.isInfoEnd(line)) {
            return BasicInfoFlag.INFO_END;
        }
        return nowFlag;
    }

    private boolean isSelection(String line) {
        boolean sign = false;
        if ((line = line.toUpperCase(Locale.US)).contains(DISK_SN.toUpperCase(Locale.US)) && (line.contains("Type".toUpperCase(Locale.US)) || line.contains("Physical Type".toUpperCase(Locale.US)) || line.contains("Physical type".toUpperCase(Locale.US)))) {
            sign = true;
        }
        return sign;
    }

    private int getEndNum(String line, int startIndex) {
        int endNum = 0;
        for (int i = startIndex; i < line.length(); ++i) {
            endNum = i;
            if (line.charAt(i) != ' ') break;
        }
        return endNum;
    }

    @Override
    public List<String> loadSmartFiles(AnalyzeDevice ad) {
        ArrayList<String> allList = new ArrayList();
        List<String> smartNameList = null;
        File file = ad.getInfoPackage();
        String path = DiskHealthAssistant.getInstance().getSmartPath(ad);
        if (ad.isIs7ZPkg()) {
            allList = ad.getFile7zSubList();
        } else {
            try {
                allList = ZipUtils.getListFiles((File)file);
            }
            catch (IOException e) {
                LOGGER.error("[loadSmartFiles] get smart name list failed!");
            }
        }
        smartNameList = this.getSpecificPath(allList, path, ad);
        return smartNameList;
    }

    private List<String> getSpecificPath(List<String> list, String path, AnalyzeDevice ad) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        String separator = "";
        separator = ad.isIs7ZPkg() ? File.separator : (ad.isOtherSeparator() ? "/" : "\\");
        for (String str : list) {
            if (!str.contains(path)) continue;
            int num = str.lastIndexOf(separator);
            fileNameList.add(str.substring(num + 1));
        }
        return fileNameList;
    }

    private boolean isRaidInfo(String line) {
        boolean sign = false;
        if (line.contains(DISK_ID_FILTER) && line.contains("Level") && line.contains("Status") && line.contains("Free Capacity(MB)") && line.contains("Name")) {
            sign = true;
        }
        return sign;
    }

    private boolean isSlotInfo(String line) {
        boolean sign = false;
        if (line.contains(DISK_SN) && line.contains("Model") && line.contains("Disk Location")) {
            sign = true;
        }
        return sign;
    }

    private boolean isInfoEnd(String line) {
        return Stream.of("********************", "OceanStor: admin>", "=================", "admin>", "admin:/>").anyMatch(line::contains);
    }

    private String setMapOfSlot(String line, AnalyzeDevice dev, List<Integer> startNum, String preSlotSn) {
        if (!line.contains("(")) {
            String sn1 = line.substring(startNum.get(2), startNum.get(3)).trim();
            if (sn1.length() <= 0 || BLANK.equals(sn1)) {
                return preSlotSn;
            }
            String sn = preSlotSn + sn1;
            Map<String, KeyValue<String, String>> enclosureSlotInfo = dev.getEnclosureSlotInfo();
            KeyValue<String, String> slot = enclosureSlotInfo.get(preSlotSn);
            enclosureSlotInfo.remove(preSlotSn);
            enclosureSlotInfo.put(sn, slot);
            return sn;
        }
        Map<String, KeyValue<String, String>> enclosureSlotInfo = dev.getEnclosureSlotInfo();
        String sn = line.substring(startNum.get(2), startNum.get(3)).trim();
        line = line.trim();
        int enclNum = line.lastIndexOf(")");
        String subStr = line.substring(0, enclNum);
        subStr = subStr.replace(")", "");
        subStr = subStr.replace("(", "");
        String[] enclosureSlotUnit = subStr.split(",");
        KeyValue slot = new KeyValue((Object)enclosureSlotUnit[0], (Object)enclosureSlotUnit[1]);
        enclosureSlotInfo.put(sn, (KeyValue<String, String>)slot);
        return sn;
    }
}

