/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.analyze;

import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeEngine;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.Deduction;
import com.huawei.ism.tool.diskanalyze.entity.DiskDomain;
import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.service.IDiskDomainParse;
import com.huawei.ism.tool.diskanalyze.util.DiskDomainScoreConfig;
import com.huawei.ism.tool.diskanalyze.util.DomainParseFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskDomainScorer {
    private static final Logger log = LoggerFactory.getLogger(DiskDomainScorer.class);

    public static void score(AnalyzeDevice device) {
        IDiskDomainParse parser = DomainParseFactory.getInstance().createParser(device.getDevTypeVersion());
        File poolFile = DiskDomainScorer.getPoolFile(device.getPkgPath());
        if (!poolFile.exists()) {
            log.warn("{} config.txt is not exits", (Object)device.getDeviceInfo().getDeviceSerialNumber());
            return;
        }
        List<DiskDomain> diskDomains = null;
        try (FileInputStream in = new FileInputStream(poolFile);){
            diskDomains = parser.parse(in);
        }
        catch (IOException e) {
            log.error("{} read config.txt error", (Object)device.getDeviceInfo().getDeviceSerialNumber(), (Object)e);
        }
        if (diskDomains == null || diskDomains.isEmpty()) {
            log.warn("device {} not have disk domain info", (Object)device.getDeviceInfo().getDeviceSerialNumber());
            return;
        }
        DiskDomainScorer.syncDiskRaidLevel(device.getDiskList(), diskDomains);
        DiskDomainScorer.score(device.getDiskList());
        DiskDomainScorer.rearrangementDisk(device);
    }

    private static void rearrangementDisk(AnalyzeDevice device) {
        device.getRiskDiskList().clear();
        device.getMinRiskDiskList().clear();
        for (AnalyzeDisk disk : device.getDiskList()) {
            if (disk.getScore() <= 30) {
                device.getRiskDiskList().add(disk);
                continue;
            }
            if (disk.getScore() > 60) continue;
            device.getMinRiskDiskList().add(disk);
        }
        AnalyzeEngine.getInstance().calcDiskInfo(device);
    }

    private static void syncDiskRaidLevel(List<AnalyzeDisk> disks, List<DiskDomain> domains) {
        for (DiskDomain domain : domains) {
            Map<RaidLevel, List<AnalyzeDisk>> diskGroup = domain.getDiskGroup();
            for (Map.Entry<RaidLevel, List<AnalyzeDisk>> entry : diskGroup.entrySet()) {
                disks.stream().filter(disk -> DiskDomainScorer.isInDisks(disk, (List)entry.getValue())).forEach(disk -> disk.setRaidLevel((RaidLevel)entry.getKey()));
            }
        }
    }

    private static boolean isInDisks(AnalyzeDisk disk, List<AnalyzeDisk> disks) {
        return disks.stream().anyMatch(single -> StringUtils.equals((CharSequence)disk.getEnclosureNo(), (CharSequence)single.getEnclosureNo()) && StringUtils.equals((CharSequence)disk.getSlotNo(), (CharSequence)single.getSlotNo()));
    }

    private static void score(List<AnalyzeDisk> disks) {
        disks.forEach(DiskDomainScorer::scoreSingleDisk);
    }

    private static void scoreSingleDisk(AnalyzeDisk disk) {
        Optional<Deduction> optional = DiskDomainScoreConfig.queryRuleByRaidLevel(disk.getRaidLevel());
        if (!optional.isPresent()) {
            return;
        }
        disk.setScore(optional.get().weighting(disk.getScore(), DiskDomainScorer.getPohTime(disk.getPowerOnTime())));
    }

    private static int getPohTime(String pohTime) {
        if (StringUtils.isBlank((CharSequence)pohTime)) {
            return 0;
        }
        try {
            return (int)Math.ceil(Double.parseDouble(pohTime));
        }
        catch (NumberFormatException e) {
            log.error("convert poh time to int error.", (Throwable)e);
            return 0;
        }
    }

    private static File getPoolFile(String pkgPath) {
        String path = pkgPath + File.separator + "Information\\disksmartinfo\\" + File.separator + "config.txt";
        File poolFile = new File(path);
        if (poolFile.exists()) {
            return poolFile;
        }
        path = pkgPath + File.separator + "DataCollect\\disksmartinfo\\" + File.separator + "config.txt";
        return new File(path);
    }
}

