/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.entity;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalyzeDevice {
    private DevNode deviceInfo = null;
    private File infoPackage = null;
    private Date packageDate = null;
    private int totalDisk = 0;
    private int succeedDisk = 0;
    private List<AnalyzeDisk> diskList = new ArrayList<AnalyzeDisk>();
    private Set<AnalyzeDisk> riskDiskList = new HashSet<AnalyzeDisk>();
    private Set<AnalyzeDisk> collectDiskList = new HashSet<AnalyzeDisk>();
    private Set<AnalyzeDisk> minRiskDiskList = new HashSet<AnalyzeDisk>();
    private List<AnalyzeDisk> failedDiskList = new ArrayList<AnalyzeDisk>();
    private List<String> smartList = null;
    private boolean isAnalyzeSuc = false;
    private boolean isOtherSep = false;
    private Map<String, KeyValue<String, String>> enclosureSlotInfo = new HashMap<String, KeyValue<String, String>>();
    private Map<String, String> snType = new HashMap<String, String>();
    private Map<String, String> snManufacturer = new HashMap<String, String>();
    private Map<KeyValue<String, String>, String> raidInfo = new HashMap<KeyValue<String, String>, String>();
    private boolean is7ZPkg = false;
    private String pkgPath = "";
    private List<String> file7zSubList = new ArrayList<String>();
    private String importFailedReason = "";

    public Map<String, String> getSnType() {
        return this.snType;
    }

    public Map<String, String> getSnManufacturer() {
        return this.snManufacturer;
    }

    public Map<String, KeyValue<String, String>> getEnclosureSlotInfo() {
        return this.enclosureSlotInfo;
    }

    public Map<KeyValue<String, String>, String> getRaidInfo() {
        return this.raidInfo;
    }

    public String getUuid() {
        String uuid = "";
        String deviceType = "";
        if (null != this.deviceInfo) {
            deviceType = this.deviceInfo.getDeviceType().toString().replace("/", "%");
            uuid = this.deviceInfo.getDeviceSerialNumber() + deviceType;
        }
        if (null != this.packageDate) {
            uuid = uuid + this.packageDate.getTime();
        }
        return uuid;
    }

    public Date getPackageDate() {
        if (null != this.packageDate) {
            return (Date)this.packageDate.clone();
        }
        return null;
    }

    public void setPackageDate(Date packageDate) {
        this.packageDate = packageDate != null ? (Date)packageDate.clone() : null;
    }

    public int getSucceedDisk() {
        return this.succeedDisk;
    }

    public void setSucceedDisk(int succeedDisk) {
        this.succeedDisk = succeedDisk;
    }

    public int getTotalDisk() {
        return this.totalDisk;
    }

    public void setTotalDisk(int totalDisk) {
        this.totalDisk = totalDisk;
    }

    public DevNode getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getDevTypeVersion() {
        if (null == this.deviceInfo) {
            return null;
        }
        return this.deviceInfo.getDeviceType() + " " + DiskAnalyzeContext.getInstance().getDevVersionWithoutSPC(this.deviceInfo.getProductVersion());
    }

    public void setDeviceInfo(DevNode deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public List<AnalyzeDisk> getDiskList() {
        return this.diskList;
    }

    public void addDiskList(AnalyzeDisk idiskList) {
        this.diskList.add(idiskList);
    }

    public File getInfoPackage() {
        return this.infoPackage;
    }

    public void setInfoPackage(File infoPackage) {
        this.infoPackage = infoPackage;
    }

    public List<String> getSmartList() {
        return this.smartList;
    }

    public void setSmartList(List<String> smartList) {
        this.smartList = smartList;
    }

    public boolean isAnalyzeSuccess() {
        return this.isAnalyzeSuc;
    }

    public void setAnalyzeSuccess(boolean isAnalyzeSuccess) {
        this.isAnalyzeSuc = isAnalyzeSuccess;
    }

    public void reAnalyzeClrear() {
        this.diskList = new ArrayList<AnalyzeDisk>();
        this.smartList = null;
        this.isAnalyzeSuc = false;
        this.enclosureSlotInfo = new HashMap<String, KeyValue<String, String>>();
        this.raidInfo = new HashMap<KeyValue<String, String>, String>();
    }

    public boolean isOtherSeparator() {
        return this.isOtherSep;
    }

    public void setOtherSeparator(boolean isOtherSeparator) {
        this.isOtherSep = isOtherSeparator;
    }

    public List<AnalyzeDisk> getFailedDiskList() {
        return this.failedDiskList;
    }

    public void setFailedDiskList(List<AnalyzeDisk> failedDiskList) {
        this.failedDiskList = failedDiskList;
    }

    public boolean isIs7ZPkg() {
        return this.is7ZPkg;
    }

    public void setIs7ZPkg(boolean is7zPkg) {
        this.is7ZPkg = is7zPkg;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public void setPkgPath(String pkgPath) {
        this.pkgPath = pkgPath;
    }

    public List<String> getFile7zSubList() {
        return this.file7zSubList;
    }

    public void setFile7zSubList(List<String> file7zSubList) {
        this.file7zSubList = file7zSubList;
    }

    public String getReason() {
        return this.importFailedReason;
    }

    public void setReason(String reason) {
        this.importFailedReason = reason;
    }

    public int getRiskDiskNum() {
        return this.riskDiskList.size();
    }

    public int getCollectDiskNum() {
        return this.collectDiskList.size();
    }

    public Set<AnalyzeDisk> getRiskDiskList() {
        return this.riskDiskList;
    }

    public void setRiskDiskList(Set<AnalyzeDisk> riskDiskList) {
        this.riskDiskList = riskDiskList;
    }

    public Set<AnalyzeDisk> getCollectDiskList() {
        return this.collectDiskList;
    }

    public void setCollectDiskList(Set<AnalyzeDisk> collectDiskList) {
        this.collectDiskList = collectDiskList;
    }

    public Set<AnalyzeDisk> getMinRiskDiskList() {
        return this.minRiskDiskList;
    }

    public void setMinRiskDiskList(Set<AnalyzeDisk> minRiskDiskList) {
        this.minRiskDiskList = minRiskDiskList;
    }

    public Set<String> getBasicInfoDiskSnSet() {
        return this.enclosureSlotInfo.keySet();
    }

    public void filterNotInBasicInfo() {
        if (CommonCheckLogic.getInstance().needFilter(this.deviceInfo.getProductVersion())) {
            this.filter(this.diskList);
            this.filter(this.riskDiskList);
            this.filter(this.collectDiskList);
            this.filter(this.minRiskDiskList);
            this.filter(this.failedDiskList);
        }
    }

    private void filter(Iterator<AnalyzeDisk> it) {
        while (it.hasNext()) {
            AnalyzeDisk ad = it.next();
            if (this.getBasicInfoDiskSnSet().contains(ad.getSn())) continue;
            it.remove();
        }
    }

    private void filter(List<AnalyzeDisk> list) {
        Iterator<AnalyzeDisk> it = list.iterator();
        this.filter(it);
    }

    private void filter(Set<AnalyzeDisk> set) {
        Iterator<AnalyzeDisk> it = set.iterator();
        this.filter(it);
    }
}

