/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalyzeDisk {
    private String id;
    private String vender;
    private String model;
    private String firmwareVersion;
    private String enclosureNo;
    private String slotNo;
    private String sn;
    private DiskType type;
    private String realDiskType;
    private String powerOnTime;
    private List<AnalyzeItemResult> resultList;
    private int score;
    private RaidLevel raidLevel;
    private String diskDomainId;
    private Map<String, Integer> checkPointScores = new HashMap<String, Integer>();
    private Map<String, CheckPointValue> checkPointValues = new HashMap<String, CheckPointValue>();
    private boolean isAnalyzeSuccess = false;
    private List<String> failedReason = new ArrayList<String>();
    private String bgColor = "white";

    public String getEnclosureNo() {
        return this.enclosureNo;
    }

    public void setEnclosureNo(String enclosureNo) {
        this.enclosureNo = enclosureNo;
    }

    public String getSlotNo() {
        return this.slotNo;
    }

    public void setSlotNo(String slotNo) {
        this.slotNo = slotNo;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public DiskType getType() {
        return this.type;
    }

    public void setType(DiskType type) {
        this.type = type;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getVender() {
        return this.vender;
    }

    public void setVender(String vender) {
        this.vender = vender;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<AnalyzeItemResult> getResultList() {
        return new ArrayList<AnalyzeItemResult>(this.resultList);
    }

    public void setResultList(List<AnalyzeItemResult> resultList) {
        this.resultList = resultList;
    }

    public Map<String, Integer> getCheckPointScores() {
        return new HashMap<String, Integer>(this.checkPointScores);
    }

    public void setCheckPointScores(Map<String, Integer> checkPointScores) {
        this.checkPointScores = checkPointScores;
    }

    public void updateCheckPointScore(String ckId, int ckScore) {
        this.checkPointScores.remove(ckId);
        this.checkPointScores.put(ckId, ckScore);
    }

    public boolean isAnalyzeSuc() {
        return this.isAnalyzeSuccess;
    }

    public void setAnalyzeSuc(boolean isAnalyzeSuc) {
        this.isAnalyzeSuccess = isAnalyzeSuc;
    }

    public CheckPointValue getCheckPointValue(String ckPointId) {
        return this.checkPointValues.get(ckPointId);
    }

    public void addCheckPointValue(String ckPointId, CheckPointValue value) {
        this.checkPointValues.put(ckPointId, value);
    }

    public List<String> getFailedReason() {
        return this.failedReason;
    }

    public void setFailedReason(List<String> failedReason) {
        this.failedReason = failedReason;
    }

    public Map<String, CheckPointValue> getCheckPointValues() {
        return this.checkPointValues;
    }

    public void setCheckPointValues(Map<String, CheckPointValue> checkPointValues) {
        this.checkPointValues = checkPointValues;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getPowerOnTime() {
        return this.powerOnTime;
    }

    public void setPowerOnTime(String powerOnTime) {
        this.powerOnTime = powerOnTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.sn == null ? 0 : this.sn.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.vender == null ? 0 : this.vender.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzeDisk other = (AnalyzeDisk)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.sn == null ? other.sn != null : !this.sn.equals(other.sn)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.vender == null) {
            return other.vender == null;
        }
        return this.vender.equals(other.vender);
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public void setRealDiskType(String type) {
        this.realDiskType = type;
    }

    public String getShowDiskType() {
        if (StringUtils.isNULLStr((String)this.realDiskType)) {
            return this.type.toString();
        }
        return this.realDiskType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RaidLevel getRaidLevel() {
        return this.raidLevel;
    }

    public void setRaidLevel(RaidLevel raidLevel) {
        this.raidLevel = raidLevel;
    }

    public String getDiskDomainId() {
        return this.diskDomainId;
    }

    public void setDiskDomainId(String diskDomainId) {
        this.diskDomainId = diskDomainId;
    }
}

