/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.entity;

import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.entity.StoragePool;
import com.huawei.ism.tool.diskanalyze.entity.StoragePoolTier;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DiskDomain {
    private String id;
    private String name;
    private List<AnalyzeDisk> disks;
    private List<StoragePool> storagePools;
    private Map<RaidLevel, List<AnalyzeDisk>> diskGroup;

    public Map<RaidLevel, List<AnalyzeDisk>> getDiskGroup() {
        if (this.diskGroup == null || this.diskGroup.isEmpty()) {
            this.initDiskGroup();
        }
        return this.diskGroup;
    }

    private void initDiskGroup() {
        this.diskGroup = new HashMap<RaidLevel, List<AnalyzeDisk>>();
        if (this.storagePools == null || this.storagePools.isEmpty()) {
            return;
        }
        List tiers = this.storagePools.stream().map(StoragePool::getTiers).flatMap(Collection::stream).collect(Collectors.toList());
        Map diskTypeLevel = tiers.stream().filter(tier -> tier.getDiskType() != null).collect(Collectors.groupingBy(StoragePoolTier::getDiskType, Collectors.mapping(StoragePoolTier::getRaidLevel, Collectors.toList())));
        for (DiskType diskType : diskTypeLevel.keySet()) {
            diskTypeLevel.get((Object)diskType).sort(Enum::compareTo);
            List curTypeDisk = this.disks.stream().filter(disk -> disk.getType() == diskType).peek(disk -> disk.setRaidLevel((RaidLevel)((List)diskTypeLevel.get((Object)diskType)).get(0))).collect(Collectors.toList());
            this.diskGroup.put((RaidLevel)diskTypeLevel.get((Object)diskType).get(0), curTypeDisk);
        }
        if (this.diskGroup.isEmpty() && diskTypeLevel.isEmpty()) {
            tiers.stream().map(StoragePoolTier::getRaidLevel).sorted().findFirst().ifPresent(raidLevel -> this.diskGroup.put((RaidLevel)raidLevel, this.disks));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<AnalyzeDisk> getDisks() {
        return this.disks;
    }

    public List<StoragePool> getStoragePools() {
        return this.storagePools;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisks(List<AnalyzeDisk> disks) {
        this.disks = disks;
    }

    public void setStoragePools(List<StoragePool> storagePools) {
        this.storagePools = storagePools;
    }
}

