/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.entity;

import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiskHealthAnalyzeUserOpData
extends UserOpToolBasicData {
    @FieldInfo(index=15, desc="\u786c\u76d8\u65e5\u5fd7\u6536\u96c6\u65f6\u95f4", name="collectTime", isMust=false)
    private long collectTime = 0L;
    @FieldInfo(index=16, desc="\u6240\u6709\u76d8\u6570\u91cf", name="allDiskNum", isMust=true)
    private int allDiskNum = 0;
    @FieldInfo(index=17, desc="\u6536\u96c6\u6210\u529f\u76d8\u6570\u91cf", name="succeedDiskNum", isMust=true)
    private int succeedDiskNum = 0;
    @FieldInfo(index=18, desc="\u98ce\u9669\u76d8\u6570\u91cf", name="riskDiskNum", isMust=true)
    private int riskDiskNum = 0;
    @FieldInfo(index=19, desc="\u98ce\u9669\u76d8\u4fe1\u606f", name="riskDiskInfo", isMust=true)
    private String riskDiskInfo = "";
    @FieldInfo(index=20, desc="\u76d8\u7c7b\u578b", name="analyzeDiskType", isMust=true)
    private String analyzeDiskType = "";

    public void setRiskDiskInfo(AnalyzeDevice device) {
        List<AnalyzeDisk> disks = device.getDiskList();
        JSONArray jsonArray = new JSONArray();
        for (AnalyzeDisk analyzeDisk : disks) {
            if (!analyzeDisk.isAnalyzeSuc() || analyzeDisk.getScore() > 30) continue;
            jsonArray.put((Object)this.getDiskInfo(analyzeDisk));
        }
        this.riskDiskInfo = jsonArray.toString();
    }

    public JSONObject getDiskInfo(AnalyzeDisk riskDisk) {
        JSONObject diskInfo = new JSONObject();
        diskInfo.put("Type", (Object)riskDisk.getType().toString());
        diskInfo.put("Model", (Object)riskDisk.getModel());
        diskInfo.put("Firmware version", (Object)riskDisk.getFirmwareVersion());
        diskInfo.put("Power on time(h)", (Object)riskDisk.getPowerOnTime());
        JSONObject riskItemInfo = new JSONObject();
        List<AnalyzeItemResult> riskItemList = DiskHealthAnalyzeUserOpData.getRiskItem(riskDisk);
        for (AnalyzeItemResult riskItem : riskItemList) {
            riskItemInfo.put(riskItem.getRule().getNameEn(), riskItem.getRiskLevel());
        }
        diskInfo.put("Risk items", (Object)riskItemInfo);
        return diskInfo;
    }

    public static List<AnalyzeItemResult> getRiskItem(AnalyzeDisk riskDisk) {
        return DiskHealthAnalyzeUserOpData.getRiskItem(riskDisk.getResultList());
    }

    public static List<AnalyzeItemResult> getRiskItem(List<AnalyzeItemResult> resultList) {
        ArrayList<AnalyzeItemResult> riskItemList = new ArrayList<AnalyzeItemResult>();
        for (AnalyzeItemResult analyzeItemResult : resultList) {
            if (0 == analyzeItemResult.getRiskLevel()) continue;
            riskItemList.add(analyzeItemResult);
        }
        return riskItemList;
    }

    public void setAnalyzeDiskType(AnalyzeDevice device) {
        List<AnalyzeDisk> diskList = device.getDiskList();
        this.setAnalyzeDiskType(diskList);
    }

    public void setAnalyzeDiskType(List<AnalyzeDisk> diskList) {
        Map<DiskType, Integer> diskTypeMap = this.getDiskTypeInfo(diskList);
        Set<Map.Entry<DiskType, Integer>> diskTypeMapSet = diskTypeMap.entrySet();
        JSONObject json = new JSONObject();
        for (Map.Entry<DiskType, Integer> entry : diskTypeMapSet) {
            json.put(entry.getKey().toString(), (Object)entry.getValue());
        }
        this.setAnalyzeDiskType(json.toString());
    }

    public Map<DiskType, Integer> getDiskTypeInfo(List<AnalyzeDisk> diskList) {
        HashMap<DiskType, Integer> diskMap = new HashMap<DiskType, Integer>();
        DiskType type = null;
        Integer count = 0;
        for (AnalyzeDisk analyzeDisk : diskList) {
            type = analyzeDisk.getType();
            Integer n = count = diskMap.get((Object)type) == null ? Integer.valueOf(0) : (Integer)diskMap.get((Object)type);
            if (DiskType.NEAR_LINE_SAS.equals((Object)type) || DiskType.NLSAS.equals((Object)type)) {
                count = count + 1;
                diskMap.put(DiskType.NEAR_LINE_SAS, count);
                continue;
            }
            count = count + 1;
            diskMap.put(type, count);
        }
        return diskMap;
    }

    public String getAnalyzeDiskType() {
        return this.analyzeDiskType;
    }

    public void setAnalyzeDiskType(String analyzeDiskType) {
        this.analyzeDiskType = analyzeDiskType;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public void setCollectTime(AnalyzeDevice device) {
        Date pkgCollectTime = device.getPackageDate();
        if (pkgCollectTime != null) {
            this.setCollectTime(pkgCollectTime.getTime());
        }
    }

    public void setCollectTime(long collectTime) {
        this.collectTime = collectTime;
    }

    public int getAllDiskNum() {
        return this.allDiskNum;
    }

    public void setAllDiskNum(int allDiskNum) {
        this.allDiskNum = allDiskNum;
    }

    public int getSucceedDiskNum() {
        return this.succeedDiskNum;
    }

    public void setSucceedDiskNum(int succeedDiskNum) {
        this.succeedDiskNum = succeedDiskNum;
    }

    public int getRiskDiskNum() {
        return this.riskDiskNum;
    }

    public void setRiskDiskNum(int riskDiskNum) {
        this.riskDiskNum = riskDiskNum;
    }

    public String getRiskDiskInfo() {
        return this.riskDiskInfo;
    }

    public String toString() {
        return "DiskHealthAnalyzeUserOpData [allDiskNum=" + this.allDiskNum + ", succeedDiskNum=" + this.succeedDiskNum + ", riskDiskNum=" + this.riskDiskNum + ", riskDiskInfo=" + this.riskDiskInfo + ", collectTime=" + this.collectTime + ", analyzeDiskType=" + this.analyzeDiskType + "]";
    }
}

