/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.ICombineLogic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class CombineLogic
implements ICombineLogic {
    private static final int DEFAULT_HEALTH = 100;
    private List<KeyValue<Integer, Map<Integer, Integer>>> healthRiskMap = new ArrayList<KeyValue<Integer, Map<Integer, Integer>>>();

    public CombineLogic(Element combineEm) {
        for (Element riskEm : XmlUtils.getChildren((Element)combineEm, (String)"health")) {
            String healthLevel = XmlUtils.getAttribute((Element)riskEm, (String)"level");
            Integer health = Integer.valueOf(healthLevel);
            HashMap<Integer, Integer> riskCntMap = new HashMap<Integer, Integer>();
            String risks = XmlUtils.getAttribute((Element)riskEm, (String)"risks");
            for (String riskCntStr : risks.split(",")) {
                String[] riskCnt = riskCntStr.split(":");
                Integer risk = Integer.valueOf(riskCnt[0]);
                Integer count = Integer.valueOf(riskCnt[1]);
                riskCntMap.put(risk, count);
            }
            this.healthRiskMap.add((KeyValue<Integer, Map<Integer, Integer>>)new KeyValue((Object)health, riskCntMap));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getCombinedScore(List<Integer> riskLevelList) {
        HashMap<Integer, Integer> riskCountMap = new HashMap<Integer, Integer>();
        for (Integer risk : riskLevelList) {
            Integer n;
            void var5_8;
            Integer n2 = (Integer)riskCountMap.get(risk);
            if (null == n2) {
                Integer n3 = 0;
            }
            Iterator iterator = var5_8;
            Integer n4 = n = Integer.valueOf(var5_8.intValue() + 1);
            riskCountMap.put(risk, n);
        }
        HashMap adjustedMap = new HashMap(riskCountMap);
        for (Map.Entry entry : riskCountMap.entrySet()) {
            for (Map.Entry entry2 : riskCountMap.entrySet()) {
                if ((Integer)entry2.getKey() >= (Integer)entry.getKey()) continue;
                adjustedMap.put(entry2.getKey(), (Integer)entry2.getValue() + 1);
            }
        }
        for (KeyValue keyValue : this.healthRiskMap) {
            Integer health = (Integer)keyValue.getKey();
            Map map = (Map)keyValue.getValue();
            for (Map.Entry riskCnt : map.entrySet()) {
                Integer risk = (Integer)riskCnt.getKey();
                Integer curCount = (Integer)adjustedMap.get(risk);
                if (null == curCount || curCount < (Integer)riskCnt.getValue()) continue;
                return health;
            }
        }
        return 100;
    }
}

