/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule;

import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.CheckPoint;
import com.huawei.ism.tool.diskanalyze.rule.ICombineLogic;
import com.huawei.ism.tool.diskanalyze.rule.IDynamicLogic;
import com.huawei.ism.tool.diskanalyze.rule.IValueParser;
import com.huawei.ism.tool.diskanalyze.rule.parser.KeyValueParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Rule {
    private static final String DYNAMIC_SEPERATOR = ": ";
    private static final String DYNAMIC_CKPOINT = "_checkpiont";
    private List<String> startLineList = new ArrayList<String>();
    private List<String> itemIdList = new ArrayList<String>();
    private Map<String, Set<CheckPoint>> startCheckPointMap = new HashMap<String, Set<CheckPoint>>();
    private Map<String, AnalyzeItem> itemMap = new HashMap<String, AnalyzeItem>();
    private Map<String, CheckPoint> checkPointMap = new HashMap<String, CheckPoint>();
    private IValueParser defaultParser = null;
    private ICombineLogic combineLogic = null;
    private AnalyzeItem dynamicItem = null;
    private IDynamicLogic dynamicLogic = null;

    public boolean isEnableDynamic() {
        return null != this.dynamicLogic;
    }

    public boolean isItemsBegin(String line) {
        return this.dynamicLogic.isItemsBegin(line);
    }

    public boolean isItemsEnd(String line) {
        return this.dynamicLogic.isItemsEnd(line);
    }

    public String registerCheckPoint(String line) {
        String name = this.dynamicLogic.getItemName(line);
        String[] dhaLine = line.split(":");
        String ckPointId1 = this.startsWithHealthMarkForDHA(dhaLine);
        if (ckPointId1 != null) {
            return ckPointId1;
        }
        if ("Health Mark For DHA".equals(name.trim())) {
            String itemId = this.dynamicItem.getId();
            String ckPointId = itemId;
            if (this.getCheckPointById(ckPointId) != null) {
                return ckPointId;
            }
            AnalyzeItem item = new AnalyzeItem();
            item.setId(itemId);
            item.setNameEn(this.dynamicItem.getNameEn());
            item.setNameZh(this.dynamicItem.getNameZh());
            item.setCheckLogic(this.dynamicItem.getCheckLogic());
            this.addItem(item);
            CheckPoint ckPoint = new CheckPoint();
            ckPoint.setId(ckPointId);
            ckPoint.setBelongItemId(item.getId());
            ckPoint.setCheckLogic(item.getCheckLogic());
            ckPoint.setValueParser(new KeyValueParser());
            this.checkPointMap.put(ckPoint.getId(), ckPoint);
            return ckPointId;
        }
        String itemId = this.dynamicItem.getId() + DYNAMIC_SEPERATOR + name;
        String ckPointId = itemId + DYNAMIC_CKPOINT;
        if (this.getCheckPointById(ckPointId) != null) {
            return ckPointId;
        }
        AnalyzeItem item = new AnalyzeItem();
        item.setId(itemId);
        item.setNameEn(this.dynamicItem.getNameEn() + DYNAMIC_SEPERATOR + name);
        item.setNameZh(this.dynamicItem.getNameZh() + DYNAMIC_SEPERATOR + name);
        item.setCheckLogic(this.dynamicItem.getCheckLogic());
        this.addItem(item);
        CheckPoint ckPoint = new CheckPoint();
        ckPoint.setId(ckPointId);
        ckPoint.setBelongItemId(item.getId());
        ckPoint.setCheckLogic(item.getCheckLogic());
        ckPoint.setValueParser(this.getDefaultParser());
        this.checkPointMap.put(ckPoint.getId(), ckPoint);
        return ckPointId;
    }

    private String startsWithHealthMarkForDHA(String[] dhaLine) {
        if (dhaLine[0].startsWith("Health Mark For DHA")) {
            String itemId = "10";
            String ckPointId = itemId;
            if (this.getCheckPointById(ckPointId) != null) {
                return ckPointId;
            }
            AnalyzeItem item = new AnalyzeItem();
            item.setId(itemId);
            item.setNameEn("DHA");
            item.setNameZh("DHA");
            item.setCheckLogic(this.dynamicItem.getCheckLogic());
            this.addItem(item);
            CheckPoint ckPoint = new CheckPoint();
            ckPoint.setId(ckPointId);
            ckPoint.setBelongItemId(item.getId());
            ckPoint.setCheckLogic(item.getCheckLogic());
            ckPoint.setValueParser(new KeyValueParser());
            this.checkPointMap.put(ckPoint.getId(), ckPoint);
            return ckPointId;
        }
        return null;
    }

    public void addItem(AnalyzeItem item) {
        this.itemMap.put(item.getId(), item);
        this.itemIdList.add(item.getId());
    }

    public void addCheckPoint(CheckPoint checkPoint, String startLine) {
        this.checkPointMap.put(checkPoint.getId(), checkPoint);
        Set<CheckPoint> cpSet = this.startCheckPointMap.get(startLine);
        if (null == cpSet) {
            cpSet = new HashSet<CheckPoint>();
            this.startCheckPointMap.put(startLine, cpSet);
        }
        cpSet.add(checkPoint);
    }

    public List<String> getItemIdList() {
        return new ArrayList<String>(this.itemIdList);
    }

    public AnalyzeItem getItemById(String id) {
        return this.itemMap.get(id);
    }

    public CheckPoint getCheckPointById(String id) {
        return this.checkPointMap.get(id);
    }

    public Collection<CheckPoint> getAllCheckPoints() {
        return this.checkPointMap.values();
    }

    public void addStartLine(String startLine) {
        this.startLineList.add(startLine);
    }

    public List<String> getStartLineList() {
        return new ArrayList<String>(this.startLineList);
    }

    public Set<CheckPoint> getCheckPointSet(String startLine) {
        return this.startCheckPointMap.get(startLine);
    }

    public IValueParser getDefaultParser() {
        return this.defaultParser;
    }

    public void setDefaultParser(IValueParser defaultParser) {
        this.defaultParser = defaultParser;
    }

    public ICombineLogic getCombineLogic() {
        return this.combineLogic;
    }

    public void setCombineLogic(ICombineLogic combineLogic) {
        this.combineLogic = combineLogic;
    }

    public void setDynamicItem(AnalyzeItem dynamicItem) {
        this.dynamicItem = dynamicItem;
    }

    public void setDynamicLogic(IDynamicLogic dynamicLogic) {
        this.dynamicLogic = dynamicLogic;
    }
}

