/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.CheckPoint;
import com.huawei.ism.tool.diskanalyze.rule.CombineLogic;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.rule.ICheckLogic;
import com.huawei.ism.tool.diskanalyze.rule.IDynamicLogic;
import com.huawei.ism.tool.diskanalyze.rule.IValueParser;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.rule.parser.HssdValueParser;
import com.huawei.ism.tool.diskanalyze.rule.parser.KeyValueParser;
import com.huawei.ism.tool.diskanalyze.rule.parser.MutilValueParser;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RuleManager {
    private static final String RULE_REPO_CFG = "config/diskanalyze/rule/Repository.xml";
    private static final String PARSER_PKG = "com.huawei.ism.tool.diskanalyze.rule.parser";
    private static final String LOGIC_PKG = "com.huawei.ism.tool.diskanalyze.rule.logic";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RuleManager.class);
    private static final RuleManager INSTANCE = new RuleManager();
    private Map<DiskType, Rule> ruleMap = new HashMap<DiskType, Rule>();

    private RuleManager() {
    }

    public void init() {
        Document doc = this.getDoc(RULE_REPO_CFG);
        if (null == doc) {
            LOGGER.error("get doc from config/diskanalyze/rule/Repository.xml failed.");
            return;
        }
        Element root = doc.getDocumentElement();
        CommonCheckLogic.initByConfig(root);
        Element rules = XmlUtils.getChild((Element)root, (String)"rules");
        for (Element ruleEm : XmlUtils.getChildren((Element)rules, (String)"rule")) {
            String diskType = XmlUtils.getAttribute((Element)ruleEm, (String)"diskType");
            String ruleConfig = XmlUtils.getAttribute((Element)ruleEm, (String)"config");
            Rule rule = this.parseRule(ruleConfig);
            if (null == rule) continue;
            this.ruleMap.put(DiskType.getDiskType(diskType), rule);
        }
    }

    public static RuleManager getInstance() {
        return INSTANCE;
    }

    public Rule getRule(DiskType type) {
        return this.ruleMap.get((Object)type);
    }

    private Rule parseRule(String ruleConfig) {
        Document doc = this.getDoc(ruleConfig);
        if (null == doc) {
            return null;
        }
        Element root = doc.getDocumentElement();
        Rule rule = new Rule();
        String parserName = XmlUtils.getAttribute((Element)root, (String)"valueParser");
        if (!StringUtils.isNULLStr((String)parserName)) {
            rule.setDefaultParser(this.buildValueParser(parserName));
        }
        HashMap<String, String> startLines = new HashMap<String, String>();
        Element startLinesEm = XmlUtils.getChild((Element)root, (String)"startLines");
        for (Element lineEm : XmlUtils.getChildren((Element)startLinesEm, (String)"startLine")) {
            String line = XmlUtils.getAttribute((Element)lineEm, (String)"str");
            startLines.put(XmlUtils.getAttribute((Element)lineEm, (String)"id"), line);
            rule.addStartLine(line);
        }
        for (Element itemEm : XmlUtils.getChildren((Element)root, (String)"item")) {
            AnalyzeItem item = this.parseItem(itemEm);
            rule.addItem(item);
            for (Element ckPointEm : XmlUtils.getChildren((Element)itemEm, (String)"checkPoint")) {
                CheckPoint ckPoint = this.parseCheckPoint(ckPointEm, item, rule);
                String stLineId = XmlUtils.getAttribute((Element)ckPointEm, (String)"startLine");
                rule.addCheckPoint(ckPoint, (String)startLines.get(stLineId));
            }
        }
        Element dynamicEm = XmlUtils.getChild((Element)root, (String)"dynamicItem");
        if (null != dynamicEm) {
            rule.setDynamicItem(this.parseItem(dynamicEm));
            String dynaLogic = XmlUtils.getAttribute((Element)dynamicEm, (String)"type");
            rule.setDynamicLogic(this.buildDynamicLogic(dynaLogic));
        }
        Element combineLogicEm = XmlUtils.getChild((Element)root, (String)"combineLogic");
        rule.setCombineLogic(new CombineLogic(combineLogicEm));
        return rule;
    }

    private AnalyzeItem parseItem(Element itemEm) {
        AnalyzeItem item = new AnalyzeItem();
        item.setId(XmlUtils.getAttribute((Element)itemEm, (String)"id"));
        item.setNameEn(XmlUtils.getAttribute((Element)itemEm, (String)"nameEn"));
        item.setNameZh(XmlUtils.getAttribute((Element)itemEm, (String)"nameZh"));
        Element logicEm = XmlUtils.getChild((Element)itemEm, (String)"riskLogic");
        if (null != logicEm) {
            item.setCheckLogic(this.parseCheckLogic(logicEm));
        }
        return item;
    }

    private ICheckLogic parseCheckLogic(Element checkLogicEm) {
        String typeName = XmlUtils.getAttribute((Element)checkLogicEm, (String)"logicType");
        String logicClsName = "com.huawei.ism.tool.diskanalyze.rule.logic." + typeName;
        try {
            ClassLoader rClassLoader = RuleManager.class.getClassLoader();
            if (null == rClassLoader) {
                throw new ToolException("ClassLoader Load Failed");
            }
            Class<?> clazz = rClassLoader.loadClass(logicClsName);
            if (null == clazz) {
                throw new ToolException("ClassLoader Load Failed");
            }
            Class<ICheckLogic> ckClazz = clazz.asSubclass(ICheckLogic.class);
            Constructor<ICheckLogic> con = ckClazz.getConstructor(Element.class);
            return con.newInstance(checkLogicEm);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Load Check-Logic class error.");
            return null;
        }
        catch (SecurityException e) {
            LOGGER.error("Get constructor of Check-Logic class error.");
            return null;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Get constructor of Check-Logic class error.");
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Construct Check-Logic error by illegal args.");
            return null;
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Construct Check-Logic error by invoke target.");
            return null;
        }
        catch (InstantiationException e) {
            LOGGER.error("Initiate Check-Logic error.");
            return null;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Construct Check-Logic error by illegal access.");
            return null;
        }
        catch (ToolException e) {
            LOGGER.error("Load ClassLoader error");
            return null;
        }
    }

    private CheckPoint parseCheckPoint(Element ckPointEm, AnalyzeItem belongItem, Rule belongRule) {
        CheckPoint ckPoint = new CheckPoint();
        ckPoint.setId(XmlUtils.getAttribute((Element)ckPointEm, (String)"id"));
        ckPoint.setBelongItemId(belongItem.getId());
        ckPoint.setCheckLogic(belongItem.getCheckLogic());
        IValueParser parser = belongRule.getDefaultParser();
        String psName = XmlUtils.getAttribute((Element)ckPointEm, (String)"valueParser");
        if (!StringUtils.isNULLStr((String)psName)) {
            parser = psName.contains("HssdValueParser") ? new HssdValueParser(ckPointEm) : (psName.contains("MutilValueParser") ? new MutilValueParser(ckPointEm) : this.buildValueParser(psName));
        }
        if (null == parser) {
            parser = new KeyValueParser(ckPointEm);
        }
        ckPoint.setValueParser(parser);
        return ckPoint;
    }

    private IValueParser buildValueParser(String parserName) {
        String paserClsName = "com.huawei.ism.tool.diskanalyze.rule.parser." + parserName;
        try {
            ClassLoader rClassLoader = RuleManager.class.getClassLoader();
            if (null == rClassLoader) {
                throw new ToolException("ClassLoader Load Failed");
            }
            Class<?> clazz = rClassLoader.loadClass(paserClsName);
            if (null != clazz) {
                return clazz.asSubclass(IValueParser.class).newInstance();
            }
            throw new ToolException("ClassLoader Load Failed");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Load Value-Parser class error.");
            return null;
        }
        catch (InstantiationException e) {
            LOGGER.error("Init Value-Parser error.");
            return null;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Init Value-Parser error.");
            return null;
        }
        catch (ToolException e) {
            LOGGER.error("ClassLoader Load Failed");
            return null;
        }
    }

    private IDynamicLogic buildDynamicLogic(String dynamicType) {
        String logicClsName = "com.huawei.ism.tool.diskanalyze.rule.logic." + dynamicType;
        try {
            ClassLoader rClassLoader = RuleManager.class.getClassLoader();
            if (null == rClassLoader) {
                throw new ToolException("ClassLoader load failed");
            }
            Class<?> clazz = rClassLoader.loadClass(logicClsName);
            if (null != clazz) {
                return clazz.asSubclass(IDynamicLogic.class).newInstance();
            }
            throw new ToolException("ClassLoader load failed");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Load Value-Parser class error.");
            return null;
        }
        catch (InstantiationException e) {
            LOGGER.error("Init Value-Parser error.");
            return null;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Init Value-Parser error.");
            return null;
        }
        catch (ToolException e) {
            LOGGER.error("ClassLoader Load Failed");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDoc(String resource) {
        InputStream stream = FileUtils.getStreamWithObj(RuleManager.class, (String)resource);
        if (null == stream) {
            return null;
        }
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument((InputStream)stream);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)stream);
        }
        return doc;
    }
}

