/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.ICheckLogic;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public abstract class AbstractCheckLogic
implements ICheckLogic {
    private static final int DEFAULT_RADIX = 10;
    private static final String NO_RELATIVE_RISK = "NONE";
    private int radix = 10;
    private Integer defaultLevel = 0;
    private List<KeyValue<Integer, String>> riskLevelList = new ArrayList<KeyValue<Integer, String>>();
    private boolean relativeCheck = true;

    public AbstractCheckLogic(Element ckLogicEm) {
        String defLevelStr;
        String radixCfg = XmlUtils.getAttribute((Element)ckLogicEm, (String)"radix");
        if (!StringUtils.isNULLStr((String)radixCfg)) {
            this.radix = Integer.parseInt(radixCfg);
        }
        if (!StringUtils.isNULLStr((String)(defLevelStr = XmlUtils.getAttribute((Element)ckLogicEm, (String)"defaultRisk")))) {
            this.defaultLevel = Integer.valueOf(defLevelStr);
        }
        this.riskLevelList = this.parseRiskLevels(ckLogicEm);
        String relative = XmlUtils.getAttribute((Element)ckLogicEm, (String)"relative");
        if (NO_RELATIVE_RISK.equalsIgnoreCase(relative)) {
            this.relativeCheck = false;
        }
    }

    @Override
    public int getRelativeRisk(CheckPointValue ckValue, List<CheckPointValue> othersCkValue, String diskVender) {
        if (!this.hasRelativeCheck()) {
            return 0;
        }
        if (othersCkValue.isEmpty()) {
            return 0;
        }
        long avg = this.getOtherAvgValue(othersCkValue);
        return this.getRelativeRisk(ckValue, avg, diskVender);
    }

    protected long getOtherAvgValue(List<CheckPointValue> othersCkValue) {
        long total = 0L;
        for (CheckPointValue otherValue : othersCkValue) {
            long otherValueLong = this.toLongValue(otherValue.getValue());
            if (otherValueLong < 0L) continue;
            total += otherValueLong;
        }
        long avg = total / (long)othersCkValue.size();
        return avg;
    }

    @Override
    public boolean hasRelativeCheck() {
        return this.relativeCheck;
    }

    protected int getRelativeRisk(CheckPointValue ckValue, Long avgValue, String diskVender) {
        Long curValue = this.toLongValue(ckValue.getValue());
        if (curValue <= avgValue) {
            return 0;
        }
        int curAmount = curValue < 0L ? 0 : String.valueOf(curValue).length();
        int avgAmount = avgValue < 0L ? 0 : String.valueOf(avgValue).length();
        return curAmount - avgAmount;
    }

    protected final Integer getDefaultLevel() {
        return this.defaultLevel;
    }

    protected final List<KeyValue<Integer, String>> getRiskLevelList() {
        return this.riskLevelList;
    }

    protected final long toLongValue(String value) {
        return Long.parseLong(value, this.radix);
    }

    private List<KeyValue<Integer, String>> parseRiskLevels(Element em) {
        ArrayList<KeyValue<Integer, String>> riskLevels = new ArrayList<KeyValue<Integer, String>>();
        for (Element riskEm : XmlUtils.getChildren((Element)em, (String)"risk")) {
            String level = XmlUtils.getAttribute((Element)riskEm, (String)"level");
            Integer intLevel = Integer.parseInt(level);
            String refVal = XmlUtils.getAttribute((Element)riskEm, (String)"refValue");
            riskLevels.add((KeyValue<Integer, String>)new KeyValue((Object)intLevel, (Object)refVal));
        }
        return riskLevels;
    }
}

