/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.logic.DevTypeLengthComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public final class CommonCheckLogic {
    private static final CommonCheckLogic INSTANCE = new CommonCheckLogic();
    private Map<String, String> deviceSeries = new HashMap<String, String>();
    private List<String> deviceTypeList = new ArrayList<String>();
    private Map<String, Set<String>> supportedVersions = new HashMap<String, Set<String>>();
    private Map<String, Integer> venderDefValues = new HashMap<String, Integer>();
    private Map<String, String> promptMap = new HashMap<String, String>();
    private static final String KUNPENG = "Kunpeng";
    private Map<String, String> filterVersionMap = new HashMap<String, String>();

    private CommonCheckLogic() {
    }

    public static CommonCheckLogic getInstance() {
        return INSTANCE;
    }

    public static void initByConfig(Element parentEm) {
        CommonCheckLogic.INSTANCE.deviceSeries.putAll(CommonCheckLogic.parseDeviceSeries(parentEm));
        INSTANCE.setDevTypeList();
        CommonCheckLogic.INSTANCE.supportedVersions.putAll(CommonCheckLogic.parseDeviceVersion(parentEm));
        CommonCheckLogic.INSTANCE.venderDefValues.putAll(CommonCheckLogic.parseVenderDefValues(parentEm));
        INSTANCE.parseFilterVersion(parentEm);
    }

    public static Map<String, Integer> parseVenderDefValues(Element parentEm) {
        Element diskVendersEm = XmlUtils.getChild((Element)parentEm, (String)"diskVenders");
        if (null == diskVendersEm) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> venderDefValues = new HashMap<String, Integer>();
        String defValue = XmlUtils.getAttribute((Element)diskVendersEm, (String)"default");
        venderDefValues.put("DEFAULT", Integer.parseInt(defValue));
        for (Element vender : XmlUtils.getChildren((Element)diskVendersEm, (String)"vender")) {
            String vendorName = XmlUtils.getAttribute((Element)vender, (String)"name");
            String defaultValue = XmlUtils.getAttribute((Element)vender, (String)"defaultValue");
            venderDefValues.put(vendorName, Integer.parseInt(defaultValue));
        }
        return venderDefValues;
    }

    private static Map<String, String> parseDeviceSeries(Element parentEm) {
        Element devSeriesEm = XmlUtils.getChild((Element)parentEm, (String)"deviceSeries");
        if (null == devSeriesEm) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> deviceSeries = new HashMap<String, String>();
        deviceSeries.put("DEFAULT", XmlUtils.getAttribute((Element)devSeriesEm, (String)"default"));
        HashMap<String, String> promptMapSeries = new HashMap<String, String>();
        for (Element series : XmlUtils.getChildren((Element)devSeriesEm, (String)"series")) {
            String seriesName = XmlUtils.getAttribute((Element)series, (String)"name");
            for (Element verElem : XmlUtils.getChildren((Element)series, (String)"support-version")) {
                String devType = XmlUtils.getAttribute((Element)verElem, (String)"devType");
                deviceSeries.put(devType, seriesName);
                String prompt = XmlUtils.getAttribute((Element)verElem, (String)"prompt");
                if (null == prompt) continue;
                promptMapSeries.put(devType, prompt);
            }
        }
        CommonCheckLogic.INSTANCE.promptMap.putAll(promptMapSeries);
        return deviceSeries;
    }

    private static Map<String, Set<String>> parseDeviceVersion(Element parentEm) {
        Element devSeriesEm = XmlUtils.getChild((Element)parentEm, (String)"deviceSeries");
        if (null == devSeriesEm) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> devVersions = new HashMap<String, Set<String>>();
        for (Element series : XmlUtils.getChildren((Element)devSeriesEm, (String)"series")) {
            for (Element verElem : XmlUtils.getChildren((Element)series, (String)"support-version")) {
                String devType = XmlUtils.getAttribute((Element)verElem, (String)"devType");
                String versions = verElem.getTextContent();
                HashSet<String> verSet = new HashSet<String>();
                verSet.addAll(Arrays.asList(versions.split(",")));
                devVersions.put(devType, verSet);
            }
        }
        return devVersions;
    }

    private void parseFilterVersion(Element parentEm) {
        Element filterVersionMapsEm = XmlUtils.getChild((Element)parentEm, (String)"filterVersionMaps");
        if (null == filterVersionMapsEm) {
            return;
        }
        for (Element vender : XmlUtils.getChildren((Element)filterVersionMapsEm, (String)"filterVersionMap")) {
            String startKey = XmlUtils.getAttribute((Element)vender, (String)"startKey");
            String version = XmlUtils.getAttribute((Element)vender, (String)"version");
            this.filterVersionMap.put(startKey, version);
        }
    }

    public boolean needFilter(String version) {
        for (String startKey : this.filterVersionMap.keySet()) {
            int ruslt;
            if (!version.startsWith(startKey)) continue;
            if (version.contains(KUNPENG)) {
                version = version.replace(KUNPENG, "").trim();
            }
            if ((ruslt = version.compareToIgnoreCase(this.filterVersionMap.get(startKey))) != 1 && ruslt != 0) continue;
            return true;
        }
        return false;
    }

    public String getDeviceSeries(String devType) {
        String series = "";
        for (Map.Entry<String, String> type : this.deviceSeries.entrySet()) {
            if (!devType.equals(type.getKey())) continue;
            series = type.getValue();
        }
        return series;
    }

    public String getValidDevType(String devType) {
        for (String validType : this.deviceTypeList) {
            if (!devType.contains(validType)) continue;
            return validType;
        }
        return devType;
    }

    private void setDevTypeList() {
        for (Map.Entry<String, String> validType : this.deviceSeries.entrySet()) {
            this.deviceTypeList.add(validType.getKey());
        }
        DevTypeLengthComparator comparator = new DevTypeLengthComparator();
        Collections.sort(this.deviceTypeList, comparator);
    }

    public boolean isVersionSupported(String devType, String version) {
        Set<String> subVers = this.supportedVersions.get(devType);
        if (null == subVers) {
            return false;
        }
        for (String subVersion : subVers) {
            if (subVersion.endsWith("+")) {
                return this.checkSpecialversion(version, subVersion);
            }
            if (!CommonCheckLogic.contains(version, subVersion)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(String devVersion, String subVersion) {
        if (devVersion.contains(KUNPENG) && subVersion.contains(KUNPENG)) {
            return devVersion.replace(KUNPENG, "").trim().contains(subVersion.replace(KUNPENG, "").trim());
        }
        if (devVersion.contains(KUNPENG) && !subVersion.contains(KUNPENG) || !devVersion.contains(KUNPENG) && subVersion.contains(KUNPENG)) {
            return false;
        }
        return devVersion.trim().contains(subVersion.trim());
    }

    private boolean checkSpecialversion(String version, String subVersion) {
        if (version.contains(KUNPENG) && subVersion.contains(KUNPENG)) {
            version = version.replace(KUNPENG, "").trim();
            subVersion = subVersion.replace(KUNPENG, "").trim();
        }
        return version.compareTo(subVersion.substring(0, subVersion.length() - 1)) >= 0;
    }

    public Map<String, String> getDeviceSeriesMap() {
        return this.deviceSeries;
    }

    public Map<String, Integer> getCommonDefaultValues() {
        return new HashMap<String, Integer>(this.venderDefValues);
    }

    public Map<String, Set<String>> getSupportedVersions() {
        return this.supportedVersions;
    }

    public Map<String, String> getPromptMap() {
        return this.promptMap;
    }

    public void setPromptMap(Map<String, String> promptMap) {
        this.promptMap = promptMap;
    }
}

