/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Equal
extends AbstractCheckLogic {
    private Map<Long, Integer> riskLevelMap = new HashMap<Long, Integer>();

    public Equal(Element ckLogicEm) {
        super(ckLogicEm);
        for (KeyValue<Integer, String> riskLevel : super.getRiskLevelList()) {
            String[] refVals = ((String)riskLevel.getValue()).split(",");
            Integer level = (Integer)riskLevel.getKey();
            for (String refVal : refVals) {
                this.riskLevelMap.put(this.toLongValue(refVal), level);
            }
        }
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        Long value = this.toLongValue(ckVal.getValue());
        if (value < 0L) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        Integer level = this.riskLevelMap.get(value);
        return null != level ? level : this.getDefaultLevel();
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }
}

