/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class EqualBySeries
extends AbstractCheckLogic {
    private Map<String, Map<String, Integer>> seriesRiskLevelMap = new HashMap<String, Map<String, Integer>>();

    public EqualBySeries(Element ckLogicEm) {
        super(ckLogicEm);
        for (KeyValue<Integer, String> riskLevel : super.getRiskLevelList()) {
            for (String seriesVal : ((String)riskLevel.getValue()).split(",")) {
                String[] value = seriesVal.split(":");
                String series = value[0];
                Map<String, Integer> riskLevelMap = this.seriesRiskLevelMap.get(series);
                if (null == riskLevelMap) {
                    riskLevelMap = new HashMap<String, Integer>();
                    this.seriesRiskLevelMap.put(series, riskLevelMap);
                }
                riskLevelMap.put(value[1], (Integer)riskLevel.getKey());
            }
        }
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) {
        Integer level;
        String series = CommonCheckLogic.getInstance().getDeviceSeries(devType);
        if (null == series) {
            series = CommonCheckLogic.getInstance().getDeviceSeries("DEFAULT");
        }
        return null != (level = this.seriesRiskLevelMap.get(series).get(ckVal.getValue())) ? level : this.getDefaultLevel();
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }
}

