/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import java.util.Locale;
import org.w3c.dom.Element;

public class HnvmeCheckLogic
extends AbstractCheckLogic {
    public HnvmeCheckLogic(Element ckLogicEm) {
        super(ckLogicEm);
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        long value = 0L;
        String valueStr = ckVal.getValue();
        if (valueStr.startsWith("0x") || valueStr.startsWith("0X")) {
            valueStr = valueStr.toLowerCase(Locale.US).replace("0x", "");
            value = Long.valueOf(valueStr, 16);
        } else {
            value = Long.valueOf(valueStr);
        }
        if (value < 0L || value > 255L) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        String binaryStr = Long.toBinaryString(value);
        int count = 0;
        int riskLevel = 0;
        int length = binaryStr.length();
        for (int i = length - 1; i >= 0; --i) {
            if (i == length - 2) {
                ++count;
                continue;
            }
            if (count >= 5) continue;
            ++count;
            if (binaryStr.charAt(i) != '1') continue;
            riskLevel = super.getDefaultLevel();
            break;
        }
        return riskLevel;
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }
}

