/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class InSection
extends AbstractCheckLogic {
    private Map<Integer, KeyValue<Long, Long>> riskLevelMap = new HashMap<Integer, KeyValue<Long, Long>>();
    private int roundUnit = 1;

    public InSection(Element ckLogicEm) {
        super(ckLogicEm);
        for (KeyValue<Integer, String> riskLevel : super.getRiskLevelList()) {
            String[] refVals = ((String)riskLevel.getValue()).split(",");
            Long minVal = this.toLongValue(refVals[0]);
            Long maxVal = this.toLongValue(refVals[1]);
            Integer level = (Integer)riskLevel.getKey();
            this.riskLevelMap.put(level, (KeyValue<Long, Long>)new KeyValue((Object)minVal, (Object)maxVal));
        }
        String unit = XmlUtils.getAttribute((Element)ckLogicEm, (String)"roundUnit");
        if (!StringUtils.isNULLStr((String)unit)) {
            this.roundUnit = Integer.parseInt(unit);
        }
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        Integer level = this.getDefaultLevel();
        Double doubleValue = Double.valueOf(ckVal.getValue());
        if (doubleValue < 0.0) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        Long value = Math.round(Math.ceil(doubleValue / (double)this.roundUnit)) * (long)this.roundUnit;
        for (Map.Entry<Integer, KeyValue<Long, Long>> entry : this.riskLevelMap.entrySet()) {
            KeyValue<Long, Long> section = entry.getValue();
            if (value <= (Long)section.getKey() || value > (Long)section.getValue()) continue;
            level = entry.getKey();
            break;
        }
        return level;
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }
}

