/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.SataCheckLogic;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class InSectionByExp
extends SataCheckLogic {
    private static final String FUNCTION = "function ";
    private static final String FUNC_NAME = "isMeet_";
    private static final String FUNC_BODY = "(V, W, T, D) { return (min) && (max); } ";
    private static final String GREATER_THAN = "V >";
    private static final String LESS_THAN = "V <";
    private static final String INCLUDING_EQUAL_FLAG = "[";
    private static final String INCLUDING_EQUAL_FLAG_END = "]";
    private static final String EQUAL = "=";
    private static final String DEFAULT_EXP = "true";
    private Map<Integer, String> riskLevelMap = new HashMap<Integer, String>();

    public InSectionByExp(Element ckLogicEm) {
        super(ckLogicEm);
        StringBuffer script = new StringBuffer();
        for (KeyValue<Integer, String> riskLevel : super.getRiskLevelList()) {
            Integer level = (Integer)riskLevel.getKey();
            String funcName = FUNC_NAME + level;
            String function = this.buildFunction((String)riskLevel.getValue(), funcName);
            script.append(function);
            this.riskLevelMap.put(level, funcName);
        }
        super.installScript(script.toString());
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        Integer deafultVal = this.getDefaultValue(diskVender);
        long ckValValue = this.toLongValue(ckVal.getValue());
        long ckValWorst = this.toLongValue(ckVal.getWorst());
        long ckValThreshold = this.toLongValue(ckVal.getThreshold());
        if (ckValValue < 0L || ckValWorst < 0L || ckValThreshold < 0L) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        Object[] params = new Object[]{ckValValue, ckValWorst, ckValThreshold, deafultVal};
        Integer level = this.getDefaultLevel();
        for (Map.Entry<Integer, String> entry : this.riskLevelMap.entrySet()) {
            String funcName = entry.getValue();
            Boolean meet = (Boolean)super.execScript(funcName, params);
            if (!meet.booleanValue()) continue;
            level = entry.getKey();
            break;
        }
        return level;
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        Long rawValue = this.toLongValue(ckVal.getRaw());
        if (rawValue <= 0L) {
            return 0;
        }
        if (rawValue <= 100L) {
            return 1;
        }
        if (rawValue <= 150L) {
            return 2;
        }
        if (rawValue <= 200L) {
            return 3;
        }
        if (rawValue <= 250L) {
            return 4;
        }
        if (rawValue <= 300L) {
            return 5;
        }
        if (rawValue <= 350L) {
            return 6;
        }
        if (rawValue <= 400L) {
            return 7;
        }
        if (rawValue <= 450L) {
            return 8;
        }
        if (rawValue <= 500L) {
            return 9;
        }
        return 10;
    }

    private String buildFunction(String refVal, String funcName) {
        String[] refVals = refVal.split(",");
        String minExp = this.buildExpression(GREATER_THAN, refVals[0].trim());
        String maxExp = this.buildExpression(LESS_THAN, refVals[1].trim());
        if (refVals[0].trim().equals("[W]") && refVals[1].trim().equals("[D]")) {
            minExp = "V == W";
            maxExp = "V == D";
        }
        String body = FUNC_BODY.replace("min", minExp);
        body = body.replace("max", maxExp);
        return FUNCTION + funcName + body;
    }

    private String buildExpression(String operator, String refExpression) {
        if (StringUtils.isNULLStr((String)refExpression)) {
            return DEFAULT_EXP;
        }
        if (refExpression.startsWith(INCLUDING_EQUAL_FLAG)) {
            return operator + EQUAL + refExpression.substring(1, refExpression.length() - 1);
        }
        return operator + refExpression;
    }
}

