/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.Equal;
import org.w3c.dom.Element;

public class LessEqual
extends Equal {
    private int roundUnit = 1;

    public LessEqual(Element ckLogicEm) {
        super(ckLogicEm);
        this.roundUnit = Integer.parseInt(XmlUtils.getAttribute((Element)ckLogicEm, (String)"roundUnit"));
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        Double doubleValue = Double.valueOf(ckVal.getValue());
        if (doubleValue < 0.0) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        Long roundedValue = Math.round(Math.ceil(doubleValue / (double)this.roundUnit)) * (long)this.roundUnit;
        return super.getRiskLevel(devType, diskVender, new CheckPointValue(String.valueOf(roundedValue)));
    }
}

