/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class MutilEqual
extends AbstractCheckLogic {
    private Map<RiskLevel, Integer> mutilRiskLevels = new HashMap<RiskLevel, Integer>();

    public MutilEqual(Element ckLogicEm) {
        super(ckLogicEm);
        this.parseMutilRiskLevels(ckLogicEm);
    }

    private void parseMutilRiskLevels(Element em) {
        for (Element mutilRiskEm : XmlUtils.getChildren((Element)em, (String)"mutilRisk")) {
            String level = XmlUtils.getAttribute((Element)mutilRiskEm, (String)"level");
            Integer intLevel = Integer.parseInt(level);
            RiskLevel riskLevel = new RiskLevel();
            for (Element conditionEle : XmlUtils.getChildren((Element)mutilRiskEm, (String)"condition")) {
                String modelRegx = XmlUtils.getAttribute((Element)conditionEle, (String)"modelRegx");
                riskLevel.setModelRegx(modelRegx);
            }
            HashMap<String, Long> refValueMap = new HashMap<String, Long>();
            riskLevel.setRefValueMap(refValueMap);
            for (Element valueEle : XmlUtils.getChildren((Element)mutilRiskEm, (String)"value")) {
                String key = XmlUtils.getAttribute((Element)valueEle, (String)"key");
                String refValue = XmlUtils.getAttribute((Element)valueEle, (String)"refValue");
                refValueMap.put(key, this.toLongValue(refValue));
            }
            this.mutilRiskLevels.put(riskLevel, intLevel);
        }
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return this.getDefaultLevel();
    }

    public int getMutilRiskLevel(AnalyzeDisk disk, CheckPointValue ckVal) throws InvalidNumberException {
        Map<String, Long> originalMutilValue = this.getOriginalMutilValueMap(ckVal.getMutilValue());
        Set<Map.Entry<RiskLevel, Integer>> mutilRiskLevelsEntry = this.mutilRiskLevels.entrySet();
        for (Map.Entry<RiskLevel, Integer> entry : mutilRiskLevelsEntry) {
            if (!entry.getKey().match(disk) || !entry.getKey().isRisk(originalMutilValue)) continue;
            return entry.getValue();
        }
        return this.getDefaultLevel();
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }

    public Map<String, Long> getOriginalMutilValueMap(Map<String, String> ckValues) throws InvalidNumberException {
        HashMap<String, Long> originalMutilValue = new HashMap<String, Long>();
        Set<Map.Entry<String, String>> mutilCkValue = ckValues.entrySet();
        for (Map.Entry<String, String> ckValue : mutilCkValue) {
            Long value = this.toLongValue(ckValue.getValue());
            if (value < 0L) {
                throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
            }
            originalMutilValue.put(ckValue.getKey(), value);
        }
        return originalMutilValue;
    }

    private class RiskLevel {
        String modelRegx = "";
        Map<String, Long> refValueMap = new HashMap<String, Long>();

        private RiskLevel() {
        }

        public void setModelRegx(String modelRegx) {
            this.modelRegx = modelRegx;
        }

        public void setRefValueMap(Map<String, Long> refValueMap) {
            this.refValueMap = refValueMap;
        }

        public boolean match(AnalyzeDisk disk) {
            if (!StringUtils.isNULLStr((String)this.modelRegx)) {
                return disk.getModel().matches(this.modelRegx);
            }
            return true;
        }

        public boolean isRisk(Map<String, Long> originalMutilValue) {
            Set<Map.Entry<String, Long>> refValueEntry = this.refValueMap.entrySet();
            for (Map.Entry<String, Long> refValue : refValueEntry) {
                if (!refValue.getValue().equals(originalMutilValue.get(refValue.getKey()))) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.modelRegx == null ? 0 : this.modelRegx.hashCode());
            result = 31 * result + (this.refValueMap == null ? 0 : this.refValueMap.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RiskLevel other = (RiskLevel)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.modelRegx == null ? other.modelRegx != null : !this.modelRegx.equals(other.modelRegx)) {
                return false;
            }
            return !(this.refValueMap == null ? other.refValueMap != null : !this.refValueMap.equals(other.refValueMap));
        }

        private MutilEqual getOuterType() {
            return MutilEqual.this;
        }
    }
}

