/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.logic.AbstractCheckLogic;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public abstract class SataCheckLogic
extends AbstractCheckLogic {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SataCheckLogic.class);
    private static final String FUNCTION = "function ";
    private static final String FUNC_NAME_RELATIVE = "calcRelative";
    private static final String FUNC_BODY_RELATIVE = "(VALUE, WORST, T, D, AVG) { return (relaExp); } ";
    private Map<String, Integer> venderDefValues;
    private ScriptEngine scriptEngine = null;
    private String relativeScript = "";

    public SataCheckLogic(Element ckLogicEm) {
        super(ckLogicEm);
        ScriptEngineManager sem;
        ScriptEngine scriptengine;
        this.venderDefValues = CommonCheckLogic.parseVenderDefValues(ckLogicEm);
        if (this.venderDefValues.isEmpty()) {
            this.venderDefValues.putAll(CommonCheckLogic.getInstance().getCommonDefaultValues());
        }
        if (null != (scriptengine = (sem = new ScriptEngineManager()).getEngineByName("JavaScript"))) {
            this.scriptEngine = scriptengine;
        }
        String relativeExp = XmlUtils.getAttribute((Element)ckLogicEm, (String)"relative");
        this.relativeScript = this.buildRelaFunction(relativeExp);
        this.evalScript(this.relativeScript);
    }

    @Override
    public int getRelativeRisk(CheckPointValue ckVal, Long avgValue, String diskVender) {
        Integer deafultVal = this.getDefaultValue(diskVender);
        Object[] objectArray = new Object[]{ckVal.getValue(), ckVal.getWorst(), ckVal.getThreshold(), deafultVal, avgValue};
        Object[] params = objectArray;
        Double ret = (Double)this.execScript(FUNC_NAME_RELATIVE, params);
        if (ret < 0.0) {
            return 0;
        }
        return (int)Math.round(ret);
    }

    protected void installScript(String script) {
        this.evalScript(script + this.relativeScript);
    }

    protected Integer getDefaultValue(String diskVender) {
        Integer deafultVal = this.venderDefValues.get(diskVender);
        if (null == deafultVal) {
            deafultVal = this.venderDefValues.get("DEFAULT");
        }
        return deafultVal;
    }

    protected Object execScript(String funcName, Object ... params) {
        try {
            return ((Invocable)((Object)this.scriptEngine)).invokeFunction(funcName, params);
        }
        catch (ScriptException e) {
            LOGGER.error("run js error:" + funcName);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("No method error:" + funcName);
        }
        return null;
    }

    private void evalScript(String script) {
        if (null == this.scriptEngine) {
            throw new NullPointerException();
        }
        try {
            this.scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            LOGGER.error("Init exp script error.");
        }
    }

    private String buildRelaFunction(String relativeExp) {
        String exp = StringUtils.isNULLStr((String)relativeExp) ? String.valueOf(0) : relativeExp;
        String body = FUNC_BODY_RELATIVE.replace("relaExp", exp);
        return "function calcRelative" + body;
    }
}

