/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.SataCheckLogic;
import java.util.List;
import org.w3c.dom.Element;

public class Worst
extends SataCheckLogic {
    public Worst(Element ckLogicEm) {
        super(ckLogicEm);
    }

    @Override
    public int getRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        long worst = this.toLongValue(ckVal.getWorst());
        long threshold = this.toLongValue(ckVal.getThreshold());
        if (worst < 0L || threshold < 0L) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        return worst < threshold ? 10 : 0;
    }

    @Override
    protected long getOtherAvgValue(List<CheckPointValue> othersCkValue) {
        long total = 0L;
        for (CheckPointValue otherValue : othersCkValue) {
            long otherValueLong = this.toLongValue(otherValue.getWorst());
            if (otherValueLong < 0L) continue;
            total += otherValueLong;
        }
        long avg = total / (long)othersCkValue.size();
        return avg;
    }

    @Override
    public int getRawRiskLevel(String devType, String diskVender, CheckPointValue ckVal) throws InvalidNumberException {
        return 0;
    }
}

