/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.parser;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.IValueParser;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class HssdValueParser
implements IValueParser {
    private static final int V_INX = 0;
    private static final int T_INX = 3;
    private String key;

    public HssdValueParser(Element ckPointEm) {
        this.key = XmlUtils.getAttribute((Element)ckPointEm, (String)"key");
    }

    @Override
    public CheckPointValue getValue(String[] logLines, int startLine) {
        ArrayList<String> columns = new ArrayList<String>();
        String keyLine = "";
        for (int i = startLine; i < logLines.length; ++i) {
            String line = logLines[i];
            if (!line.trim().startsWith(this.key)) continue;
            keyLine = line;
            break;
        }
        if (StringUtils.isNULLStr((String)keyLine)) {
            return null;
        }
        keyLine = keyLine.replace(this.key, "").trim();
        for (String str : keyLine.split(" ")) {
            if (str.length() <= 0 || " ".equals(str)) continue;
            columns.add(str);
        }
        CheckPointValue ckValue = new CheckPointValue();
        ckValue.setValue((String)columns.get(this.getValueColumnInx()));
        ckValue.setThreshold((String)columns.get(3));
        return ckValue;
    }

    protected int getValueColumnInx() {
        return 0;
    }

    public String getKey() {
        return this.key;
    }
}

