/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.rule.parser;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.IValueParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class KeyValueParser
implements IValueParser {
    protected String key;
    protected List<String> replaceStrList;
    protected static final String DHA_KEY = "Health Mark For DHA";
    protected List<String> dhaList = new ArrayList<String>();

    public KeyValueParser() {
        this.key = DHA_KEY;
        this.replaceStrList = this.dhaList;
    }

    public KeyValueParser(Element ckPointEm) {
        this.key = XmlUtils.getAttribute((Element)ckPointEm, (String)"key");
        String repStrCfg = XmlUtils.getAttribute((Element)ckPointEm, (String)"replaceStr");
        this.replaceStrList = !StringUtils.isNULLStr((String)repStrCfg) ? Arrays.asList(repStrCfg.split(",")) : new ArrayList<String>();
    }

    @Override
    public CheckPointValue getValue(String[] logLines, int startLine) {
        String valueStr = "";
        for (int i = startLine; i < logLines.length; ++i) {
            int inx = logLines[i].indexOf(this.key);
            if (inx < 0) continue;
            valueStr = this.getValueStr(logLines[i].substring(inx + this.key.length()));
            break;
        }
        return new CheckPointValue(valueStr.trim());
    }

    protected String getValueStr(String str) {
        String valueStr;
        int inx = str.indexOf("=");
        if (inx < 0) {
            inx = str.indexOf(":");
        }
        if ((valueStr = str.substring(inx + 1).trim()).contains("=") || valueStr.contains(":")) {
            valueStr = valueStr.split(" ")[0];
        }
        for (String repStr : this.replaceStrList) {
            valueStr = valueStr.replaceAll(repStr, "");
        }
        valueStr = valueStr.replaceAll("\t", " ").trim();
        valueStr = valueStr.split(" ")[0];
        return valueStr;
    }
}

