/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.service.impl;

import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.DiskDomain;
import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.entity.StoragePool;
import com.huawei.ism.tool.diskanalyze.entity.StoragePoolTier;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.service.IDiskDomainParse;
import com.huawei.ism.tool.diskanalyze.util.PoolFileParseUtils;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDiskDomainParse
implements IDiskDomainParse {
    private static final Logger log = LoggerFactory.getLogger(DefaultDiskDomainParse.class);
    private static final String SPLIT_SIGN = ":";
    private static final String FRAME_SLOT_SPLIT_SIGN = ".";
    private static final Pattern DISK_START = Pattern.compile("^member disk info.*?---");
    private static final Pattern POOL_START = Pattern.compile("^storage.*?pool.*?---");
    private static final Pattern DOMAIN_START = Pattern.compile("^disk domain info.*?---");

    @Override
    public List<DiskDomain> parse(InputStream in) {
        if (in == null) {
            return Collections.emptyList();
        }
        try {
            return this.parse(IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        catch (UncheckedIOException e) {
            log.error("read disk domain error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("read disk domain error by " + e.getClass(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<DiskDomain> parse(List<String> lines) {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        List<DiskDomain> diskDomains = Collections.emptyList();
        List<StoragePool> storagePools = Collections.emptyList();
        List<AnalyzeDisk> allDisk = Collections.emptyList();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i).toLowerCase(Locale.ROOT);
            if (this.isDiskDomainStart(line)) {
                Function<List, DiskDomain> parseDiskDomain = this::parseSingleDiskDomain;
                diskDomains = PoolFileParseUtils.parseList(lines.subList(i, lines.size()), "^\\s{1,4}disk domain id:", parseDiskDomain);
                continue;
            }
            if (this.isStoragePoolStart(line)) {
                Function<List, StoragePool> parseStoragePool = this::parseSingleStoragePool;
                storagePools = PoolFileParseUtils.parseList(lines.subList(i, lines.size()), this.getStoragePoolSplit(), parseStoragePool);
                continue;
            }
            if (!this.isAllDiskStart(line)) continue;
            Function<List, AnalyzeDisk> parseDisk = this::parseSingleDisk;
            allDisk = PoolFileParseUtils.parseList(lines.subList(i, lines.size()), "disk id", parseDisk);
        }
        this.makeUpDiskDomain(diskDomains, storagePools, allDisk);
        return diskDomains;
    }

    private boolean isAllDiskStart(String line) {
        return line.contains("member disk info") && DISK_START.matcher(line).find();
    }

    private boolean isStoragePoolStart(String line) {
        return line.contains("storage") && POOL_START.matcher(line).find();
    }

    private boolean isDiskDomainStart(String line) {
        return line.contains("disk domain info") && DOMAIN_START.matcher(line).find();
    }

    protected String getStoragePoolSplit() {
        return "^\\s{1,4}storage pool id:";
    }

    private void makeUpDiskDomain(List<DiskDomain> diskDomains, List<StoragePool> storagePools, List<AnalyzeDisk> disks) {
        if (storagePools != null) {
            Map<String, List<StoragePool>> poolGroup = storagePools.stream().filter(pool -> pool.getDiskDomainId() != null).collect(Collectors.groupingBy(StoragePool::getDiskDomainId));
            diskDomains.forEach(diskDomain -> diskDomain.setStoragePools((List)poolGroup.get(diskDomain.getId())));
        }
        if (disks != null) {
            Map<String, List<AnalyzeDisk>> diskByDomainId = disks.stream().filter(disk -> disk.getDiskDomainId() != null).collect(Collectors.groupingBy(AnalyzeDisk::getDiskDomainId));
            diskDomains.forEach(diskDomain -> diskDomain.setDisks((List)diskByDomainId.get(diskDomain.getId())));
        }
    }

    protected StoragePool parseSingleStoragePool(List<String> lines) {
        StoragePool storagePool = new StoragePool();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (storagePool.getId() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Storage Pool ID:")) {
                storagePool.setId(this.getLineValue(line));
            }
            if (storagePool.getName() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Storage Pool Name:")) {
                storagePool.setName(this.getLineValue(line));
            }
            if (storagePool.getDiskDomainId() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Storage Pool Disk Pool Id:")) {
                storagePool.setDiskDomainId(this.getLineValue(line));
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk Type:")) continue;
            Function<List, StoragePoolTier> parseTier = this::parseSingeTier;
            storagePool.setTiers(PoolFileParseUtils.parseList(lines.subList(i, lines.size()), "disk type:", parseTier));
            break;
        }
        return storagePool;
    }

    private StoragePoolTier parseSingeTier(List<String> lines) {
        StoragePoolTier tier = new StoragePoolTier();
        for (String line : lines) {
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk Type:")) {
                tier.setDiskType(DiskType.getDiskType(this.getLineValue(line)));
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Raid Level:")) {
                RaidLevel raidLevel = RaidLevel.getRaidLeve(this.getLineValue(line));
                log.info("{} get raid level is {}", (Object)line, (Object)raidLevel);
                tier.setRaidLevel(raidLevel);
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Raid Disk Number:")) continue;
            tier.setDiskNumber(Integer.parseInt(this.getLineValue(line)));
        }
        return tier;
    }

    private DiskDomain parseSingleDiskDomain(List<String> lines) {
        DiskDomain diskDomain = new DiskDomain();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (diskDomain.getId() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"disk domain id:")) {
                diskDomain.setId(this.getLineValue(line));
            }
            if (diskDomain.getName() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"disk domain name:")) {
                diskDomain.setName(this.getLineValue(line));
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"member disk info of disk")) continue;
            Function<List, AnalyzeDisk> parseDisk = this::parseSingleDisk;
            List<AnalyzeDisk> disks = PoolFileParseUtils.parseList(lines.subList(i, lines.size()), "disk id", parseDisk);
            diskDomain.setDisks(disks);
            break;
        }
        return diskDomain;
    }

    private AnalyzeDisk parseSingleDisk(List<String> lines) {
        AnalyzeDisk disk = new AnalyzeDisk();
        for (String line : lines) {
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk ID:")) {
                disk.setId(this.getLineValue(line));
                continue;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk Domain ID:")) {
                disk.setDiskDomainId(this.getLineValue(line));
                continue;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"disk frame")) {
                disk.setEnclosureNo(this.getFrame(line));
                disk.setSlotNo(this.getSlot(line));
                continue;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"disk serial number:") || StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk SN:")) {
                disk.setSn(this.getLineValue(line));
                continue;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"disk type:")) continue;
            disk.setRealDiskType(this.getLineValue(line));
            disk.setType(DiskType.getDiskType(disk.getShowDiskType()));
        }
        return disk;
    }

    protected String getLineValue(String line) {
        return line.contains(SPLIT_SIGN) ? line.split(SPLIT_SIGN)[1].trim() : "";
    }

    protected String getFrame(String line) {
        String frameSlot = this.getLineValue(line);
        return frameSlot.contains(FRAME_SLOT_SPLIT_SIGN) ? frameSlot.substring(0, frameSlot.indexOf(FRAME_SLOT_SPLIT_SIGN)).trim() : "";
    }

    protected String getSlot(String line) {
        String frameSlot = this.getLineValue(line);
        return frameSlot.contains(FRAME_SLOT_SPLIT_SIGN) ? frameSlot.substring(frameSlot.indexOf(FRAME_SLOT_SPLIT_SIGN) + 1).trim() : "";
    }
}

