/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.service.impl;

import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.entity.StoragePool;
import com.huawei.ism.tool.diskanalyze.entity.StoragePoolTier;
import com.huawei.ism.tool.diskanalyze.service.impl.DefaultDiskDomainParse;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DoradoDiskDomainParse
extends DefaultDiskDomainParse {
    private final Pattern pattern = Pattern.compile("frame:(\\d+).*?slot:.*?(\\d+)");

    @Override
    protected StoragePool parseSingleStoragePool(List<String> lines) {
        StoragePool storagePool = super.parseSingleStoragePool(lines);
        storagePool.setTiers(this.parseTiers(lines));
        return storagePool;
    }

    @NotNull
    private List<StoragePoolTier> parseTiers(List<String> lines) {
        return lines.stream().filter(this::isTierStart).map(this::parseTier).collect(Collectors.toList());
    }

    private boolean isTierStart(String line) {
        return StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"RAID Level:");
    }

    private StoragePoolTier parseTier(String line) {
        StoragePoolTier tier = new StoragePoolTier();
        tier.setRaidLevel(RaidLevel.getRaidLeve(this.getLineValue(line)));
        return tier;
    }

    @Override
    protected String getFrame(String line) {
        Matcher matcher = this.pattern.matcher(line.toLowerCase(Locale.ROOT));
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return super.getFrame(line);
    }

    @Override
    protected String getSlot(String line) {
        Matcher matcher = this.pattern.matcher(line.toLowerCase(Locale.ROOT));
        if (matcher.find()) {
            return matcher.group(2).trim();
        }
        return super.getSlot(line);
    }
}

