/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.service.impl;

import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import com.huawei.ism.tool.diskanalyze.entity.StoragePool;
import com.huawei.ism.tool.diskanalyze.entity.StoragePoolTier;
import com.huawei.ism.tool.diskanalyze.service.impl.DoradoDiskDomainParse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DoradoV6DiskDomainParse
extends DoradoDiskDomainParse {
    @Override
    protected String getStoragePoolSplit() {
        return "\\s{3}id:";
    }

    @Override
    protected StoragePool parseSingleStoragePool(List<String> lines) {
        StoragePool storagePool = new StoragePool();
        storagePool.setTiers(this.parseTiers(lines));
        lines.forEach(line -> this.configStoragePool(storagePool, (String)line));
        return storagePool;
    }

    @NotNull
    private List<StoragePoolTier> parseTiers(List<String> lines) {
        return lines.stream().map(this::parseTier).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private void configStoragePool(StoragePool storagePool, String line) {
        this.configId(storagePool, line);
        this.configName(storagePool, line);
        this.configDomainId(storagePool, line);
    }

    @NotNull
    private Optional<StoragePoolTier> parseTier(String line) {
        if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"RAID Level:")) {
            StoragePoolTier tier = new StoragePoolTier();
            RaidLevel raidLeve = RaidLevel.getRaidLeve(this.getLineValue(line));
            tier.setRaidLevel(raidLeve);
            return Optional.of(tier);
        }
        return Optional.empty();
    }

    private void configDomainId(StoragePool storagePool, String line) {
        if (storagePool.getDiskDomainId() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Disk Pool Id:")) {
            storagePool.setDiskDomainId(this.getLineValue(line));
        }
    }

    private void configName(StoragePool storagePool, String line) {
        if (storagePool.getName() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Name:")) {
            storagePool.setName(this.getLineValue(line));
        }
    }

    private void configId(StoragePool storagePool, String line) {
        if (storagePool.getId() == null && StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"ID:")) {
            storagePool.setId(this.getLineValue(line));
        }
    }
}

