/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.export;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.silent.main.DiskHealthAnalyzeSilentProcess;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskHealthAnalyzeSilentProcessAction {
    private static final Logger log = LoggerFactory.getLogger(DiskHealthAnalyzeSilentProcessAction.class);
    private static DiskHealthAnalyzeSilentProcessAction instance = new DiskHealthAnalyzeSilentProcessAction();
    private static DiskAnalyzeContext context = DiskAnalyzeContext.getInstance();

    public static DiskHealthAnalyzeSilentProcessAction getInstance() {
        return instance;
    }

    public void start(String path, String language, String devCount) {
        this.parseDevCount(devCount);
        List<File> delFiles = context.getFileToDel();
        delFiles.clear();
        this.initSilentProgress();
        File[] files = new File(FilePathUtils.checkFile((String)path)).listFiles();
        if (null == files || files.length == 0) {
            log.error("get analyze file paths error, list files of " + StringUtils.getCleanMessage((String)path) + " failed.");
            DiskAnalyzeContext.getInstance().updateTotalResultWxisting();
            context.exitSysAndSetExitCode(20);
            return;
        }
        new DiskHealthAnalyzeSilentProcess(path, language).start();
    }

    private void parseDevCount(String devCount) {
        if (null == devCount || devCount.trim().isEmpty()) {
            log.error("devCOunt got from env is null or empty, set taskCount to -1.");
            context.setTaskCount(-1);
            return;
        }
        try {
            int count = Integer.parseInt(devCount.trim());
            context.setTaskCount(count > 0 ? count : -1);
            log.info("devCount got from env: {}, set taskCount to: {}", (Object)StringUtils.getCleanMessage((String)devCount), (Object)context.getTaskCount());
        }
        catch (NumberFormatException e) {
            log.error("parse devCount error: {}, set taskCount to -1.", (Object)StringUtils.getCleanMessage((String)devCount));
            context.setTaskCount(-1);
        }
    }

    private void initSilentProgress() {
        SilentProcessData startData = new SilentProcessData(String.valueOf(70));
        startData.setResult("");
        startData.setStatus("running");
        SilentProcessToFile.updateProcessData((SilentProcessData)startData, (String)context.getProgressPath());
    }
}

