/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.main;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.exception.OutOfDiskSpaceException;
import com.huawei.ism.tool.diskanalyze.silent.silentanalyze.FinalSummaryReport;
import com.huawei.ism.tool.diskanalyze.silent.silentanalyze.SilentSingleDevAnalyzeRunnable;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeConstants;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ParseWorktakerImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import utils.FilesUtil;

public class DiskHealthAnalyzeSilentProcess
extends Thread {
    private static final int WAIT_TIME = 5000;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DiskHealthAnalyzeSilentProcess.class);
    private DiskAnalyzeContext context = DiskAnalyzeContext.getInstance();
    private String path = "";
    private String language;

    public DiskHealthAnalyzeSilentProcess(String path, String language) {
        this.path = path;
        this.language = language;
        LOGGER.info(String.format(Locale.ENGLISH, "file path: %s, savePath: %s", StringUtils.getCleanMessage((String)path), StringUtils.getCleanMessage((String)path)));
    }

    @Override
    public void run() {
        int exitcode = 0;
        try {
            this.analyzedDiskMain();
            this.context.updateTotalResultWxisting();
            LOGGER.info(String.format(Locale.ENGLISH, "deleting tmp folder: %s", DiskAnalyzeConstants.TEMP_FILE_PATH));
            FileUtils.deleteAllInFolder((String)DiskAnalyzeConstants.TEMP_FILE_PATH);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            exitcode = 20;
        }
        finally {
            LOGGER.info("All task finished, close background process.");
            this.context.exitSysAndSetExitCode(exitcode);
        }
    }

    public void analyzedDiskMain() {
        Map<String, List<AnalyzeDevice>> fileMap = null;
        try {
            DiskAnalyzeContext.getInstance().importClear();
            new ParseWorktakerImpl().importPackage(this.path);
            fileMap = this.context.getReduplicateMap();
            LOGGER.info(String.format(Locale.ENGLISH, "fileMap size: %d", fileMap.size()));
        }
        catch (OutOfDiskSpaceException e) {
            LOGGER.error("import error...", (Throwable)e);
            return;
        }
        if (fileMap.isEmpty()) {
            LOGGER.error("import file format error, filePaths: {}", (Object)StringUtils.getCleanMessage((String)this.path));
            return;
        }
        for (List<AnalyzeDevice> value : fileMap.values()) {
            LOGGER.info(String.format(Locale.ENGLISH, "analyze device list size: %d", value.size()));
            this.context.getDevices().add(value.get(0));
            this.context.DEV_COUNT.incrementAndGet();
            LOGGER.info(String.format(Locale.ENGLISH, "add dev: %s to context, now dev num: %d", value.get(0).getDeviceInfo().getDeviceSerialNumber(), this.context.DEV_COUNT.get()));
        }
        for (AnalyzeDevice dev : this.context.getDevices()) {
            LOGGER.info(String.format(Locale.ENGLISH, "start to analyze single dev: %s", dev.getDeviceInfo().getDeviceSerialNumber()));
            this.context.getFixNumExecutor().execute(new SilentSingleDevAnalyzeRunnable(dev));
        }
        try {
            while (this.context.DEV_COUNT.get() != 0) {
                LOGGER.info("wait for analyze finish...");
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("exception occured when wait for all task finished, error: " + e);
        }
        LOGGER.info("end wait.");
        for (File file : this.context.getFileToDel()) {
            FileUtils.deleteFile((File)file);
            LOGGER.info(String.format(Locale.ENGLISH, "delete analyzed file: %s", new Object[0]), (Object)FilesUtil.getCanonicalPath(file));
        }
        this.context.updateAnalyzeSummary();
        boolean reportResult = new FinalSummaryReport(this.context.getDevices(), this.language).report();
        LOGGER.info(String.format(Locale.ENGLISH, "export report finished, result: %s", reportResult));
    }
}

