/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.silentanalyze;

import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.CheckPoint;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.silent.silentanalyze.StartDiskAnalyze;
import com.huawei.ism.tool.diskanalyze.worktaker.IReportWorktaker;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class AnalyzeEngine {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AnalyzeEngine.class);
    private static final AnalyzeEngine INSTANCE = new AnalyzeEngine();
    private IReportWorktaker wtk = (IReportWorktaker)WorktakerUtil.getWorktaker(IReportWorktaker.class);
    private int nowDiskNum = 0;
    private int deadThreadNum = 0;

    private AnalyzeEngine() {
    }

    public static AnalyzeEngine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadQuit(Object lock) {
        Object object = lock;
        synchronized (object) {
            ++this.deadThreadNum;
        }
    }

    public String startAnalyze(AnalyzeDevice ad) {
        StartDiskAnalyze diskAnalyze = new StartDiskAnalyze(ad);
        return diskAnalyze.startAnalyzed();
    }

    public void makeOneDevFinalScore(AnalyzeDevice ad) {
        if (!ad.isAnalyzeSuccess()) {
            return;
        }
        List<AnalyzeDisk> diskList = ad.getDiskList();
        for (AnalyzeDisk disk : diskList) {
            if (!disk.isAnalyzeSuc()) continue;
            this.makeOneDiskFinalScore(ad, disk);
        }
    }

    private void makeOneDiskFinalScore(AnalyzeDevice ad, AnalyzeDisk analyzeDisk) {
        int n;
        Rule analyzeRule;
        DiskType type = analyzeDisk.getType();
        if (type.toString().contains("NearLine SAS") || type.toString().contains("NL SAS")) {
            type = DiskType.SAS;
        }
        if (!this.countRelativeCk(ad, analyzeDisk, analyzeRule = RuleManager.getInstance().getRule(type))) {
            return;
        }
        Map<String, Integer> checkPointScores = analyzeDisk.getCheckPointScores();
        HashMap<String, Integer> itemScoreMap = new HashMap<String, Integer>();
        this.setMaxInCk(itemScoreMap, checkPointScores, analyzeRule);
        ArrayList<AnalyzeItemResult> resultList = new ArrayList<AnalyzeItemResult>();
        for (String string : analyzeRule.getItemIdList()) {
            if (!itemScoreMap.containsKey(string)) continue;
            AnalyzeItem analyzeItem = analyzeRule.getItemById(string);
            AnalyzeItemResult analyzeItemResult = new AnalyzeItemResult();
            analyzeItemResult.setRule(analyzeItem);
            analyzeItemResult.setRiskLevel((Integer)itemScoreMap.get(string));
            resultList.add(analyzeItemResult);
        }
        analyzeDisk.setResultList(resultList);
        ArrayList<Integer> riskLevels = new ArrayList<Integer>();
        for (AnalyzeItemResult itemResult : resultList) {
            riskLevels.add(itemResult.getRiskLevel());
        }
        boolean bl = false;
        try {
            n = analyzeRule.getCombineLogic().getCombinedScore(riskLevels);
        }
        catch (RuntimeException e) {
            LOGGER.error("[makeOneDiskFinalScore]  getCombinedScore error");
        }
        catch (Exception e) {
            LOGGER.error("[makeOneDiskFinalScore]  getCombinedScore error");
        }
        analyzeDisk.setScore(n);
    }

    private boolean countRelativeCk(AnalyzeDevice ad, AnalyzeDisk analyzeDisk, Rule analyzeRule) {
        int ckScore;
        String ckId;
        Map<String, Integer> checkPointScores = analyzeDisk.getCheckPointScores();
        HashMap<String, Integer> ckScoresToBeChange = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : checkPointScores.entrySet()) {
            ckId = entry.getKey();
            ckScore = entry.getValue();
            CheckPoint ck = analyzeRule.getCheckPointById(ckId);
            CheckPointValue ckValue = analyzeDisk.getCheckPointValue(ckId);
            int scoreRelative = 0;
            try {
                List<CheckPointValue> othersCkValue = this.getOthersCkValue(ad, ckId, analyzeDisk);
                scoreRelative = ck.getCheckLogic().getRelativeRisk(ckValue, othersCkValue, analyzeDisk.getVender());
            }
            catch (NumberFormatException e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            catch (RuntimeException e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            catch (Exception e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            int ckFinalScore = scoreRelative + ckScore;
            if (ckFinalScore > 10) {
                ckFinalScore = 10;
            }
            if (0 == scoreRelative) continue;
            ckScoresToBeChange.put(ckId, ckFinalScore);
        }
        if (!ckScoresToBeChange.isEmpty()) {
            for (Map.Entry<String, Integer> entry : ckScoresToBeChange.entrySet()) {
                ckId = entry.getKey();
                ckScore = entry.getValue();
                analyzeDisk.updateCheckPointScore(ckId, ckScore);
            }
        }
        return true;
    }

    private void setAnalyzeFailedReason(AnalyzeDevice ad, AnalyzeDisk analyzeDisk, CheckPoint ck) {
        ArrayList<String> reason = new ArrayList<String>();
        reason.add("3");
        reason.add("");
        reason.add(ck.getBelongItemId());
        analyzeDisk.setFailedReason(reason);
        ad.getFailedDiskList().add(analyzeDisk);
    }

    private List<CheckPointValue> getOthersCkValue(AnalyzeDevice ad, String ckId, AnalyzeDisk analyzeDisk) {
        ArrayList<CheckPointValue> othersCkValue = new ArrayList<CheckPointValue>();
        List<AnalyzeDisk> diskList = ad.getDiskList();
        for (AnalyzeDisk disk : diskList) {
            if (!disk.isAnalyzeSuc() || !analyzeDisk.getModel().equals(disk.getModel()) || analyzeDisk.getSn().equals(disk.getSn()) || disk.getCheckPointValue(ckId) == null) continue;
            othersCkValue.add(disk.getCheckPointValue(ckId));
        }
        return othersCkValue;
    }

    private void setMaxInCk(Map<String, Integer> itemScoreMap, Map<String, Integer> checkPointScores, Rule analyzeRule) {
        for (Map.Entry<String, Integer> entry : checkPointScores.entrySet()) {
            String ckId = entry.getKey();
            int ckScore = entry.getValue();
            CheckPoint ck = analyzeRule.getCheckPointById(ckId);
            String itemId = ck.getBelongItemId();
            if (itemScoreMap.containsKey(itemId)) {
                this.compareScoreAndexc(itemScoreMap, itemId, ckScore);
                continue;
            }
            itemScoreMap.put(itemId, ckScore);
        }
    }

    private void compareScoreAndexc(Map<String, Integer> itemScoreMap, String itemId, int ckScore) {
        if (ckScore > itemScoreMap.get(itemId)) {
            itemScoreMap.put(itemId, ckScore);
        }
    }

    public IReportWorktaker getWtk() {
        return this.wtk;
    }

    public int getDeadThreadNum() {
        return this.deadThreadNum;
    }

    public int getNowDiskNum() {
        return this.nowDiskNum;
    }

    public void setNowDiskNum(int nowDiskNum) {
        this.nowDiskNum = nowDiskNum;
    }
}

