/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.silentanalyze;

import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.silent.worktakerimpl.SilentReportWorktakerImpl;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeConstants;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import utils.FilesUtil;

public class FinalSummaryReport {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FinalSummaryReport.class);
    private List<AnalyzeDevice> devices = null;
    private String language;

    public FinalSummaryReport(List<AnalyzeDevice> devices, String language) {
        this.devices = null == devices ? new LinkedList() : devices;
        this.language = language;
    }

    public boolean report() {
        SilentReportWorktakerImpl worktaker = new SilentReportWorktakerImpl(this.devices, this.language);
        LOGGER.info(String.format(Locale.ENGLISH, "start build report, devices size: %d", this.devices.size()));
        worktaker.buildReport();
        String defaultReportName = "DiskHealthReport_" + new Date().getTime() + "." + "zip";
        File reportFile = new File(DiskAnalyzeConstants.TEMP_FILE_PATH + File.separator + "analyzeReport");
        if (!reportFile.exists() && !reportFile.mkdir()) {
            LOGGER.error("make dir for report error, folder: {}", (Object)FilesUtil.getCanonicalPath(reportFile));
        }
        File file = new File(reportFile.getAbsoluteFile(), defaultReportName);
        LOGGER.info(String.format(Locale.ENGLISH, "start export file path:%s", FilesUtil.getCanonicalPath(file)));
        boolean result = worktaker.exportReport(file);
        if (!result) {
            LOGGER.error("file export is failed...");
            return false;
        }
        LOGGER.info("file export is success...");
        if (!file.renameTo(new File(DiskAnalyzeContext.getInstance().getProgressPath(), defaultReportName))) {
            LOGGER.error("move report file error, now report file location is: {}", (Object)FilesUtil.getCanonicalPath(file));
        }
        LOGGER.info(String.format(Locale.ENGLISH, "move report file to: %s", FilesUtil.getCanonicalPath(file)));
        return true;
    }
}

