/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.silentanalyze;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.silent.silentanalyze.AnalyzeEngine;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentSingleDevAnalyzeRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SilentSingleDevAnalyzeRunnable.class);
    private AnalyzeDevice device;

    public SilentSingleDevAnalyzeRunnable(AnalyzeDevice dev) {
        this.device = null == dev ? null : dev;
    }

    @Override
    public void run() {
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "start to analyze device: %s", this.device.getDeviceInfo().getDeviceSerialNumber()));
            String result = AnalyzeEngine.getInstance().startAnalyze(this.device);
            AnalyzeEngine.getInstance().makeOneDevFinalScore(this.device);
            DiskAnalyzeContext.getInstance().DEV_COUNT.decrementAndGet();
            LOGGER.info(String.format(Locale.ENGLISH, "analyze device: %s finished, result: %s, current device to be analyzed: %d", this.device.getDeviceInfo().getDeviceSerialNumber(), result, DiskAnalyzeContext.getInstance().DEV_COUNT.get()));
            DiskAnalyzeContext.getInstance().updateSilentResult(this.device, StringUtils.isNULLStr((String)result), result);
        }
        catch (Exception e) {
            LOGGER.error("Thread error.", (Throwable)e);
        }
    }
}

