/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.silentanalyze;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeThread;
import com.huawei.ism.tool.diskanalyze.analyze.DiskAnalyzeBuffer;
import com.huawei.ism.tool.diskanalyze.analyze.IDiskLoader;
import com.huawei.ism.tool.diskanalyze.analyze.loader.DiskLoaderFactory;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;

public class StartDiskAnalyze
extends AnalyzeThread {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(StartDiskAnalyze.class);
    private AnalyzeDevice ad;

    public StartDiskAnalyze(AnalyzeDevice device) {
        this.ad = device;
    }

    public String startAnalyzed() {
        try {
            IDiskLoader loader = DiskLoaderFactory.getInstance().getDiskLoader(this.ad.getDeviceInfo().getDeviceType());
            if (null != loader) {
                List<String> smartTxt = loader.loadSmartFiles(this.ad);
                this.ad.setSmartList(smartTxt);
                loader.loadBasicInfo(this.ad);
                LOGGER.info(String.format(Locale.ENGLISH, "start Analyze >> Analyze to device %s", this.ad.getDeviceInfo().getIp()));
                this.analyzeDiskHealth(this.ad);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("loadBasicInfo RuntimeException");
            this.ad.setAnalyzeSuccess(false);
            LOGGER.info(String.format(Locale.ENGLISH, "Analyze complete >> Analyze to device %s end][Failed", this.ad.getDeviceInfo().getIp()));
            return ResourceUtil.getString((String)"diskhealthanalyze.notsupport.currentpackage");
        }
        LOGGER.info(String.format(Locale.ENGLISH, "Analyze complete >> Analyze to device %s end][Success", this.ad.getDeviceInfo().getIp()));
        this.ad.setAnalyzeSuccess(true);
        return "";
    }

    @Override
    protected void meetAnalyzeTime(String line, DiskAnalyzeBuffer feildBuffer, AnalyzeDevice analyzeDevice) {
        this.analyzeOneDisk(feildBuffer, analyzeDevice);
        feildBuffer.clear();
        this.refreshUI();
        if (null == line) {
            return;
        }
        feildBuffer.addDiskInfo(line);
        this.addDevModolToDisk(feildBuffer, line, analyzeDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUI() {
        Object object = LOCK;
        synchronized (object) {
            int nowDiskNum = ANALYZE_ENGINE.getNowDiskNum() + 1;
            ANALYZE_ENGINE.setNowDiskNum(nowDiskNum);
        }
    }
}

