/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.silent.worktakerimpl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeSummary;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeConstants;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ExcelResultBuilder;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ReportWorktakerImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class SilentReportWorktakerImpl
extends ReportWorktakerImpl {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilentReportWorktakerImpl.class);
    private List<AnalyzeDevice> devices = new LinkedList<AnalyzeDevice>();
    private String language;

    public SilentReportWorktakerImpl(List<AnalyzeDevice> devices, String language) {
        this.devices = null == devices ? this.devices : devices;
        this.language = language;
    }

    @Override
    public void buildReport() {
        this.configHtmlPath = this.language.equals(String.valueOf(Locale.ENGLISH)) ? "config/diskanalyze/html/en" : "config/diskanalyze/html/zh";
        this.delOldHtmlFiles(DiskAnalyzeConstants.HTML_FILE_PATH);
        this.buildDeviceMap();
        this.addStaticFiles();
        this.buildLeftPage();
        this.buildFrontPage();
        this.buildSummaryPage();
        for (AnalyzeDevice analyzeDevice : this.devices) {
            this.buildDetailPage(analyzeDevice);
        }
        StringBuilder sb = new StringBuilder("deviceSN=");
        for (AnalyzeDevice device : this.devices) {
            sb.append("${" + device.getDeviceInfo().getDeviceSerialNumber() + "},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(System.lineSeparator()).append("fileCreateTime=" + System.currentTimeMillis()).append(System.lineSeparator());
        this.buildPkgInfo(sb.toString());
        try {
            ExcelResultBuilder excelResultBuilder = new ExcelResultBuilder();
            excelResultBuilder.buildTittle();
            for (AnalyzeDevice device : this.context.getDevices()) {
                excelResultBuilder.buildSummary(device);
            }
            excelResultBuilder.writeExcel(DiskAnalyzeConstants.REPORT_TEMP_PATH);
        }
        catch (Exception exception) {
            LOGGER.error("build excel error.", (Throwable)exception);
        }
        LOGGER.info("build report finished...");
    }

    @Override
    protected Map<String, Map<String, AnalyzeDevice>> buildDeviceMap() {
        HashMap<String, Map<String, AnalyzeDevice>> deviceMap = new HashMap<String, Map<String, AnalyzeDevice>>();
        for (AnalyzeDevice device : this.devices) {
            if (device == null) continue;
            String key = device.getDeviceInfo().getDeviceType() + " " + device.getDeviceInfo().getProductVersion();
            HashMap<String, AnalyzeDevice> map = (HashMap<String, AnalyzeDevice>)deviceMap.get(key);
            if (null == map) {
                map = new HashMap<String, AnalyzeDevice>();
                map.put(device.getUuid(), device);
                deviceMap.put(key, map);
            }
            map.put(device.getUuid(), device);
        }
        return deviceMap;
    }

    @Override
    protected void buildDetailPage(AnalyzeDevice device) {
        DevNode node = device.getDeviceInfo();
        List<AnalyzeDisk> diskList = device.getDiskList();
        diskList = this.sortByFields(diskList);
        StringBuilder sbScoreContent = this.buildScorePage(diskList);
        StringBuilder sbDiskList = new StringBuilder();
        int riskCount = device.getRiskDiskNum();
        for (AnalyzeDisk disk : diskList) {
            int score = disk.getScore();
            this.prepareDiskParam(disk, score);
            sbDiskList.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_DETAIL, this.argList));
        }
        StringBuilder sbFileName = new StringBuilder();
        sbFileName.append(device.getUuid());
        sbFileName.append(".html");
        this.oldPathMap.put("detail.html", this.configHtmlPath);
        this.newPathMap.put(sbFileName.toString(), DiskAnalyzeConstants.HTML_FILE_PATH);
        this.copyFile("detail.html", sbFileName.toString());
        StringBuilder sbDetailPath = new StringBuilder();
        sbDetailPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbDetailPath.append(File.separator);
        sbDetailPath.append(sbFileName.toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.prepareNodeParam(device, node, sbScoreContent, sbDiskList, riskCount, df);
        this.buildHtmlFile(sbDetailPath.toString(), this.argList);
    }

    private void prepareNodeParam(AnalyzeDevice device, DevNode node, StringBuilder sbScoreContent, StringBuilder sbDiskList, int riskCount, SimpleDateFormat df) {
        this.argList.clear();
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(node.getDeviceType().toString());
        this.argList.add(DiskAnalyzeContext.getInstance().getDevVersionWithoutSPC(node.getProductVersion()));
        this.argList.add(node.getDeviceName());
        this.argList.add(node.getIp());
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(String.valueOf(device.getDiskList().size()));
        this.argList.add(String.valueOf(riskCount));
        this.argList.add(sbScoreContent.toString());
        this.argList.add(sbDiskList.toString());
        Date date = device.getPackageDate();
        this.argList.add(null != date ? df.format(date) : "");
        this.argList.add(String.valueOf(device.getCollectDiskNum()));
        Map<String, String> promptMap = CommonCheckLogic.getInstance().getPromptMap();
        this.argList.add(ResourceUtil.getString((String)("diskhealthanalyze.change.prompt." + promptMap.getOrDefault(node.getDeviceType().toString(), "default"))));
    }

    private void prepareDiskParam(AnalyzeDisk disk, int score) {
        this.argList.clear();
        this.argList.add(disk.getBgColor());
        this.argList.add(disk.getEnclosureNo());
        this.argList.add(disk.getSlotNo());
        this.argList.add(disk.getShowDiskType());
        this.argList.add(disk.getVender());
        this.argList.add(disk.getModel());
        this.argList.add(disk.getFirmwareVersion());
        this.argList.add(disk.getSn() + "_" + disk.getSn());
        this.argList.add(disk.getSn());
        this.argList.add(String.valueOf(-1 == score ? "--" : Integer.valueOf(score)));
        this.argList.add(disk.getSn());
        this.argList.add(-1 == score ? "" : ResourceUtil.getString((String)"analyze.disk.button.detail"));
    }

    @Override
    protected void buildSummaryPage() {
        StringBuilder sbRiskTable = new StringBuilder();
        StringBuilder sbDeviceTable = new StringBuilder();
        StringBuilder sbCollectRiskTable = new StringBuilder();
        for (AnalyzeDevice device : this.devices) {
            DevNode node = device.getDeviceInfo();
            this.prepareDeviceParam(device, node);
            String strDeviceTableTr = this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_DEVICE_TOTAL, this.argList);
            sbDeviceTable.append(strDeviceTableTr);
            for (AnalyzeDisk disk : device.getRiskDiskList()) {
                this.prepareRiskDiskParam(device, node, disk);
                String strRiskTableTr = this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_RISK_TOTAL, this.argList);
                sbRiskTable.append(strRiskTableTr);
            }
            for (AnalyzeDisk disk : device.getCollectDiskList()) {
                this.prepareCollectDiskParam(device, node, disk);
                sbCollectRiskTable.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_COLLECT_RISK_TOTAL, this.argList));
            }
        }
        StringBuilder sbSummaryPath = new StringBuilder();
        sbSummaryPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbSummaryPath.append(File.separator);
        sbSummaryPath.append("summary.html");
        AnalyzeSummary analyzeSummary = this.context.getAnalyzeSummary();
        this.prepareAnalyzeSummaryParam(sbRiskTable, sbDeviceTable, sbCollectRiskTable, analyzeSummary);
        this.buildHtmlFile(sbSummaryPath.toString(), this.argList);
    }

    private void prepareAnalyzeSummaryParam(StringBuilder sbRiskTable, StringBuilder sbDeviceTable, StringBuilder sbCollectRiskTable, AnalyzeSummary analyzeSummary) {
        this.argList.clear();
        this.argList.add(String.valueOf(analyzeSummary.getTotalDeviceNum()));
        this.argList.add(String.valueOf(analyzeSummary.getTotalDiskNum()));
        this.argList.add(String.valueOf(analyzeSummary.getRiskDiskNum()));
        this.argList.add(String.valueOf(analyzeSummary.getCollectDiskNum()));
        this.argList.add(sbRiskTable.toString());
        this.argList.add(sbCollectRiskTable.toString());
        this.argList.add(sbDeviceTable.toString());
    }

    private void prepareCollectDiskParam(AnalyzeDevice device, DevNode node, AnalyzeDisk disk) {
        this.argList.clear();
        this.argList.add(disk.getSn());
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(disk.getSn());
        this.argList.add(device.getDeviceInfo().getDeviceName());
        this.argList.add(disk.getEnclosureNo());
        this.argList.add(disk.getSlotNo());
        this.argList.add("--");
    }

    private void prepareRiskDiskParam(AnalyzeDevice device, DevNode node, AnalyzeDisk disk) {
        this.argList.clear();
        this.argList.add(disk.getSn());
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(disk.getSn());
        this.argList.add(device.getDeviceInfo().getDeviceName());
        this.argList.add(disk.getEnclosureNo());
        this.argList.add(disk.getSlotNo());
        this.argList.add(String.valueOf(disk.getScore()));
    }

    private void prepareDeviceParam(AnalyzeDevice device, DevNode node) {
        this.argList.clear();
        this.argList.add(node.getDeviceType().toString());
        this.argList.add(DiskAnalyzeContext.getInstance().getDevVersionWithoutSPC(node.getProductVersion()));
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(node.getDeviceName());
        this.argList.add(node.getIp());
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(String.valueOf(device.getDiskList().size()));
        this.argList.add(String.valueOf(device.getRiskDiskNum()));
        this.argList.add(String.valueOf(device.getCollectDiskNum()));
    }
}

