/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.exception.OutOfDiskSpaceException;
import com.huawei.ism.tool.diskanalyze.ui.ImportWarningType;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.worktaker.IParseWorktaker;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class AutoImportCallable
implements Callable<ImportWarningType> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AutoImportCallable.class);
    private List<String> pkgList = null;
    private IParseWorktaker parseWorktaker;

    public AutoImportCallable(IParseWorktaker parseWorktaker) {
        this.parseWorktaker = parseWorktaker;
        this.pkgList = this.getPkgsPath();
    }

    @Override
    public ImportWarningType call() {
        if (null == this.pkgList || this.pkgList.isEmpty()) {
            return ImportWarningType.NO_FILE_CHOOSE;
        }
        try {
            if (!this.parseWorktaker.autoImportPkg(this.pkgList)) {
                return this.showErrorType();
            }
        }
        catch (OutOfDiskSpaceException e) {
            LOGGER.error("OutOfDiskSpaceException In AutoImportCallable:");
            return ImportWarningType.OUT_OF_DISK_SPACE;
        }
        Map<String, List<AnalyzeDevice>> devMap = DiskAnalyzeContext.getInstance().getReduplicateMap();
        if (devMap.isEmpty()) {
            return this.showErrorType();
        }
        if (DiskHealthAssistant.getInstance().findAnalyzeDev(devMap)) {
            return ImportWarningType.REDUPLICATE_INFO;
        }
        return ImportWarningType.NONE;
    }

    private ImportWarningType showErrorType() {
        if (this.pkgList.size() > 1) {
            return ImportWarningType.NO_FILE_IN_DIR;
        }
        return ImportWarningType.NO_FILE_VALID;
    }

    private List<String> getPkgsPath() {
        String sysEnv;
        String path;
        ArrayList<String> pkgsPath = new ArrayList<String>();
        String sysEnvCommon = "DISK_SMARTINFO_PATH_";
        int count = 1;
        while (!StringUtils.isNULLStr((String)(path = System.getenv(sysEnv = sysEnvCommon + count)))) {
            ++count;
            pkgsPath.add(path);
        }
        return pkgsPath;
    }
}

