/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.filechooser.HibernateContainer;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.diskanalyze.analyze.AutoImportThread;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeStatus;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeSummary;
import com.huawei.ism.tool.diskanalyze.ui.DiskHealthAnalyzeLayout;
import com.huawei.ism.tool.diskanalyze.ui.FailedDevDialog;
import com.huawei.ism.tool.diskanalyze.ui.FailedDisksDialog;
import com.huawei.ism.tool.diskanalyze.ui.ImportCallable;
import com.huawei.ism.tool.diskanalyze.ui.ImportWarningType;
import com.huawei.ism.tool.diskanalyze.ui.ReduplicateInfoDialog;
import com.huawei.ism.tool.diskanalyze.ui.SupportDeviceDialog;
import com.huawei.ism.tool.diskanalyze.ui.action.ChooseFileBtnListener;
import com.huawei.ism.tool.diskanalyze.ui.action.DevSupportListener;
import com.huawei.ism.tool.diskanalyze.ui.action.ExReportBtnListener;
import com.huawei.ism.tool.diskanalyze.ui.action.FailedDevNumListener;
import com.huawei.ism.tool.diskanalyze.ui.action.FailedNumListener;
import com.huawei.ism.tool.diskanalyze.ui.action.GetStartBtnBtnListener;
import com.huawei.ism.tool.diskanalyze.ui.action.ImportBtnListener;
import com.huawei.ism.tool.diskanalyze.ui.action.ReadReportBtnListener;
import com.huawei.ism.tool.diskanalyze.ui.listener.DiskAnalyzeWindowListener;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthDialogConstants;
import com.huawei.ism.tool.diskanalyze.worktaker.IAnalyzeWorktaker;
import com.huawei.ism.tool.diskanalyze.worktaker.IParseWorktaker;
import com.huawei.ism.tool.diskanalyze.worktaker.IProgressListener;
import com.huawei.ism.tool.diskanalyze.worktaker.IReportWorktaker;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ExportTask;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import utils.FilesUtil;

public class DiskHealthAnalyzeDialog
extends JDialog
implements IProgressListener,
IHelpActionCallBack {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DiskHealthAnalyzeDialog.class);
    private static final String SELECTFILE_DEFAULT_ID = "diskhealth_analyze_saveresult_path_id001";
    private static final String SAVEPATH_DEFAULT_ID = "diskhealth_analyze_saveresult_path_id002";
    private static final long REQUIRED_FREE_DISK = 0x8000000L;
    private static final long serialVersionUID = 5554583389545767718L;
    private static final int FILE_MAX_PATH = 185;
    private DiskHealthAnalyzeLayout layout = new DiskHealthAnalyzeLayout();
    private IParseWorktaker parseWorktaker;
    private IAnalyzeWorktaker analyzeWorktaker;
    private IReportWorktaker reportWorktaker;
    private File selectFile = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();

    public IParseWorktaker getParseWorktaker() {
        return this.parseWorktaker;
    }

    public DiskHealthAnalyzeDialog(Window parentFrame) {
        super(parentFrame);
        this.setResizable(false);
        this.initAll();
    }

    public DiskHealthAnalyzeDialog(Window parentFrame, String selectFilePath) {
        super(parentFrame);
        this.setResizable(false);
        this.initAll();
        this.layout.setFilePathText(FilePathUtils.checkFile((String)selectFilePath));
        this.selectFile = new File(FilePathUtils.checkFile((String)selectFilePath));
    }

    private void initAll() {
        this.setModal(true);
        this.getRootPane().setUI(this.rootPaneUI);
        this.rootPaneUI.setHelpActionCallBack(this);
        this.parseWorktaker = (IParseWorktaker)WorktakerUtil.getWorktaker(IParseWorktaker.class);
        this.analyzeWorktaker = (IAnalyzeWorktaker)WorktakerUtil.getWorktaker(IAnalyzeWorktaker.class);
        this.reportWorktaker = (IReportWorktaker)WorktakerUtil.getWorktaker(IReportWorktaker.class);
        this.initListener();
        UiMethod.setComponentSize(DiskHealthDialogConstants.DIALOG_SIZE_900X675, this);
        UiMethod.putScreenCenter(this);
        this.setTitle(ResourceUtil.getString((String)"diskhealthanalyze.funcitem.name"));
        this.add(this.layout);
        ImageIcon image = ResourceUtil.getImage((String)"diskhealthanalyze.png");
        this.setIconImage(image.getImage());
    }

    private TableRow<AnalyzeDevice, String> createTableRow(AnalyzeDevice ad) {
        DevNode devNode;
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableColumn(), (Object)ad, (Object)ad.getUuid());
        File file = ad.getInfoPackage();
        if (null != file) {
            row.setValueAt(0, (Object)file.getName());
        }
        if (null != (devNode = ad.getDeviceInfo())) {
            row.setValueAt(1, (Object)ad.getDeviceInfo().getDeviceName());
            row.setValueAt(2, (Object)ad.getDevTypeVersion());
            row.setValueAt(3, (Object)ad.getDeviceInfo().getDeviceSerialNumber());
        }
        row.setValueAt(4, (Object)ad.getTotalDisk());
        row.setValueAt(5, (Object)ad.getSucceedDisk());
        row.setValueAt(6, (Object)(ad.getTotalDisk() - ad.getSucceedDisk()));
        return row;
    }

    private void initTableData(List<AnalyzeDevice> adList) {
        this.layout.getTableModel().removeAll();
        for (AnalyzeDevice ad : adList) {
            TableRow<AnalyzeDevice, String> tmp = this.createTableRow(ad);
            this.layout.getTableModel().addRow(new TableRow[]{tmp});
        }
    }

    public void readFailedDiskAction() {
        FailedDisksDialog dialog = new FailedDisksDialog(this);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public void readFailedDevAction() {
        FailedDevDialog dialog = new FailedDevDialog(this);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private List<String> getSelectedRowUuids() {
        ArrayList<String> uuidList = new ArrayList<String>();
        List markRows = this.layout.getDeviceTable().getMarkedRows();
        for (TableRow tr : markRows) {
            String uuid = (String)tr.getIdentifier();
            uuidList.add(uuid);
        }
        return uuidList;
    }

    public void autoImport() {
        ToolThreadFactory.newDefaultThread((Runnable)new AutoImportThread(this)).start();
    }

    public void freshTable(ImportWarningType markSign) {
        this.openWarningDialog(markSign);
        ArrayList<AnalyzeDevice> analyzeList = new ArrayList<AnalyzeDevice>();
        Map<String, AnalyzeDevice> devAnalyzeMap = DiskAnalyzeContext.getInstance().getDeviceMap();
        analyzeList.addAll(devAnalyzeMap.values());
        this.initTableData(analyzeList);
        if (this.isShowUnCheckLog(markSign)) {
            ReduplicateInfoDialog dialog = new ReduplicateInfoDialog(this);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        this.layout.setTableSelectAll();
        this.requestFocus();
    }

    private boolean isShowUnCheckLog(ImportWarningType markSign) {
        return markSign.equals((Object)ImportWarningType.REDUPLICATE_INFO) || DiskAnalyzeContext.getInstance().isScene() && this.selectFile.isDirectory() && !DiskAnalyzeContext.getInstance().getSenceUnParseList().isEmpty();
    }

    private void openWarningDialog(ImportWarningType markSign) {
        if (markSign.equals((Object)ImportWarningType.NO_FILE_CHOOSE)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.nofilechoose"));
        } else if (markSign.equals((Object)ImportWarningType.NO_FILE_IN_DIR)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.nofileindir"));
        } else if (markSign.equals((Object)ImportWarningType.NO_FILE_VALID)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.nofilevalid"));
        } else if (markSign.equals((Object)ImportWarningType.OUT_OF_DISK_SPACE)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.outofdiskspace"));
        }
    }

    public void chooseFileAction() {
        Object defaultPathObj = HibernateContainer.getInstance().get(SELECTFILE_DEFAULT_ID);
        String defaultPath = null != defaultPathObj ? defaultPathObj.toString() : null;
        LOGGER.info("you click chooseFile btn.");
        String[] ext = new String[]{"zip", "7z"};
        this.selectFile = ToolFileChooser.selectFile(this, ResourceUtil.getString((String)"diskhealthanalyze.filechoose.title"), ext, SELECTFILE_DEFAULT_ID, ResourceUtil.getString((String)"diskhealthanalyze.folder"), 2, true, true, Locale.getDefault(), 185);
        if (null != this.selectFile && this.selectFile.exists()) {
            this.layout.setFilePathText(FilesUtil.getCanonicalPath(this.selectFile));
        }
        if (null != this.selectFile) {
            LOGGER.info(String.format(Locale.ENGLISH, "Change log directory >> %s -> %s][Success", defaultPath, FilesUtil.getCanonicalPath(this.selectFile)));
        } else {
            LOGGER.info("Change log directory  ][Failed");
        }
    }

    public void startAnalyzeAction() {
        LOGGER.info("you click startAnalyze btn.");
        if (DiskAnalyzeContext.getInstance().getAnalyzeStatus().equals((Object)AnalyzeStatus.ING_ANALYZE)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.analyzing"));
            return;
        }
        List<String> selectList = this.getSelectedRowUuids();
        if (selectList.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.noselectdev"));
            return;
        }
        if (!this.checkSencePath() || !this.checkSenceFreeSpace()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.sence.file.error"));
            return;
        }
        List<AnalyzeDevice> adList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(selectList);
        for (AnalyzeDevice analyzeDevice : adList) {
            LOGGER.info(String.format(Locale.ENGLISH, "Analyze start >> Analyze to device %s begin][Success", analyzeDevice.getDeviceInfo().getIp()));
        }
        this.layout.setAnalyzeStatus(AnalyzeStatus.ING_ANALYZE);
        DiskAnalyzeContext.getInstance().reAnalyzeClear();
        DiskAnalyzeContext.getInstance().setDeviceIdList(selectList);
        List<String> selectedRowUuids = this.getSelectedRowUuids();
        DiskAnalyzeContext.getInstance().setSelectDeviceUUID(selectedRowUuids);
        this.analyzeWorktaker.analyze(this, selectedRowUuids);
    }

    private boolean checkSencePath() {
        if (!DiskAnalyzeContext.getInstance().isScene()) {
            return true;
        }
        String senceDir = DiskAnalyzeContext.getInstance().getSceneDir();
        String senceChild = senceDir + File.separator + "test";
        File testFile = new File(senceChild);
        try {
            if (testFile.createNewFile() && !testFile.delete()) {
                LOGGER.info("delete test file failed");
            }
        }
        catch (IOException e) {
            LOGGER.error("test create file failed.");
            return false;
        }
        return true;
    }

    private boolean checkSenceFreeSpace() {
        if (!DiskAnalyzeContext.getInstance().isScene()) {
            return true;
        }
        String senceDir = DiskAnalyzeContext.getInstance().getSceneDir();
        File senceFile = new File(senceDir);
        long freSpace = senceFile.getFreeSpace();
        if (freSpace < 0x8000000L) {
            LOGGER.info("free space limit 128M");
            return false;
        }
        return true;
    }

    public void readReportAction() {
        this.reportWorktaker.getReport(this);
    }

    public void exportReportAction() {
        LOGGER.info("you click export btn.");
        Date date = new Date();
        String defaultReportName = "DiskHealthReport_" + date.getTime() + "." + "zip";
        String title = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.savefile");
        String selectedFile = ToolFileChooser.getSaveFilePath(title, "zip", this, defaultReportName, SAVEPATH_DEFAULT_ID, true, Locale.getDefault());
        if (null == selectedFile) {
            return;
        }
        File file = new File(selectedFile);
        if (!this.checkDiskFreeSpace(file)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.remind.diskspacenotenough"));
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog((Window)this);
        ServiceTaskExecutor serviceTaskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult taskresult = serviceTaskExecutor.execute(new ExportTask(file));
        if (null != taskresult && taskresult.getResult() == TaskResult.Result.SUCCESS) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.info.exportsucceed"));
            LOGGER.info(String.format(Locale.ENGLISH, "Export report >> %s][Success", FilesUtil.getCanonicalPath(file)));
        } else {
            LOGGER.info("Export report][Failed");
        }
    }

    private boolean checkDiskFreeSpace(File file) {
        long freeSpace = file.getParentFile().getFreeSpace();
        LOGGER.info(String.format(Locale.ENGLISH, "Disk free space is:%d ", freeSpace));
        return freeSpace >= 0x8000000L;
    }

    public void devSupportAction() {
        SupportDeviceDialog dialog = new SupportDeviceDialog(this);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    @Override
    public void refreshProgress(int progress, int remaindTime) {
        this.layout.setAnalyzeProgress(progress);
        this.layout.setTimeLeft(remaindTime);
    }

    @Override
    public void finishAnalyze(AnalyzeSummary analyzeSummary) {
        int totalDeviceNum = analyzeSummary.getTotalDeviceNum();
        int totalDiskNum = analyzeSummary.getTotalDiskNum();
        int riskDiskNum = analyzeSummary.getRiskDiskNum();
        int collectDiskNum = analyzeSummary.getCollectDiskNum();
        Map<String, AnalyzeDevice> allDev = DiskAnalyzeContext.getInstance().getDeviceMap();
        ArrayList<String> lists = new ArrayList<String>();
        for (Map.Entry<String, AnalyzeDevice> entry : allDev.entrySet()) {
            AnalyzeDevice ad = entry.getValue();
            List<AnalyzeDisk> subFailedDisk = ad.getFailedDiskList();
            if (null == subFailedDisk) continue;
            for (AnalyzeDisk analyzeDisk : subFailedDisk) {
                lists.add(analyzeDisk.getSn());
            }
        }
        HashSet hashSet = new HashSet(lists);
        int failedDiskNum = hashSet.size();
        int failedDevNum = analyzeSummary.getFailedDeviceNum();
        this.layout.setAnalyzeResults(totalDeviceNum, failedDiskNum, failedDevNum);
        this.layout.setFinalResults(totalDiskNum, riskDiskNum, collectDiskNum);
        this.layout.setAnalyzeStatus(AnalyzeStatus.AFTER_ANALYZE);
        this.addFailedNumlistener(failedDiskNum);
        this.addFailedDevNumlistener(failedDevNum);
    }

    private void addFailedNumlistener(int failedDiskNum) {
        if (0 == failedDiskNum) {
            return;
        }
        this.layout.getResultsFailedNum().addClickListener(new FailedNumListener(this));
    }

    private void addFailedDevNumlistener(int failedDevNum) {
        if (0 == failedDevNum) {
            return;
        }
        this.layout.getResultsFailedDevNum().addClickListener(new FailedDevNumListener(this));
    }

    private void initListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DiskAnalyzeWindowListener(this));
        this.layout.getDevSupport().addClickListener(new DevSupportListener(this));
        this.layout.getImportBtn().addActionListener(new ImportBtnListener(this));
        this.layout.getChooseFileBtn().addActionListener(new ChooseFileBtnListener(this));
        this.layout.getStartBtn().addActionListener(new GetStartBtnBtnListener(this));
        this.layout.getReadReportBtn().addActionListener(new ReadReportBtnListener(this));
        this.layout.getExportReportBtn().addActionListener(new ExReportBtnListener(this));
    }

    public void importAction() {
        String filePath;
        LOGGER.info("you click import btn.");
        if (!this.layout.getTableModel().getRowList().isEmpty()) {
            WarningDialog dialog;
            AnalyzeStatus analyzeStatus = DiskAnalyzeContext.getInstance().getAnalyzeStatus();
            String resource = ResourceUtil.getString((String)"diskhealthanalyze.warning.isfreshdevice");
            if (analyzeStatus == AnalyzeStatus.AFTER_ANALYZE) {
                resource = ResourceUtil.getString((String)"diskhealthanalyze.warning.isfreshdeviceandreport");
            }
            if (0 != (dialog = DialogUtils.showYesNoDialog((Window)this, (String)resource)).getValue()) {
                return;
            }
        }
        if (null == (filePath = this.layout.getFilePath())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.nofilechoose"));
            return;
        }
        this.selectFile = new File(FilePathUtils.checkFile((String)filePath));
        if (null == this.selectFile || !this.selectFile.exists()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"diskhealthanalyze.warning.nofilechoose"));
            return;
        }
        DiskAnalyzeContext.getInstance().importClear();
        this.layout.getTableModel().removeAll();
        List fs = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new ImportCallable(this.selectFile, this.parseWorktaker)});
        ImportWarningType markSign = (ImportWarningType)((Object)fs.get(0));
        this.freshTable(markSign);
        this.layout.setAnalyzeProgress(0);
        DiskAnalyzeContext.getInstance().setAnalyzeStatus(AnalyzeStatus.BEFORE_ANALYZE);
        this.layout.setAnalyzeStatus(DiskAnalyzeContext.getInstance().getAnalyzeStatus());
    }

    @Override
    public void doHelpActionWork() {
        this.openHelpFile("DiskHealthAnalyze", this);
    }

    @Override
    public String getListenerName() {
        return "HelpTitleDialog:" + this.getClass().getSimpleName();
    }

    private void openHelpFile(String fileName, Window parent) {
        DiskAnalyzeContext.getInstance().setOpenHelpFile(true);
        String htmlFileName = fileName + "_" + this.getCurrentLanguage().getLanguage() + ".chm";
        String workDir = ApplicationContext.getInstance().getWorkPath();
        File helpFilePath = new File(workDir, ApplicationContext.getInstance().getHelpPath());
        File helpFile = new File(helpFilePath, htmlFileName);
        LOGGER.info(String.format(Locale.ENGLISH, "explorer help file:%s", helpFile));
        if (!helpFile.exists()) {
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"diskhealthanalyze.help.warning"));
        } else {
            OSCmdUtils.explorerFile((File)helpFile);
        }
    }

    private Locale getCurrentLanguage() {
        return LanguageManager.getInstance().getCurrentLanguage();
    }

    public File getSelectFile() {
        return this.selectFile;
    }

    public void setSelectFile(File selectFile) {
        this.selectFile = selectFile;
    }
}

