/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeStatus;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthDialogConstants;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.table.TableModel;

public class DiskHealthAnalyzeLayout
extends JPanel {
    private static final long serialVersionUID = -4566943599261999783L;
    private String[] columnNames = new String[]{ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.name"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.devicename"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.devicetype"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.sn"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.disknum"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.disksuccess"), ResourceUtil.getString((String)"diskhealthanalyze.maindialog.table.diskfailed")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.columnNames, new int[]{0, 1, 2, 3, 4, 5, 6});
    private IsmTable deviceTable = new IsmTable((TableModel)this.tableModel);
    private IsmTextField filePath = new IsmTextField(null, "", 255);
    private ImageIcon statusImg = ResourceUtil.getImage((String)"analyzing.gif");
    private ImageIcon bulbImg = ResourceUtil.getImage((String)"bulb.png");
    private JLabel analyzeResultsLeft = new JLabel("");
    private ToolHyperLinkLabel resultsFailedNum = new ToolHyperLinkLabel("");
    private ToolHyperLinkLabel resultsFailedDevNum = new ToolHyperLinkLabel("");
    private JLabel analyzeResultsRight = new JLabel("");
    private JLabel analyzeFailedDevRight = new JLabel("");
    private JLabel finalResults = new JLabel(" ");
    private JLabel status = new JLabel("");
    private ToolHyperLinkLabel devSupport = new ToolHyperLinkLabel("");
    private JLabel statusImage = new JLabel();
    private JLabel timeLeft = new JLabel("");
    private JProgressBar analyzeProgress;
    private JButton startBtn;
    private JButton importBtn;
    private JButton chooseFileBtn;
    private JButton readReportBtn;
    private JButton exportReportBtn;

    public DiskHealthAnalyzeLayout() {
        this.filePath.setEditable(false);
        this.initUI();
    }

    public JButton getChooseFileBtn() {
        return this.chooseFileBtn;
    }

    public JButton getExportReportBtn() {
        return this.exportReportBtn;
    }

    public JButton getImportBtn() {
        return this.importBtn;
    }

    public JButton getReadReportBtn() {
        return this.readReportBtn;
    }

    public JButton getStartBtn() {
        return this.startBtn;
    }

    public int getTableColumn() {
        return this.columnNames.length;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTimeLeft(int timeLeft) {
        String desc1 = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.timeleft.0");
        String desc2 = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.timeleft.1");
        int seconds = timeLeft / 1000;
        int minutes = seconds / 60;
        this.timeLeft.setText(minutes + desc1 + (seconds - minutes * 60) + desc2);
    }

    private void initUI() {
        TableScrollPane tableScrollPane = new TableScrollPane(this.deviceTable, true, true, true);
        tableScrollPane.setPreferredSize(DiskHealthDialogConstants.TABLE_SIZE_900X300);
        this.analyzeProgress = new JProgressBar(0);
        this.analyzeProgress.setStringPainted(true);
        this.analyzeProgress.setPreferredSize(DiskHealthDialogConstants.PROGRESSBAR_SIZE);
        this.analyzeProgress.setSize(DiskHealthDialogConstants.PROGRESSBAR_SIZE);
        this.analyzeProgress.setMinimumSize(DiskHealthDialogConstants.PROGRESSBAR_SIZE);
        this.setAnalyzeStatus(AnalyzeStatus.BEFORE_ANALYZE);
        this.initiButton();
        if (DiskAnalyzeContext.getInstance().isScene()) {
            this.filePath.setText(DiskAnalyzeContext.getInstance().getSceneDir());
        }
        JLabel desc0 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.0"));
        JLabel desc01 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.0.1"));
        JLabel desc02 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.0.2"));
        JLabel desc1 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.filechoose"));
        JLabel desc2 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.progress"));
        JLabel desc3 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.status"));
        JLabel desc4 = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.results"));
        JLabel timeLeftDesc = new JLabel(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.timeleft"));
        this.devSupport.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.support"));
        this.finalResults.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.beforeanalyze"));
        JLabel bulb = new JLabel(this.bulbImg);
        this.setBoldFont(desc1, desc2, desc3, desc4, timeLeftDesc);
        JComponent view = null;
        view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft(0, bulb, Box.createHorizontalStrut(5), desc0), UiMethod.buildCompsLeft(0, Box.createHorizontalStrut(20), desc01, this.devSupport, desc02), UiMethod.buildCompsLeft(0, new Component[]{desc1, this.filePath, Box.createHorizontalStrut(5), this.chooseFileBtn, Box.createHorizontalStrut(5), this.importBtn}), UiMethod.buildCompsLeft(0, new Component[]{tableScrollPane}), UiMethod.buildCompsLeft(0, this.startBtn), UiMethod.buildCompsLeft(0, desc3, Box.createHorizontalStrut(35), this.status, this.statusImage), UiMethod.buildCompsLeft(0, desc2, Box.createHorizontalStrut(5), this.analyzeProgress), UiMethod.buildCompsLeft(0, timeLeftDesc, Box.createHorizontalStrut(10), this.timeLeft), UiMethod.buildCompsLeft(0, desc4, Box.createHorizontalStrut(5), this.analyzeResultsLeft, this.resultsFailedDevNum, Box.createHorizontalStrut(3), this.analyzeFailedDevRight, this.resultsFailedNum, Box.createHorizontalStrut(3), this.analyzeResultsRight), Box.createVerticalStrut(20), UiMethod.buildCompsLeft(0, this.finalResults, Box.createHorizontalStrut(10), this.readReportBtn, Box.createHorizontalStrut(10), this.exportReportBtn), Box.createVerticalStrut(10)});
        this.setLayout(new BoxLayout(this, 0));
        this.add(view);
        this.add((Component)UiMethod.buildFrameSpace(view, 12), "Center");
        this.readReportBtn.setEnabled(false);
        this.exportReportBtn.setEnabled(false);
    }

    private void setBoldFont(JLabel desc1, JLabel desc2, JLabel desc3, JLabel desc4, JLabel timeLeftDesc) {
        UiMethod.setFont(desc1, DiskHealthDialogConstants.UP_FONT_EN, DiskHealthDialogConstants.UP_FONT_ZH, Locale.getDefault());
        UiMethod.setFont(desc2, DiskHealthDialogConstants.UP_FONT_EN, DiskHealthDialogConstants.UP_FONT_ZH, Locale.getDefault());
        UiMethod.setFont(desc3, DiskHealthDialogConstants.UP_FONT_EN, DiskHealthDialogConstants.UP_FONT_ZH, Locale.getDefault());
        UiMethod.setFont(desc4, DiskHealthDialogConstants.UP_FONT_EN, DiskHealthDialogConstants.UP_FONT_ZH, Locale.getDefault());
        UiMethod.setFont(timeLeftDesc, DiskHealthDialogConstants.UP_FONT_EN, DiskHealthDialogConstants.UP_FONT_ZH, Locale.getDefault());
    }

    private void initiButton() {
        String startBtnText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.start");
        this.startBtn = UiMethod.createButton(startBtnText, 'A');
        String iBtnText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.btnbox.import");
        this.importBtn = UiMethod.createButton(iBtnText, 'I');
        String cfBtnText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.btnbox.choosefile");
        this.chooseFileBtn = UiMethod.createButton(cfBtnText, 'B');
        String rrBtnText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.readreport");
        this.readReportBtn = UiMethod.createButton(rrBtnText, 'V');
        String erBtnText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.exportreport");
        this.exportReportBtn = UiMethod.createButton(erBtnText, 'E');
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setAnalyzeProgress(int num) {
        this.analyzeProgress.setValue(num);
    }

    public void setAnalyzeResults(int totalDevNum, int falDiskNum, int failedDevNum) {
        if (falDiskNum == 0 && failedDevNum == 0) {
            this.resultsFailedNum.setEnabled(true);
            String resultText = ResourceUtil.getStringWithParams((String)"diskhealthanalyze.results.0.ture", (Object[])new Object[]{totalDevNum});
            this.analyzeResultsLeft.setText(resultText);
        } else if (falDiskNum == 0 && failedDevNum > 0) {
            String leftText = ResourceUtil.getStringWithParams((String)"diskhealthanalyze.results.0.left", (Object[])new Object[]{totalDevNum});
            this.analyzeResultsLeft.setText(leftText);
            this.freshFailedDev(failedDevNum);
        } else if (falDiskNum > 0 && failedDevNum == 0) {
            this.freshFalDiskNum(totalDevNum, falDiskNum);
        } else if (falDiskNum > 0 && failedDevNum > 0) {
            this.freshFalDiskNum(totalDevNum, falDiskNum);
            this.freshFailedDev(failedDevNum);
        }
    }

    private void freshFailedDev(int failedDevNum) {
        String resultDevText = ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.results.2.fdev");
        String failedDevN = "" + failedDevNum;
        this.resultsFailedDevNum.setText(failedDevN);
        this.analyzeFailedDevRight.setText(resultDevText);
        this.setUnderLine(this.resultsFailedDevNum);
    }

    private void freshFalDiskNum(int totalDevNum, int falDiskNum) {
        String leftText = ResourceUtil.getStringWithParams((String)"diskhealthanalyze.results.0.left", (Object[])new Object[]{totalDevNum});
        this.analyzeResultsLeft.setText(leftText);
        String fNum = "" + falDiskNum;
        this.resultsFailedNum.setText(fNum);
        this.setUnderLine(this.resultsFailedNum);
        this.analyzeResultsRight.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.results.0.right"));
    }

    private void setUnderLine(ToolHyperLinkLabel label) {
        Font tempFont = label.getFont();
        Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        if (null != tempFont) {
            tempFont = tempFont.deriveFont(map);
            label.setFont(tempFont);
        }
    }

    public void setAnalyzeStatus(AnalyzeStatus statusAnalyze) {
        switch (statusAnalyze) {
            case BEFORE_ANALYZE: {
                this.setButtonState();
                this.finalResults.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.beforeanalyze"));
                this.timeLeft.setText("");
                this.analyzeResultsLeft.setText("");
                this.resultsFailedNum.setText("");
                this.resultsFailedDevNum.setText("");
                this.analyzeResultsRight.setText("");
                this.analyzeFailedDevRight.setText("");
                this.status.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.status.0"));
                this.resultsFailedNum.setEnabled(false);
                break;
            }
            case ING_ANALYZE: {
                this.status.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.status.1"));
                this.startBtn.setEnabled(false);
                this.chooseFileBtn.setEnabled(false);
                this.importBtn.setEnabled(false);
                this.statusImage.setIcon(this.statusImg);
                break;
            }
            case AFTER_ANALYZE: {
                this.status.setText(ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.status.2"));
                this.statusImage.setVisible(false);
                this.chooseFileBtn.setEnabled(true);
                this.importBtn.setEnabled(true);
                this.readReportBtn.setEnabled(true);
                this.exportReportBtn.setEnabled(true);
                this.resultsFailedNum.setEnabled(true);
                break;
            }
        }
    }

    private void setButtonState() {
        if (this.startBtn != null) {
            this.startBtn.setEnabled(true);
        }
        if (this.readReportBtn != null) {
            this.readReportBtn.setEnabled(false);
        }
        if (this.exportReportBtn != null) {
            this.exportReportBtn.setEnabled(false);
        }
    }

    public void setUnableInAnalyzing() {
        this.importBtn.setEnabled(false);
        this.chooseFileBtn.setEnabled(false);
    }

    public void setTableSelectAll() {
        this.deviceTable.selectAll();
    }

    public void setFilePathText(String txt) {
        this.filePath.setText(txt);
    }

    public String getFilePath() {
        return this.filePath.getText();
    }

    public void setFinalResults(int totalDiskNum, int riskDiskNum, int collectDiskNum) {
        this.finalResults.setText(ResourceUtil.getStringWithParams((String)"diskhealthanalyze.maindialog.desc.results.1", (Object[])new Object[]{totalDiskNum, riskDiskNum, collectDiskNum}));
    }

    public ToolHyperLinkLabel getResultsFailedNum() {
        return this.resultsFailedNum;
    }

    public void setResultsFailedNum(ToolHyperLinkLabel resultsFailedNum) {
        this.resultsFailedNum = resultsFailedNum;
    }

    public ToolHyperLinkLabel getDevSupport() {
        return this.devSupport;
    }

    public void setDevSupport(ToolHyperLinkLabel devSupport) {
        this.devSupport = devSupport;
    }

    public ToolHyperLinkLabel getResultsFailedDevNum() {
        return this.resultsFailedDevNum;
    }

    public void setResultsFailedDevNum(ToolHyperLinkLabel resultsFailedDevNum) {
        this.resultsFailedDevNum = resultsFailedDevNum;
    }
}

