/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.ui.FailedDevLayout;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthDialogConstants;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JDialog;

public class FailedDevDialog
extends JDialog {
    private static final long serialVersionUID = -2267261341723259998L;
    private FailedDevLayout layout = new FailedDevLayout();

    public FailedDevDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize(DiskHealthDialogConstants.DIALOG_SIZE_600X375, this);
        UiMethod.putScreenCenter(this);
        this.setTitle(ResourceUtil.getString((String)"diskhealthanalyze.faileddevdialog.title"));
        this.add(this.layout);
    }

    private void setTable() {
        this.layout.getFailedDevTableModel().removeAll();
        Map<String, AnalyzeDevice> allDev = DiskAnalyzeContext.getInstance().getDeviceMap();
        this.initTableData(allDev);
    }

    private TableRow<AnalyzeDevice, String> createTableRow(AnalyzeDevice dev) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getFailedDevColumns(), (Object)dev, (Object)dev.getUuid());
        if (null != dev.getInfoPackage()) {
            row.setValueAt(0, (Object)dev.getInfoPackage().getName());
        }
        row.setValueAt(1, (Object)ResourceUtil.getString((String)"diskhealthanalyze.faileddevdialog.desc.reason"));
        return row;
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getFailedDevConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FailedDevDialog.this.confirmeAction();
            }
        });
    }

    private void initTableData(Map<String, AnalyzeDevice> allDev) {
        for (Map.Entry<String, AnalyzeDevice> entry : allDev.entrySet()) {
            AnalyzeDevice dev = entry.getValue();
            if (dev.isAnalyzeSuccess()) continue;
            this.layout.getFailedDevTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }
}

