/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.ui.FailedDisksLayout;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthDialogConstants;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JDialog;

public class FailedDisksDialog
extends JDialog {
    private static final long serialVersionUID = 3876842047108758756L;
    private FailedDisksLayout layout = new FailedDisksLayout();

    public FailedDisksDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize(DiskHealthDialogConstants.DIALOG_SIZE_600X375, this);
        UiMethod.putScreenCenter(this);
        this.setTitle(ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.title"));
        this.add(this.layout);
    }

    private void setTable() {
        this.layout.getTableModel().removeAll();
        Map<String, AnalyzeDevice> allDev = DiskAnalyzeContext.getInstance().getDeviceMap();
        for (Map.Entry<String, AnalyzeDevice> entry : allDev.entrySet()) {
            AnalyzeDevice ad = entry.getValue();
            List<AnalyzeDisk> subFailedDisk = ad.getFailedDiskList();
            if (null == subFailedDisk) continue;
            this.initTableData(subFailedDisk, ad);
        }
    }

    private TableRow<AnalyzeDisk, String> createTableRow(AnalyzeDisk ad, AnalyzeDevice dev) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)ad, (Object)ad.getSn());
        row.setValueAt(0, (Object)this.getValidString(ad.getSn()));
        row.setValueAt(1, (Object)this.getValidString(dev.getDeviceInfo().getDeviceSerialNumber()));
        List<String> reason = ad.getFailedReason();
        Rule rule = RuleManager.getInstance().getRule(ad.getType());
        if (null == rule) {
            String reasonFinal = ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.rulefailed.0");
            row.setValueAt(2, (Object)reasonFinal);
            return row;
        }
        String reasonFinal = "";
        switch (Integer.parseInt(reason.get(0))) {
            case 0: {
                reasonFinal = ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.0");
                break;
            }
            case 1: {
                reasonFinal = ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.1");
                break;
            }
            case 2: {
                reasonFinal = this.getCkReason(reason, rule, false);
                break;
            }
            case 3: {
                reasonFinal = this.getCkReason(reason, rule, true);
                break;
            }
            case 4: {
                reasonFinal = ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.5");
                break;
            }
        }
        row.setValueAt(2, (Object)reasonFinal);
        return row;
    }

    private String getCkReason(List<String> reason, Rule rule, boolean isInvalid) {
        AnalyzeItem item = rule.getItemById(reason.get(2));
        String itemName = "";
        String result = "";
        itemName = LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH) ? item.getNameEn() : item.getNameZh();
        result = isInvalid ? ResourceUtil.getStringWithParams((String)"diskhealthanalyze.faileddisksdialog.failed.3", (Object[])new Object[]{itemName}) : ResourceUtil.getStringWithParams((String)"diskhealthanalyze.faileddisksdialog.failed.2", (Object[])new Object[]{itemName});
        return result;
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FailedDisksDialog.this.confirmeAction();
            }
        });
    }

    private String getValidString(String text) {
        String str = text;
        if (null == text) {
            str = "";
        }
        return str;
    }

    private void initTableData(List<AnalyzeDisk> allFailedList, AnalyzeDevice dev) {
        for (AnalyzeDisk ad : allFailedList) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(ad, dev)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }
}

