/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.exception.OutOfDiskSpaceException;
import com.huawei.ism.tool.diskanalyze.ui.ImportWarningType;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.worktaker.IParseWorktaker;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class ImportCallable
implements Callable<ImportWarningType> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ImportCallable.class);
    private File selectFile = null;
    private IParseWorktaker parseWorktaker;

    public ImportCallable(File selectFile, IParseWorktaker parseWorktaker) {
        this.selectFile = selectFile;
        this.parseWorktaker = parseWorktaker;
    }

    @Override
    public ImportWarningType call() {
        if (null == this.selectFile || !this.selectFile.exists()) {
            return ImportWarningType.NO_FILE_CHOOSE;
        }
        String path = "";
        try {
            path = this.selectFile.getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("get path error.", (Throwable)e);
            return ImportWarningType.NO_FILE_VALID;
        }
        try {
            if (!this.parseWorktaker.importPackage(path)) {
                return this.showErrorType();
            }
        }
        catch (OutOfDiskSpaceException e) {
            LOGGER.error("OutOfDiskSpaceException In ImportCallable:");
            return ImportWarningType.OUT_OF_DISK_SPACE;
        }
        Map<String, List<AnalyzeDevice>> devMap = DiskAnalyzeContext.getInstance().getReduplicateMap();
        if (devMap.isEmpty()) {
            return this.showErrorType();
        }
        if (DiskHealthAssistant.getInstance().findAnalyzeDev(devMap)) {
            return ImportWarningType.REDUPLICATE_INFO;
        }
        return ImportWarningType.NONE;
    }

    private ImportWarningType showErrorType() {
        if (this.selectFile.isDirectory()) {
            return ImportWarningType.NO_FILE_IN_DIR;
        }
        return ImportWarningType.NO_FILE_VALID;
    }
}

