/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.ui.ReduplicateInfoLayout;
import com.huawei.ism.tool.diskanalyze.ui.action.ConfirmeAction;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Dimension;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;

public class ReduplicateInfoDialog
extends JDialog {
    private static final long serialVersionUID = 4861213363111233886L;
    private static final Dimension DIALOG_SIZE = new Dimension(600, 375);
    private static final String EMPTY_FORMAT = "--";
    private ReduplicateInfoLayout layout = new ReduplicateInfoLayout();

    public ReduplicateInfoDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize(DIALOG_SIZE, this);
        UiMethod.putScreenCenter(this);
        this.setTitle(ResourceUtil.getString((String)"diskhealthanalyze.reduplicatedialog.prompt"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        JButton closeBtn = this.layout.getConfirmeBtn();
        closeBtn.addActionListener(new ConfirmeAction(this));
    }

    private void setTable() {
        Map<String, List<AnalyzeDevice>> reduplicateMap = DiskAnalyzeContext.getInstance().getReduplicateMap();
        ArrayList<AnalyzeDevice> reduplicateList = new ArrayList<AnalyzeDevice>();
        for (Map.Entry<String, List<AnalyzeDevice>> entry : reduplicateMap.entrySet()) {
            List<AnalyzeDevice> tempList = entry.getValue();
            if (tempList.size() < 1) continue;
            reduplicateList.addAll(tempList);
        }
        this.initTableData(reduplicateList);
        Map<String, AnalyzeDevice> versionNotSupportMap = DiskAnalyzeContext.getInstance().getVersionNotSupportMap();
        ArrayList<AnalyzeDevice> versionNotSupportList = new ArrayList<AnalyzeDevice>();
        for (Map.Entry entry : versionNotSupportMap.entrySet()) {
            versionNotSupportList.add((AnalyzeDevice)entry.getValue());
        }
        this.initVerNotSupportData(versionNotSupportList);
        List<AnalyzeDevice> unParseList = DiskAnalyzeContext.getInstance().getSenceUnParseList();
        if (DiskAnalyzeContext.getInstance().isScene() && !unParseList.isEmpty()) {
            this.initSenceUnParseData(unParseList);
        }
    }

    private TableRow<AnalyzeDevice, String> createTableRow(AnalyzeDevice ad, String reason) {
        DevNode devNode;
        String uuid = ad.getUuid();
        if (StringUtils.isNULLStr((String)uuid) && DiskAnalyzeContext.getInstance().isScene()) {
            uuid = ad.getInfoPackage().getName();
        }
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)ad, (Object)uuid);
        File file = ad.getInfoPackage();
        if (null != file) {
            row.setValueAt(0, (Object)file.getName());
        }
        if (null != (devNode = ad.getDeviceInfo())) {
            row.setValueAt(1, (Object)ad.getDeviceInfo().getDeviceName());
            row.setValueAt(2, (Object)ad.getDeviceInfo().getDeviceSerialNumber());
        } else {
            row.setValueAt(1, (Object)EMPTY_FORMAT);
            row.setValueAt(2, (Object)EMPTY_FORMAT);
        }
        Date date = ad.getPackageDate();
        if (null != date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = formatter.format(date);
            row.setValueAt(3, (Object)dateString);
        } else {
            row.setValueAt(3, (Object)EMPTY_FORMAT);
        }
        row.setValueAt(4, (Object)reason);
        return row;
    }

    private void initTableData(List<AnalyzeDevice> adList) {
        this.layout.getTableModel().removeAll();
        for (AnalyzeDevice ad : adList) {
            String reason = ResourceUtil.getStringWithParams((String)"diskhealthanalyze.reduplicatedialog.reason.0", (Object[])new Object[]{ad.getReason()});
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(ad, reason)});
        }
    }

    private void initVerNotSupportData(List<AnalyzeDevice> adList) {
        String reason = ResourceUtil.getString((String)"diskhealthanalyze.reduplicatedialog.reason.1");
        for (AnalyzeDevice ad : adList) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(ad, reason)});
        }
    }

    private void initSenceUnParseData(List<AnalyzeDevice> adList) {
        String reason = ResourceUtil.getString((String)"diskhealthanalyze.warning.nofilevalid");
        for (AnalyzeDevice ad : adList) {
            TableRow<AnalyzeDevice, String> row = this.createTableRow(ad, reason);
            this.layout.getTableModel().addRow(new TableRow[]{row});
        }
    }
}

