/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.ui.SupportDeviceLayout;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;

public class SupportDeviceDialog
extends JDialog {
    private static final long serialVersionUID = 8886499533270764044L;
    private static final String STRING_DEFAULT = "DEFAULT";
    private static final String FUSION_STORAGE = "FusionStorage";
    private static final Dimension DIALOG_SIZE = new Dimension(450, 530);
    private SupportDeviceLayout layout = new SupportDeviceLayout();

    public SupportDeviceDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize(DIALOG_SIZE, this);
        UiMethod.putScreenCenter(this);
        this.setTitle(ResourceUtil.getString((String)"diskhealthanalyze.supportdialog.title"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupportDeviceDialog.this.confirmeAction();
            }
        });
    }

    private void setTable() {
        Map<String, String> devSeriesMap = CommonCheckLogic.getInstance().getDeviceSeriesMap();
        Map<String, Set<String>> supportVersionMap = CommonCheckLogic.getInstance().getSupportedVersions();
        ArrayList<String> devSeriesList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : devSeriesMap.entrySet()) {
            String devType = entry.getKey();
            if (devType.equals(STRING_DEFAULT)) continue;
            devSeriesList.add(devType);
        }
        this.initTableData(devSeriesList, supportVersionMap);
    }

    private TableRow<String, String> createTableRow(String devType, Map<String, Set<String>> supportVersionMap) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)devType, (Object)devType);
        row.setValueAt(0, (Object)devType);
        Set<String> versionsSet = supportVersionMap.get(devType);
        ArrayList<String> versions = new ArrayList<String>(versionsSet);
        this.sortVersions(versions);
        StringBuffer supportVer = new StringBuffer();
        for (String ver : versions) {
            supportVer.append(",");
            supportVer.append(ver);
        }
        String supVerStr = supportVer.toString();
        if (!supVerStr.isEmpty()) {
            supVerStr = supVerStr.substring(",".length());
        }
        if (supVerStr.endsWith("+")) {
            supVerStr = supVerStr.replace("+", ResourceUtil.getString((String)"diskhealthanalyze.supportdialog.table.supVerStr"));
        }
        row.setValueAt(1, (Object)supVerStr);
        return row;
    }

    private void initTableData(List<String> devSeries, Map<String, Set<String>> supportVersionMap) {
        this.layout.getTableModel().removeAll();
        Collections.sort(devSeries);
        for (String dev : devSeries) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(dev, supportVersionMap)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }

    private void sortVersions(List<String> vers) {
        if (null != vers) {
            Collections.sort(vers, new StringComparator());
        }
    }

    static class StringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return Collator.getInstance().compare(s1, s2);
        }
    }
}

