/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui.action;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.silent.export.DiskHealthAnalyzeSilentProcessAction;
import com.huawei.ism.tool.diskanalyze.ui.DiskHealthAnalyzeDialog;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskAnalyzeAction
implements IStartAction {
    private static final Logger log = LoggerFactory.getLogger(DiskAnalyzeAction.class);
    private static final String START_MODE = "startMode";
    private static final String DEV_COUNT = "devCount";
    private static final String MODE_SILENT = "1";
    private static final String SILENT_DIR = "smartInfoDir";
    private static final String LANG = "language";
    private static final String TOOL_RUNNING_FLAG = "runningFlag";
    private static final String BACKEND_FLAG = "backFlag";
    static FileOutputStream os = null;
    static FileLock lock = null;

    public void actionPerformed(Window arg0, ActionEvent arg1) {
        String path = DiskHealthAssistant.getEnv("DISK_SMARTINFO_PATH");
        if (null == path && DiskAnalyzeContext.getInstance().isScene()) {
            path = DiskHealthAssistant.getEnv("jsonSceneResultPath");
        }
        log.info("COLLECT_TOOL_INPUT_PATH = {}", (Object)StringUtils.getCleanMessage((String)path));
        log.info("workPath: {}, tmp path: {}", (Object)ApplicationContext.getInstance().getWorkPath(), (Object)ApplicationContext.getInstance().getTmpPath());
        String startMode = System.getenv(START_MODE);
        String devCount = System.getenv(DEV_COUNT);
        this.loadinfo();
        RuleManager.getInstance().init();
        if (!StringUtils.isNULLStr((String)startMode) && startMode.equals(MODE_SILENT)) {
            try {
                log.info("start silent process disk health analyzed...");
                this.releaseForegroundLock();
                DiskAnalyzeAction.addBackgroundLock();
                String silentPath = System.getenv(SILENT_DIR);
                String language = System.getenv(LANG);
                if (StringUtils.isNULLStr((String)silentPath)) {
                    log.error("silentPath got from env is null or empty, exit.");
                    DiskAnalyzeContext.getInstance().exitSys();
                    return;
                }
                DiskAnalyzeContext.getInstance().setProgressPath(silentPath);
                log.info("set progress file path: {}", (Object)StringUtils.getCleanMessage((String)silentPath));
                DiskHealthAnalyzeSilentProcessAction.getInstance().start(silentPath, language, devCount);
            }
            catch (RuntimeException e) {
                log.info("actionPerformed RuntimeException:", (Throwable)e);
                DiskAnalyzeContext.getInstance().exitSysAndSetExitCode(20);
            }
            catch (Exception e) {
                log.info("actionPerformed Exception:", (Throwable)e);
                DiskAnalyzeContext.getInstance().exitSysAndSetExitCode(20);
            }
        } else if (StringUtils.isNULLStr((String)path)) {
            DiskHealthAnalyzeDialog main = new DiskHealthAnalyzeDialog(arg0);
            main.setVisible(true);
        } else {
            DiskHealthAnalyzeDialog main = new DiskHealthAnalyzeDialog(arg0, path);
            main.autoImport();
            main.setVisible(true);
        }
    }

    private void loadinfo() {
        DiskAnalyzeContext.getInstance().setToolkitzhCN(Boolean.valueOf(System.getenv("toolkit.app.zh.version")));
    }

    public void releaseForegroundLock() {
        File file;
        FileOutputStream fos = ApplicationContext.getInstance().getToolLockStream();
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                fos = null;
            }
        }
        if ((file = new File(TOOL_RUNNING_FLAG)).exists()) {
            boolean result = file.delete();
            log.info("Release front lock {}", (Object)result);
        }
    }

    public static void addBackgroundLock() {
        try {
            os = new FileOutputStream(BACKEND_FLAG);
            lock = os.getChannel().tryLock();
        }
        catch (FileNotFoundException e) {
            log.error("Obtained back lock failed...");
        }
        catch (RuntimeException e1) {
            log.error("Obtained back lock failed...");
        }
        catch (IOException e) {
            log.error("Could not lock on this channel.");
            try {
                lock.release();
            }
            catch (IOException e1) {
                log.error("Release lock fail.");
            }
        }
    }
}

