/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.ui.listener;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.DiskHealthAnalyzeUserOpData;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;

public class DiskAnalyzeWindowListener
extends WindowAdapter {
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_END_TIME = "endTime";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String EMPTY_VALUE = "";
    private static final String TOOL_ID = "diskanalyze";
    private static final String SCENE_DEV_STATUS_SUCCESS = "success";
    private JDialog parent;

    public DiskAnalyzeWindowListener(JDialog parent) {
        this.parent = parent;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"diskhealthanalyze.maindialog.desc.quite"));
        if (0 == wdialog.getValue()) {
            this.parent.dispose();
            this.callbackScene();
            this.callbackUserData();
            StringBuilder tmpPath = new StringBuilder();
            tmpPath.append(ApplicationContext.getInstance().getWorkPath());
            tmpPath.append(File.separator);
            tmpPath.append(ApplicationContext.getInstance().getTmpPath());
            DiskHealthAssistant.getInstance().delFolder(tmpPath.toString());
            DiskAnalyzeContext.getInstance().clear();
            DiskAnalyzeContext.getInstance().fireToolStopped();
        }
    }

    private void callbackUserData() {
        List<DiskHealthAnalyzeUserOpData> userDataList = DiskAnalyzeContext.getInstance().getUserOpDataList();
        boolean openFile = DiskAnalyzeContext.getInstance().isOpenHelpFile();
        if (!userDataList.isEmpty()) {
            for (DiskHealthAnalyzeUserOpData userOpData : userDataList) {
                Long taskEndTime = userOpData.getTaskEndTime();
                if (taskEndTime == 0L) {
                    userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
                }
                userOpData.setOpenHelpFile(openFile);
            }
            UserOpDataSaveUtil.batchSaveUserOpdata(userDataList);
        }
    }

    private void callbackScene() {
        if (!DiskAnalyzeContext.getInstance().isScene()) {
            return;
        }
        List<String> selectList = DiskAnalyzeContext.getInstance().getDeviceList();
        List<AnalyzeDevice> devList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(selectList);
        ArrayList<Map<String, String>> sceneDevs = new ArrayList<Map<String, String>>();
        String curTiem = this.getCurFarmatTime();
        if (!devList.isEmpty()) {
            for (AnalyzeDevice analyzeDevice : devList) {
                sceneDevs.add(this.createAnalyInfo(analyzeDevice, curTiem));
            }
        } else {
            sceneDevs.add(this.createEmptyInfo());
        }
        DiskAnalyzeContext.getInstance().finishedSceneTask(sceneDevs);
    }

    private Map<String, String> createAnalyInfo(AnalyzeDevice analyzeDevice, String time) {
        HashMap<String, String> sceneDev = new HashMap<String, String>();
        String snNum = analyzeDevice.getDeviceInfo().getDeviceSerialNumber();
        String logFilepath = analyzeDevice.getInfoPackage().getAbsolutePath();
        String ipStr = DiskAnalyzeContext.getInstance().getSceneKeyVal(snNum, SCENE_IP);
        if (DiskAnalyzeContext.getInstance().isSceneLog(logFilepath, snNum)) {
            sceneDev.put(SCENE_DEV_STATUS, SCENE_DEV_STATUS_SUCCESS);
            sceneDev.put(SCENE_SN, snNum);
            sceneDev.put(SCENE_IP, ipStr);
            sceneDev.put(SCENE_END_TIME, time);
            sceneDev.put(SCENE_TOOL_ID, TOOL_ID);
        }
        return sceneDev;
    }

    private Map<String, String> createEmptyInfo() {
        HashMap<String, String> sceneDev = new HashMap<String, String>();
        sceneDev.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        sceneDev.put(SCENE_SN, EMPTY_VALUE);
        sceneDev.put(SCENE_IP, EMPTY_VALUE);
        sceneDev.put(SCENE_END_TIME, EMPTY_VALUE);
        sceneDev.put(SCENE_TOOL_ID, TOOL_ID);
        return sceneDev;
    }

    private String getCurFarmatTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }
}

