/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeEngine;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeStatus;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeSummary;
import com.huawei.ism.tool.diskanalyze.entity.DiskHealthAnalyzeUserOpData;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.ToolSceneData;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessAnalyzeSummary;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public final class DiskAnalyzeContext
extends AbstractContext {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DiskAnalyzeContext.class);
    private static final DiskAnalyzeContext INSTANCE = new DiskAnalyzeContext();
    private static final String SCENE_RESULT_PATH = "jsonSceneResultPath";
    private static final String SCENE_TOOL_ID = "collect";
    private static final String SCENE_LOG_NAME = "fileName";
    private static final String SINGLE_TOOL_SCENE = "Diskanalyze_Scene";
    public static final int INIT_PROGRESS = 70;
    public static final int INT_100 = 100;
    private static final int EXECUTOR_NUM = 4;
    private List<DiskHealthAnalyzeUserOpData> userOpDataList = new ArrayList<DiskHealthAnalyzeUserOpData>();
    private AnalyzeStatus analyzeStatus;
    private AnalyzeSummary analyzeSummary;
    private List<String> deviceIdList;
    private Map<String, AnalyzeDevice> deviceMap;
    private Map<String, List<AnalyzeDevice>> reduplicateMap;
    private Map<String, AnalyzeDevice> versionNotSupportMap;
    private List<AnalyzeDevice> senceUnParseList;
    private List<File> needDeleteFolder = new LinkedList<File>();
    private List<AnalyzeDevice> devices = new LinkedList<AnalyzeDevice>();
    public final AtomicInteger DEV_COUNT = new AtomicInteger(0);
    private ExecutorService fixNumExecutor;
    private List<File> fileToDel = new LinkedList<File>();
    private String progressPath = "";
    public final AtomicInteger SUCC_COUNT = new AtomicInteger(0);
    private int taskCount = -1;
    private boolean toolkitZhCN = false;
    private boolean openHelpFile = false;
    private List<String> selectDeviceUUID = new ArrayList<String>();
    private Object lock = new Object();

    private DiskAnalyzeContext() {
        this.analyzeStatus = AnalyzeStatus.BEFORE_ANALYZE;
        this.analyzeSummary = new AnalyzeSummary();
        this.deviceIdList = new ArrayList<String>();
        this.deviceMap = new HashMap<String, AnalyzeDevice>();
        this.reduplicateMap = new HashMap<String, List<AnalyzeDevice>>();
        this.senceUnParseList = new ArrayList<AnalyzeDevice>();
        this.fixNumExecutor = Executors.newFixedThreadPool(4);
    }

    public static DiskAnalyzeContext getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSilentResult(AnalyzeDevice device, boolean isSuccess, String errMsg) {
        Object object = this.lock;
        synchronized (object) {
            List<Integer> diskNumInfo = this.getInfoInDisk(device.getDiskList());
            int total = device.getDiskList().size();
            int risk = diskNumInfo.get(0);
            int failed = diskNumInfo.get(2);
            SilentProcessAnalyzeSummary summary = new SilentProcessAnalyzeSummary(total, risk, failed);
            if (isSuccess && risk != 0) {
                isSuccess = false;
                String string = errMsg = errMsg.isEmpty() ? ResourceUtil.getString((String)"silent.errmsg.existriskdisk") : errMsg;
            }
            if (isSuccess) {
                this.SUCC_COUNT.incrementAndGet();
            }
            SilentProcessData data = new SilentProcessData(device.getDeviceInfo(), isSuccess ? "success" : "failed", "finished", errMsg);
            data.setSummary(summary);
            data.setProcess("100");
            SilentProcessData totalData = new SilentProcessData();
            totalData.setStatus("running");
            LOGGER.info(String.format(Locale.ENGLISH, "update silent result: %s", data.toString()));
            SilentProcessToFile.updateDeviceData((SilentProcessData)data, (String)this.progressPath);
            totalData.setResult("");
            int progress = 100 - 30 / this.devices.size() * this.DEV_COUNT.get();
            progress = progress < 70 || progress > 100 ? 70 : progress;
            totalData.setProcess(String.valueOf(progress));
            LOGGER.info(String.format(Locale.ENGLISH, "update total result: %s", totalData.toString()));
            SilentProcessToFile.updateProcessData((SilentProcessData)totalData, (String)this.progressPath);
        }
    }

    public void updateTotalResultWxisting() {
        SilentProcessData data = new SilentProcessData(String.valueOf(100));
        data.setStatus("finished");
        data.setResult(this.taskCount == this.SUCC_COUNT.get() && this.SUCC_COUNT.get() != 0 ? "success" : "failed");
        LOGGER.info(String.format(Locale.ENGLISH, "update total progress data before exit: %s", data));
        SilentProcessToFile.updateProcessData((SilentProcessData)data, (String)DiskAnalyzeContext.getInstance().getProgressPath());
    }

    public void updateAnalyzeSummary() {
        AnalyzeSummary analyzESummary = this.getAnalyzeSummary();
        analyzESummary.setTotalDeviceNum(this.devices.size());
        int succeedDevNum = 0;
        int totalDiskNum = 0;
        int riskTotal = 0;
        int midRiskNum = 0;
        int failedDiskNum = 0;
        int failedDevNum = 0;
        int collectDidkNum = 0;
        for (AnalyzeDevice analyzeDevice : this.devices) {
            if (analyzeDevice.isAnalyzeSuccess()) {
                ++succeedDevNum;
                this.calcDiskInfo(analyzeDevice);
                failedDiskNum += analyzeDevice.getFailedDiskList().size();
                riskTotal += analyzeDevice.getRiskDiskNum();
                midRiskNum += analyzeDevice.getMinRiskDiskList().size();
                collectDidkNum += analyzeDevice.getCollectDiskNum();
                analyzeDevice.getDiskList().removeAll(analyzeDevice.getFailedDiskList());
                totalDiskNum += analyzeDevice.getDiskList().size();
                continue;
            }
            ++failedDevNum;
        }
        analyzESummary.setSuccessDeviceNum(succeedDevNum);
        analyzESummary.setTotalDiskNum(totalDiskNum);
        analyzESummary.setFailedDiskNum(failedDiskNum);
        analyzESummary.setRiskDiskNum(riskTotal);
        analyzESummary.setMidRiskDiskNum(midRiskNum);
        analyzESummary.setFailedDeviceNum(failedDevNum);
        analyzESummary.setCollectDiskNum(collectDidkNum);
    }

    public List<AnalyzeDevice> getSelectAnalyzeDeviceList(List<String> uuidList) {
        ArrayList<AnalyzeDevice> list = new ArrayList<AnalyzeDevice>();
        for (String id : uuidList) {
            AnalyzeDevice ad = this.deviceMap.get(id);
            list.add(ad);
        }
        return list;
    }

    public void calcDiskInfo(AnalyzeDevice analyzeDevice) {
        AnalyzeEngine.getInstance().calcDiskInfo(analyzeDevice);
    }

    public List<Integer> getInfoInDisk(List<AnalyzeDisk> diskList) {
        ArrayList<Integer> diskNumInfo = new ArrayList<Integer>();
        int riskNum = 0;
        int minRiskNum = 0;
        int failedNum = 0;
        int collectDiskNum = 0;
        for (AnalyzeDisk analyzeDisk : diskList) {
            if (!analyzeDisk.isAnalyzeSuc()) {
                ++failedNum;
                continue;
            }
            if (analyzeDisk.getScore() == -1) {
                ++collectDiskNum;
                continue;
            }
            if (analyzeDisk.getScore() <= 30) {
                ++riskNum;
                continue;
            }
            if (analyzeDisk.getScore() > 60) continue;
            ++minRiskNum;
        }
        diskNumInfo.add(riskNum);
        diskNumInfo.add(minRiskNum);
        diskNumInfo.add(failedNum);
        diskNumInfo.add(collectDiskNum);
        return diskNumInfo;
    }

    public Map<String, List<AnalyzeDevice>> getReduplicateMap() {
        return this.reduplicateMap;
    }

    public void setReduplicateMap(Map<String, List<AnalyzeDevice>> reduplicateMap) {
        this.reduplicateMap = reduplicateMap;
    }

    public Map<String, AnalyzeDevice> getDeviceMap() {
        return this.deviceMap;
    }

    public List<File> getNeedDeleteFolder() {
        return this.needDeleteFolder;
    }

    public void setNeedDeleteFolder(List<File> needDeleteFolder) {
        this.needDeleteFolder = needDeleteFolder;
    }

    public void setDeviceMap(Map<String, AnalyzeDevice> deviceMap) {
        this.deviceMap = deviceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Class<DiskAnalyzeContext> clazz = DiskAnalyzeContext.class;
        synchronized (DiskAnalyzeContext.class) {
            this.analyzeSummary = new AnalyzeSummary();
            this.deviceIdList.clear();
            this.deviceMap.clear();
            this.reduplicateMap.clear();
            this.senceUnParseList.clear();
            this.userOpDataList.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public AnalyzeSummary getAnalyzeSummary() {
        return this.analyzeSummary;
    }

    public AnalyzeDevice getDeviceById(String device) {
        return this.deviceMap.get(device);
    }

    public List<String> getDeviceList() {
        return this.deviceIdList;
    }

    public void reAnalyzeClear() {
        for (Map.Entry<String, AnalyzeDevice> entry : this.deviceMap.entrySet()) {
            AnalyzeDevice ad = entry.getValue();
            ad.reAnalyzeClrear();
        }
        this.deviceIdList.clear();
        this.analyzeSummary = new AnalyzeSummary();
    }

    public AnalyzeStatus getAnalyzeStatus() {
        return this.analyzeStatus;
    }

    public void setAnalyzeStatus(AnalyzeStatus analyzeStatus) {
        this.analyzeStatus = analyzeStatus;
    }

    public void setDeviceIdList(List<String> deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public Map<String, AnalyzeDevice> getVersionNotSupportMap() {
        return this.versionNotSupportMap;
    }

    public void setVersionNotSupportMap(Map<String, AnalyzeDevice> versionNotSupportMap) {
        this.versionNotSupportMap = versionNotSupportMap;
    }

    public List<AnalyzeDevice> getSenceUnParseList() {
        return this.senceUnParseList;
    }

    public boolean isScene() {
        return SceneUtils.isScene() && !SceneUtils.isSpecialSubScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{SINGLE_TOOL_SCENE});
    }

    public String getSceneDir() {
        ScenePathValue scenePathValue = null;
        try {
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            scenePathValue = (ScenePathValue)environmentImpl.getEnvirValueByKey(SCENE_RESULT_PATH);
        }
        catch (ToolException e) {
            LOGGER.error("get collect dir faild!");
            return "";
        }
        if (null == scenePathValue) {
            LOGGER.info("get collect dir faild!");
            return "";
        }
        return scenePathValue.getJsonSceneResultPathValue();
    }

    public boolean isSceneLog(String logFileName, String sn) {
        String fileName = this.getSceneKeyVal(sn, SCENE_LOG_NAME);
        if (StringUtils.isNULLStr((String)fileName) || !logFileName.equals(fileName)) {
            LOGGER.info(String.format(Locale.ENGLISH, "xml:%s,confirm:%s", fileName, logFileName));
            return false;
        }
        return true;
    }

    public boolean isSceneLog(String logFileName) {
        Map<String, ToolSceneData> devNodesMap = this.getSceneDeviceMap();
        for (Map.Entry<String, ToolSceneData> entry : devNodesMap.entrySet()) {
            ToolSceneData sceneData = entry.getValue();
            if (!sceneData.getDeviceMap().containsValue(logFileName)) continue;
            return true;
        }
        return false;
    }

    public void importClear() {
        StringBuilder tmpPath = new StringBuilder();
        tmpPath.append(ApplicationContext.getInstance().getWorkPath());
        tmpPath.append(File.separator);
        tmpPath.append(ApplicationContext.getInstance().getTmpPath());
        tmpPath.append(File.separator);
        tmpPath.append("7zpackage");
        DiskHealthAssistant.getInstance().delFolder(tmpPath.toString());
        DiskAnalyzeContext.getInstance().clear();
    }

    public String getSceneKeyVal(String sn, String key) {
        Map<String, ToolSceneData> devNodesMap = this.getSceneDeviceMap();
        ToolSceneData sceneData = devNodesMap.get(sn);
        if (sceneData == null) {
            LOGGER.info("can't find need select devNode");
            return "";
        }
        return (String)sceneData.getDeviceMap().get(key);
    }

    public Map<String, ToolSceneData> getSceneDeviceMap() {
        HashMap<String, ToolSceneData> sceneDevics = new HashMap();
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneDevics = environment.getDataVarMap(SCENE_TOOL_ID);
        }
        catch (ToolException e) {
            LOGGER.error("can't get device node map");
        }
        return sceneDevics;
    }

    public void finishedSceneTask(List<Map<String, String>> callBackMap) {
        TaskResult result = null;
        try {
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            result = environmentImpl.finishedSceneTask(callBackMap);
        }
        catch (ToolException e) {
            LOGGER.error("scene call back faild!");
        }
        if (null == result || !result.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            LOGGER.info("scene call back faild!");
        }
    }

    public String getDevVersionWithoutSPC(String version) {
        return version.toUpperCase(Locale.ENGLISH).split("SPC")[0];
    }

    public List<AnalyzeDevice> getDevices() {
        return this.devices;
    }

    public ExecutorService getFixNumExecutor() {
        return this.fixNumExecutor;
    }

    public List<File> getFileToDel() {
        return this.fileToDel;
    }

    public String getProgressPath() {
        return this.progressPath;
    }

    public void setProgressPath(String progressPath) {
        this.progressPath = progressPath;
    }

    public void exitSys() {
        this.exitSysAndSetExitCode(0);
    }

    public void exitSysAndSetExitCode(int exitcode) {
        LOGGER.info(String.format(Locale.ENGLISH, "background process exiting... exitcode ->%d", exitcode));
        Runtime runtime = Runtime.getRuntime();
        runtime.exit(exitcode);
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public boolean isToolkitZhCN() {
        return this.toolkitZhCN;
    }

    public void setToolkitzhCN(boolean Toolkit_zh_CN) {
        this.toolkitZhCN = Toolkit_zh_CN;
    }

    public List<DiskHealthAnalyzeUserOpData> getUserOpDataList() {
        return this.userOpDataList;
    }

    public void initUserOpData(List<String> uuidList) {
        List<DiskHealthAnalyzeUserOpData> userOpDatasList = this.getUserOpDataList();
        List<AnalyzeDevice> devicesList = this.getSelectAnalyzeDeviceList(uuidList);
        for (AnalyzeDevice analyzeDevice : devicesList) {
            DiskHealthAnalyzeUserOpData opData = new DiskHealthAnalyzeUserOpData();
            opData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
            opData.setDevNode(analyzeDevice.getDeviceInfo());
            opData.setAllDiskNum(analyzeDevice.getTotalDisk());
            opData.setSucceedDiskNum(analyzeDevice.getSucceedDisk());
            opData.setCollectTime(analyzeDevice);
            userOpDatasList.add(opData);
        }
    }

    public void buildUserOpData(List<String> uuidList) {
        List<AnalyzeDevice> devicesList = this.getSelectAnalyzeDeviceList(uuidList);
        for (AnalyzeDevice analyzeDevice : devicesList) {
            DiskHealthAnalyzeUserOpData userOpData = this.getDeviceUserOpData(analyzeDevice);
            if (null == userOpData) continue;
            DevNode node = analyzeDevice.getDeviceInfo();
            if (null != node) {
                userOpData.setDeviceType(node.getDeviceType().toString());
                userOpData.setDeviceVersion(node.getProductVersion());
                userOpData.setDeviceSn(node.getDeviceSerialNumber());
            }
            List<Integer> summary = this.getInfoInDisk(analyzeDevice.getDiskList());
            userOpData.setRiskDiskNum(summary.get(0));
            userOpData.setRiskDiskInfo(analyzeDevice);
            userOpData.setCollectTime(analyzeDevice);
            userOpData.setAnalyzeDiskType(analyzeDevice);
            userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        }
    }

    public DiskHealthAnalyzeUserOpData getDeviceUserOpData(AnalyzeDevice analyzeDevice) {
        List<DiskHealthAnalyzeUserOpData> userOpDatasList = DiskAnalyzeContext.getInstance().getUserOpDataList();
        for (DiskHealthAnalyzeUserOpData userOpData : userOpDatasList) {
            if (!analyzeDevice.getDeviceInfo().getDeviceSerialNumber().equals(userOpData.getDeviceSn())) continue;
            return userOpData;
        }
        return null;
    }

    public boolean isOpenHelpFile() {
        return this.openHelpFile;
    }

    public void setOpenHelpFile(boolean openHelpFile) {
        this.openHelpFile = openHelpFile;
    }

    public List<String> getSelectDeviceUUID() {
        return this.selectDeviceUUID;
    }

    public void setSelectDeviceUUID(List<String> selectDeviceUUID) {
        this.selectDeviceUUID = selectDeviceUUID;
    }
}

