/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.tool.diskanalyze.entity.Deduction;
import com.huawei.ism.tool.diskanalyze.entity.RaidLevel;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskDomainScoreConfig {
    private static final Logger log = LoggerFactory.getLogger(DiskDomainScoreConfig.class);
    private static List<Deduction> DEDUCTIONS;
    private static final String CUSTOM_CONFIG = "configuration/rule.json";
    private static final String DEFAULT_CONFIG = "config/rule.json";

    private static void init() {
        DiskDomainScoreConfig.loadCustomRuleConfig();
        if (DEDUCTIONS == null) {
            DiskDomainScoreConfig.loadDefaultRule();
        }
    }

    private static void loadCustomRuleConfig() {
        File ruleFile = new File(CUSTOM_CONFIG);
        if (!ruleFile.exists()) {
            log.warn("custom rule.json is not exits, load rule.json default");
            return;
        }
        try {
            DiskDomainScoreConfig.loadRulesFromjson(FileUtils.readFileToString((File)ruleFile, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("load custom rule.json error.", (Throwable)e);
        }
    }

    private static void loadDefaultRule() {
        try (InputStream in = DiskDomainScoreConfig.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG);){
            DiskDomainScoreConfig.loadRulesFromjson(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("load default rule.json error.", (Throwable)e);
        }
    }

    private static void loadRulesFromjson(String ruleJson) {
        if (StringUtils.isBlank((CharSequence)ruleJson)) {
            log.warn("rule json is blank.");
            return;
        }
        log.info("rule json is: {}", (Object)ruleJson);
        DEDUCTIONS = (List)JSON.parseObject((String)ruleJson, (TypeReference)new TypeReference<ArrayList<Deduction>>(){}, (Feature[])new Feature[0]);
    }

    public static Optional<Deduction> queryRuleByRaidLevel(RaidLevel raidLevel) {
        if (DEDUCTIONS == null || DEDUCTIONS.isEmpty()) {
            return Optional.empty();
        }
        return DEDUCTIONS.stream().filter(deduction -> deduction.getRaidLevel() == raidLevel).findFirst();
    }

    static {
        DiskDomainScoreConfig.init();
    }
}

