/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.LocalZipUtils;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public final class DiskHealthAssistant {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DiskHealthAssistant.class);
    private static final DiskHealthAssistant INSTANCE = new DiskHealthAssistant();
    public static final String TIME_STYLE_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSSZ = "yyyy-MM-dd HH:mm:ss z";
    public static final String TIME_STYLE_HHMMSS = "HH:mm:ss";

    private DiskHealthAssistant() {
    }

    public boolean isZipFile(File file) {
        String ext = this.getExtName(file.getName());
        boolean sign = ext.equals("zip");
        return sign;
    }

    public static DiskHealthAssistant getInstance() {
        return INSTANCE;
    }

    public String getPackagePath(File file) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(ApplicationContext.getInstance().getWorkPath());
        tmp.append(File.separator);
        tmp.append(ApplicationContext.getInstance().getTmpPath());
        String packageName = "7zpackage";
        Date date = new Date();
        StringBuilder name = new StringBuilder();
        name.append(file.getName());
        name.append("_");
        name.append(date.getTime());
        StringBuilder path = new StringBuilder();
        path.append((CharSequence)tmp);
        path.append(File.separator);
        path.append(packageName);
        path.append(File.separator);
        path.append((CharSequence)name);
        return path.toString();
    }

    public String getExtName(String fileName) {
        int subNum = fileName.lastIndexOf(".");
        String subName = fileName.substring(subNum + 1, fileName.length());
        return subName;
    }

    public String getNameOnly(String fileName) {
        int subNum = fileName.lastIndexOf(".");
        String subName = fileName.substring(0, subNum);
        return subName;
    }

    public String getSmartPath(AnalyzeDevice ad) {
        File file = ad.getInfoPackage();
        String path = "";
        path = this.isZipFile(file) ? (ad.isOtherSeparator() ? "Information/disksmartinfo/smart" : "Information\\disksmartinfo\\smart") : (ad.isOtherSeparator() ? "DataCollect/disksmartinfo/smart" : "DataCollect\\disksmartinfo\\smart");
        return path;
    }

    public String getSummaryPath(AnalyzeDevice dev, boolean validFileSign1, File devFile) {
        String summaryPath = "";
        if (this.isZipFile(devFile)) {
            if (validFileSign1) {
                summaryPath = "Information/disksmartinfo/summary.ini";
                dev.setOtherSeparator(true);
            } else {
                summaryPath = "Information\\disksmartinfo\\summary.ini";
                dev.setOtherSeparator(false);
            }
        } else if (validFileSign1) {
            summaryPath = "DataCollect/disksmartinfo/summary.ini";
            dev.setOtherSeparator(true);
        } else {
            summaryPath = "DataCollect\\disksmartinfo\\summary.ini";
            dev.setOtherSeparator(false);
        }
        return summaryPath;
    }

    public String getBasicPath(AnalyzeDevice dev, boolean validFileSign1, File devFile) {
        String basicPath = "";
        if (this.isZipFile(devFile)) {
            if (validFileSign1) {
                basicPath = "Information/disksmartinfo/basicinfo.txt";
                dev.setOtherSeparator(true);
            } else {
                basicPath = "Information\\disksmartinfo\\basicinfo.txt";
                dev.setOtherSeparator(false);
            }
        } else if (validFileSign1) {
            basicPath = "DataCollect/disksmartinfo/basicinfo.txt";
            dev.setOtherSeparator(true);
        } else {
            basicPath = "DataCollect\\disksmartinfo\\basicinfo.txt";
            dev.setOtherSeparator(false);
        }
        return basicPath;
    }

    public boolean findAnalyzeDev(Map<String, List<AnalyzeDevice>> devMap) {
        ArrayList<AnalyzeDevice> reduplicateList = new ArrayList<AnalyzeDevice>();
        HashMap<String, AnalyzeDevice> versionNotSupportMap = new HashMap<String, AnalyzeDevice>();
        ArrayList<String> waitToDelDevMapIdList = new ArrayList<String>();
        ArrayList<AnalyzeDevice> analyzeList = new ArrayList<AnalyzeDevice>();
        for (Map.Entry<String, List<AnalyzeDevice>> entry : devMap.entrySet()) {
            List<AnalyzeDevice> tempList = entry.getValue();
            if (tempList.size() > 1) {
                reduplicateList.addAll(tempList);
                AnalyzeDevice latestAnalyzeDev = this.getLatestAnalyzeDevice(tempList);
                if (null == latestAnalyzeDev) continue;
                this.isNotSupportVersion(latestAnalyzeDev, versionNotSupportMap, analyzeList);
                tempList.remove(tempList.indexOf(latestAnalyzeDev));
                this.writeReason(tempList, latestAnalyzeDev.getInfoPackage().getName());
                devMap.put(entry.getKey(), tempList);
                continue;
            }
            if (this.isNotSupportVersion(tempList.get(0), versionNotSupportMap, analyzeList)) continue;
            waitToDelDevMapIdList.add(entry.getKey());
        }
        for (String devId : waitToDelDevMapIdList) {
            devMap.remove(devId);
        }
        HashMap<String, AnalyzeDevice> devAnalyzeMap = new HashMap<String, AnalyzeDevice>();
        for (AnalyzeDevice analyzeDevice : analyzeList) {
            String key = analyzeDevice.getUuid();
            devAnalyzeMap.put(key, analyzeDevice);
        }
        DiskAnalyzeContext.getInstance().setDeviceMap(devAnalyzeMap);
        DiskAnalyzeContext.getInstance().setVersionNotSupportMap(versionNotSupportMap);
        return !reduplicateList.isEmpty() || !versionNotSupportMap.isEmpty();
    }

    private boolean isNotSupportVersion(AnalyzeDevice ad, Map<String, AnalyzeDevice> versionNotSupportMap, List<AnalyzeDevice> analyzeList) {
        if (null == ad.getDeviceInfo() || null == ad.getDeviceInfo().getDeviceType() || !CommonCheckLogic.getInstance().isVersionSupported(ad.getDeviceInfo().getDeviceType().toString(), ad.getDeviceInfo().getProductVersion())) {
            versionNotSupportMap.put(ad.getDeviceInfo().getDeviceSerialNumber(), ad);
            return true;
        }
        analyzeList.add(ad);
        return false;
    }

    private void writeReason(List<AnalyzeDevice> devList, String pkgName) {
        for (AnalyzeDevice dev : devList) {
            dev.setReason(pkgName);
        }
    }

    private AnalyzeDevice getLatestAnalyzeDevice(List<AnalyzeDevice> devList) {
        AnalyzeDevice latestDev = null;
        for (AnalyzeDevice analyzeDevice : devList) {
            if (null == latestDev) {
                latestDev = analyzeDevice;
            }
            if (null == analyzeDevice.getPackageDate() || null == latestDev.getPackageDate() || analyzeDevice.getPackageDate().compareTo(latestDev.getPackageDate()) <= 0) continue;
            latestDev = analyzeDevice;
        }
        return latestDev;
    }

    public InputStream getTxtInputStream(String filename, AnalyzeDevice ad) {
        File zipPath = ad.getInfoPackage();
        String txtPath = "";
        txtPath = !filename.contains("\\") && !filename.contains("/") ? (ad.isOtherSeparator() ? "Information/disksmartinfo/" + filename : "Information\\disksmartinfo\\" + filename) : filename;
        InputStream in = null;
        try {
            in = LocalZipUtils.getTxtFileStreamOnZip(zipPath, txtPath);
        }
        catch (IOException e) {
            LOGGER.error(" get InputStream err:");
        }
        return in;
    }

    public void delFolder(String folderPath) {
        try {
            this.delAllFile(folderPath);
            String filePath = folderPath;
            File myFilePath = new File(filePath);
            if (myFilePath.delete()) {
                return;
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("file path is not exits.");
        }
        catch (Exception e) {
            LOGGER.error("delFolder failed.", (Throwable)e);
        }
    }

    private boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        if (null == tempList) {
            LOGGER.info("tempList is null.");
            return flag;
        }
        File temp = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("file path is not exists");
        }
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile() && !temp.delete()) {
                LOGGER.error("Delete file error" + temp);
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + "/" + tempList[i]);
            this.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static boolean checkUploadRight() {
        String code = System.getenv("toolRunRole");
        LOGGER.info(String.format(Locale.ENGLISH, "toolRunRole : %s", StringUtils.getCleanMessage((String)code)));
        return ToolUserRole.isRoleCanUplaod((String)code) && DiskAnalyzeContext.getInstance().isToolkitZhCN();
    }

    public static boolean copyRight(String srcPath, String destPath, int srcLimitCapacity, int destMiniCapacity) {
        File destFile = new File(destPath);
        if (!destFile.exists() && !destFile.mkdirs()) {
            LOGGER.info("create dir failed !");
            return false;
        }
        if (!destFile.canWrite()) {
            LOGGER.info("the file can not write.");
            return false;
        }
        if (!DiskHealthAssistant.checkDiskFreeSpace(destFile, destMiniCapacity)) {
            LOGGER.info("the file FreeSpace is not enough.");
            return false;
        }
        return true;
    }

    public static boolean checkDiskFreeSpace(File destFile, int miniCapacity) {
        long capacity = (long)miniCapacity * 1024L * 1024L;
        long destFileFreeSpace = destFile.getFreeSpace();
        return destFileFreeSpace >= capacity;
    }

    public static synchronized boolean checkStr(String str, String ... expectStrs) {
        if (StringUtils.isNULLStr((String)str)) {
            LOGGER.info("input str is null");
            return false;
        }
        for (String exStr : expectStrs) {
            if (!str.contains(exStr)) continue;
            return true;
        }
        return false;
    }

    public static String getEnv(String key) {
        String value = System.getProperty(key);
        if (null == value) {
            value = System.getenv(key);
        }
        return value;
    }

    public static void closeResource(Flushable flushed, Closeable closed) {
        try {
            if (null != flushed) {
                flushed.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error("Close output stream error...", (Throwable)e);
        }
        try {
            if (null != closed) {
                closed.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Close output stream error...", (Throwable)e);
        }
    }

    public static String formatDate(Object formatDate, String formatStyle) {
        String foramt = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStyle);
            if (formatDate instanceof Calendar) {
                return sdf.format(((Calendar)formatDate).getTime());
            }
            foramt = sdf.format(formatDate);
        }
        catch (Exception e) {
            LOGGER.error("format date error.", (Throwable)e);
        }
        return foramt;
    }
}

