/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import com.huawei.ism.tool.diskanalyze.service.IDiskDomainParse;
import com.huawei.ism.tool.diskanalyze.service.impl.DefaultDiskDomainParse;
import com.huawei.ism.tool.diskanalyze.service.impl.DoradoDiskDomainParse;
import com.huawei.ism.tool.diskanalyze.service.impl.DoradoV6DiskDomainParse;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainParseFactory {
    private static final Logger log = LoggerFactory.getLogger(DomainParseFactory.class);
    private static final DomainParseFactory INS = new DomainParseFactory();
    private static final String DORADO = "dorado";
    private static final String V6 = "v6";
    private static final String V3 = "v3";
    private static final List<String> DORADO_DEVICE_NOT_V6 = Arrays.asList("OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K", "OceanStor Dorado 18800K");

    private DomainParseFactory() {
    }

    public static DomainParseFactory getInstance() {
        return INS;
    }

    public IDiskDomainParse createParser(String productVersion) {
        if (this.isDorado(productVersion)) {
            if (this.isDoradoV6(productVersion)) {
                return new DoradoV6DiskDomainParse();
            }
            return new DoradoDiskDomainParse();
        }
        return new DefaultDiskDomainParse();
    }

    private boolean isDorado(String productVersion) {
        return StringUtils.containsIgnoreCase((CharSequence)productVersion, (CharSequence)DORADO);
    }

    private boolean isDoradoV6(String productVersion) {
        return StringUtils.containsIgnoreCase((CharSequence)productVersion, (CharSequence)DORADO) && StringUtils.containsIgnoreCase((CharSequence)productVersion, (CharSequence)V6) || DORADO_DEVICE_NOT_V6.contains(productVersion);
    }
}

