/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.slf4j.Logger;
import utils.FilesUtil;

public final class LocalZipUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LocalZipUtils.class);
    private static final Object LOCK = new Object();
    private static final int BUFF_SIZE = 1024;

    private LocalZipUtils() {
    }

    public static InputStream getTxtFileStreamOnZip(File zipFilePath, String pathAndName) throws IOException {
        return ZipUtils.getStreamFileOnZip((File)zipFilePath, (String)pathAndName).orElse(null);
    }

    private static String get7zPath() {
        StringBuffer buffer = new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("utils").append(File.separator).append("7z").append(File.separator);
        if (ApplicationContext.getInstance().isWindowsOS()) {
            buffer.append("7za");
        } else {
            buffer.append("7zsuse10").append(File.separator).append("7za");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listFile(String zipFilePath) {
        Class<LocalZipUtils> clazz = LocalZipUtils.class;
        synchronized (LocalZipUtils.class) {
            StringBuffer cmdSb = new StringBuffer().append("\"").append(LocalZipUtils.get7zPath()).append("\"").append(" l ").append("\"").append(zipFilePath).append("\"");
            ArrayList<String> list = new ArrayList<String>();
            String listLine = "";
            for (int loopTimes = 0; loopTimes < 3 && (null == (listLine = OSCmdUtils.executeCmd((String)cmdSb.toString())) || "".equals(listLine)); ++loopTimes) {
                LOGGER.info("The 7za.exe may exist some error!try again!");
            }
            if (null == listLine) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return list;
            }
            String[] lines = listLine.split("\r\n");
            boolean startAdd = false;
            for (String line : lines) {
                if (startAdd) {
                    if (line.equals("------------------- ----- ------------ ------------  ------------------------")) {
                        startAdd = false;
                        break;
                    }
                    int n = line.lastIndexOf(" ");
                    String subStr = line.substring(n);
                    list.add(subStr.trim());
                    continue;
                }
                if (!line.equals("------------------- ----- ------------ ------------  ------------------------")) continue;
                startAdd = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deCopmress7zFile(String targetPath, String zipFilePath, String targetFile) {
        Object object = LOCK;
        synchronized (object) {
            return LocalZipUtils.deCopmressFileBy7z(targetPath, zipFilePath, targetFile) || LocalZipUtils.deCopmressFileByZip(targetPath, zipFilePath, targetFile);
        }
    }

    private static boolean deCopmressFileByZip(String targetPath, String zipFilePath, String targetFile) {
        File srcFile = new File(zipFilePath);
        try {
            ZipUtils.decompressInnerFiles((File)srcFile, (String)targetPath, (String)targetFile);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("decompress file {} by zip error", (Object)zipFilePath, (Object)e);
            return false;
        }
    }

    private static boolean deCopmressFileBy7z(String targetPath, String zipFilePath, String targetFile) {
        File srcFile = new File(zipFilePath);
        try {
            LocalZipUtils.validate7zFile(srcFile);
            LocalZipUtils.deCopmress7zFileWithTargetFiles(srcFile, targetPath, targetFile);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("decompress file {} by 7z error", (Object)zipFilePath, (Object)e);
            return false;
        }
    }

    private static void validate7zFile(File servenZFile) throws IOException {
        if (!servenZFile.exists()) {
            LOGGER.error("decompressZipFile {} not exist", (Object)FilesUtil.getCanonicalPath(servenZFile));
            throw new IOException("decompressZipFile not exist");
        }
        if (!FileUtils.fileSize4GInvalid((File)servenZFile)) {
            LOGGER.error("the file size is over 4G. {}", (Object)FilesUtil.getCanonicalPath(servenZFile));
            throw new IOException("the file size is over 4G");
        }
    }

    private static boolean containsTargetFile(String fileName, String ... targetFiles) {
        return Arrays.stream(targetFiles).anyMatch(fileName::contains);
    }

    private static void deCopmress7zFileWithTargetFiles(File sevenZFile, String toPath, String ... targetFiles) throws IOException {
        try (SevenZFile srcFile = new SevenZFile(sevenZFile);){
            LocalZipUtils.unZip7ZFileWithTargetFiles(srcFile, toPath, targetFiles);
        }
        catch (Exception e) {
            LOGGER.error("decompressZipFile {} error", (Object)FilesUtil.getCanonicalPath(sevenZFile), (Object)e);
            throw new IOException("Failed to decompress 7zfile.");
        }
    }

    private static void unZip7ZFileWithTargetFiles(SevenZFile sevenZFile, String toPath, String ... targetFiles) throws IOException {
        SevenZArchiveEntry sevenZEntry = null;
        long fileNum = 0L;
        long maxNum = ApplicationContext.getInstance().getMaxUnzipFileNum();
        while ((sevenZEntry = sevenZFile.getNextEntry()) != null) {
            String fileName = ZipUtils.filterZipEntryName((String)sevenZEntry.getName());
            if (!LocalZipUtils.containsTargetFile(fileName, targetFiles)) continue;
            if (maxNum != 0L && ++fileNum > maxNum) {
                String msg = "Unzip file num more than limit " + maxNum;
                LOGGER.error(msg);
                FileUtils.clearDir((String)toPath);
                throw new IOException(msg);
            }
            if (sevenZEntry.isDirectory()) {
                FileUtils.createDir((String)(toPath + File.separator + fileName));
                continue;
            }
            LocalZipUtils.unZip7ZFile(sevenZEntry, sevenZFile, toPath);
        }
    }

    private static long unZip7ZFile(SevenZArchiveEntry zipEntry, SevenZFile zipFile, String toPath) throws IOException {
        byte[] buf = new byte[1024];
        File file = new File(toPath + File.separator + ZipUtils.filterZipEntryName((String)zipEntry.getName()));
        File parentFile = file.getParentFile();
        if (null != parentFile) {
            FileUtils.createDir((String)parentFile.getCanonicalPath());
        }
        long totalSize = 0L;
        long maxSize = ApplicationContext.getInstance().getMaxUnzipFileSize();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file.getCanonicalFile()));
             BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int readLen;
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
                if (maxSize == 0L || (totalSize += (long)readLen) <= maxSize) continue;
                FileUtils.clearDir((String)toPath);
                LOGGER.error("Current file {} unzip size {} is too larger than limit.", (Object)file.getCanonicalPath(), (Object)zipEntry.getSize());
                throw new IOException("File too larger.");
            }
        }
        return totalSize;
    }
}

