/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolFileParseUtils {
    private static final Logger log = LoggerFactory.getLogger(PoolFileParseUtils.class);
    private static final String END_SPLIT_SIGN = "------------";

    public static <T> List<T> parseList(List<String> lines, String splitRegex, Function<List<String>, T> parseFunction) {
        ArrayList<T> result = new ArrayList<T>();
        ArrayList<String> single = new ArrayList<String>();
        Pattern pattern = Pattern.compile(splitRegex);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (pattern.matcher(line.toLowerCase(Locale.ROOT)).find()) {
                PoolFileParseUtils.startParseNewEle(parseFunction, result, single, line);
                continue;
            }
            if (single.isEmpty()) continue;
            if (PoolFileParseUtils.isParagraphEnd(lines, i)) {
                result.add(parseFunction.apply(single));
                single.clear();
                break;
            }
            single.add(line);
        }
        if (!single.isEmpty()) {
            result.add(parseFunction.apply(single));
        }
        return result;
    }

    private static <T> void startParseNewEle(Function<List<String>, T> parseFunction, List<T> result, List<String> single, String line) {
        if (!single.isEmpty()) {
            result.add(parseFunction.apply(single));
            single.clear();
        }
        single.add(line);
    }

    private static boolean isParagraphEnd(List<String> lines, int curIndex) {
        if (lines.size() <= curIndex || curIndex < 2) {
            return false;
        }
        return lines.get(curIndex).contains(END_SPLIT_SIGN) && lines.get(curIndex - 1).equals("") && lines.get(curIndex - 2).equals("");
    }
}

