/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.worktaker.impl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeThread;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ComparatorByFields;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelResultBuilder.class);
    private static HSSFWorkbook workBook = new HSSFWorkbook();
    private Sheet storageDisk = null;
    private static CellStyle defaultStyle = null;
    private static CellStyle defaultStyleWithoutCenter = null;
    private static CellStyle riskStyle = null;
    private static CellStyle riskStyleWithoutCenter = null;
    private static CellStyle waringStyle = null;
    private static CellStyle waringStyleWithoutCenter = null;
    private static CellStyle needCollectStyle = null;
    private static CellStyle needCollectStyleWithoutCenter = null;
    private static CellStyle failedStyle = null;
    private static CellStyle failedStyleWithoutCenter = null;
    private static CellStyle tittleStyle = null;
    private static Font defaultFont = null;
    private static String fontName = "\u5b8b\u4f53";
    private static short fontSize = (short)10;
    private static final String NEWLINE = "\r\n";
    private static ExcelModel model = ExcelModel.COMMON;
    private static String rowNameKey = "diskhealthanalyze.excel.";
    private static String descHead = ResourceUtil.getString((String)"diskhealthanalyze.excel.desc.head");

    public ExcelResultBuilder() {
        String sheetName = ResourceUtil.getString((String)"diskhealthanalyze.excel.sheetName");
        int index = workBook.getSheetIndex(sheetName);
        if (-1 != index) {
            workBook.removeSheetAt(index);
        }
        this.storageDisk = workBook.createSheet(sheetName);
    }

    public void buildTittle() {
        List<RowModel> rowModels = model.getRowModels();
        Row tittleRow = this.storageDisk.createRow(0);
        for (int i = 0; i < rowModels.size(); ++i) {
            String tittle = ResourceUtil.getString((String)(rowNameKey + rowModels.get((int)i).nameKey));
            Cell cell = tittleRow.createCell(i);
            cell.setCellValue(tittle);
            cell.setCellStyle(tittleStyle);
            this.storageDisk.setColumnWidth(i, rowModels.get((int)i).rowWidth);
        }
    }

    public void buildSummary(AnalyzeDevice device) {
        int mergedIndex = this.storageDisk.getLastRowNum() + 1;
        ArrayList<AnalyzeDisk> allDisk = new ArrayList<AnalyzeDisk>();
        allDisk.addAll(device.getDiskList());
        allDisk.addAll(new HashSet<AnalyzeDisk>(device.getFailedDiskList()));
        if (allDisk.isEmpty()) {
            Row data = this.storageDisk.createRow(this.storageDisk.getLastRowNum() + 1);
            this.buildCommonInfo(device, data, 0);
        } else {
            Collections.sort(allDisk, new ComparatorByFields());
            for (AnalyzeDisk analyzeDisk : allDisk) {
                Row data = this.storageDisk.createRow(this.storageDisk.getLastRowNum() + 1);
                data.setHeight((short)(3 * this.storageDisk.getDefaultRowHeight()));
                int cellIndex = this.buildCommonInfo(device, data, 0);
                this.buildDiskInfo(analyzeDisk, data, cellIndex);
            }
        }
        this.commonMergedColumn(this.storageDisk, mergedIndex, allDisk.isEmpty() ? 0 : allDisk.size() - 1, model.getAutoMergedIndex());
    }

    private int buildDiskInfo(AnalyzeDisk analyzeDisk, Row row, int cellIndex) {
        StringBuffer descInfo = new StringBuffer();
        int score = analyzeDisk.getScore();
        String scoreStr = String.valueOf(score);
        CellStyle style = defaultStyle;
        CellStyle descStyle = defaultStyleWithoutCenter;
        if (analyzeDisk.isAnalyzeSuc()) {
            if (score == -1) {
                style = needCollectStyle;
                descStyle = needCollectStyleWithoutCenter;
                scoreStr = "--";
            } else if (score <= 30) {
                style = riskStyle;
                descStyle = riskStyleWithoutCenter;
            } else if (score <= 60) {
                style = waringStyle;
                descStyle = waringStyleWithoutCenter;
            }
            List<AnalyzeItemResult> itemsInfo = analyzeDisk.getResultList();
            this.buildItemInfo(itemsInfo, analyzeDisk, descInfo);
        } else {
            style = failedStyle;
            descStyle = failedStyleWithoutCenter;
            scoreStr = "--";
            descInfo.append(this.getFailedReson(analyzeDisk));
        }
        cellIndex = this.buildCellDataWithStyle(row, cellIndex, style, analyzeDisk.getEnclosureNo(), analyzeDisk.getSlotNo(), analyzeDisk.getShowDiskType(), analyzeDisk.getVender(), analyzeDisk.getVender(), analyzeDisk.getFirmwareVersion(), analyzeDisk.getSn(), scoreStr);
        return this.buildCellDataWithStyle(row, cellIndex, descStyle, descInfo);
    }

    private Object getFailedReson(AnalyzeDisk analyzeDisk) {
        List<String> reason = analyzeDisk.getFailedReason();
        Rule rule = RuleManager.getInstance().getRule(analyzeDisk.getType());
        if (null == rule) {
            return ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.rulefailed.0");
        }
        switch (Integer.parseInt(reason.get(0))) {
            case 0: {
                return ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.0");
            }
            case 1: {
                return ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.1");
            }
            case 2: {
                AnalyzeItem item = rule.getItemById(reason.get(2));
                return ResourceUtil.getStringWithParams((String)"diskhealthanalyze.faileddisksdialog.failed.3", (Object[])new Object[]{item.getName()});
            }
            case 3: {
                AnalyzeItem item = rule.getItemById(reason.get(2));
                return ResourceUtil.getStringWithParams((String)"diskhealthanalyze.faileddisksdialog.failed.2", (Object[])new Object[]{item.getName()});
            }
            case 4: {
                return ResourceUtil.getString((String)"diskhealthanalyze.faileddisksdialog.failed.5");
            }
        }
        return "";
    }

    private void buildItemInfo(List<AnalyzeItemResult> itemsInfo, AnalyzeDisk analyzeDisk, StringBuffer descInfo) {
        descInfo.append(descHead + NEWLINE);
        for (AnalyzeItemResult itemInfo : itemsInfo) {
            String itemName = itemInfo.getRule().getName();
            if (!this.isHaveDHA(analyzeDisk, itemName)) continue;
            descInfo.append(itemName);
            descInfo.append(ResourceUtil.getString((String)"diskhealthanalyze.excel.colon"));
            descInfo.append(-1 == itemInfo.getRiskLevel() ? "--" : Integer.valueOf(itemInfo.getRiskLevel()));
            descInfo.append(NEWLINE);
        }
        if (analyzeDisk.getPowerOnTime() != null) {
            descInfo.append(ResourceUtil.getString((String)"analyze.disk.detail.lifetime")).append(ResourceUtil.getString((String)"diskhealthanalyze.excel.colon")).append(analyzeDisk.getPowerOnTime()).append(NEWLINE);
        }
        if (analyzeDisk.getRaidLevel() != null) {
            descInfo.append("RAID Level").append(ResourceUtil.getString((String)"diskhealthanalyze.excel.colon")).append(analyzeDisk.getRaidLevel().toString()).append(NEWLINE);
        }
    }

    private int buildCommonInfo(AnalyzeDevice device, Row row, int cellIndex) {
        DevNode node = device.getDeviceInfo();
        String deviceType = node.getDeviceType().toString() + " " + node.getProductVersion();
        String ip = node.getDeviceName() + "(" + node.getIp() + ")";
        String deviceSN = node.getDeviceSerialNumber();
        int diskNum = device.getDiskList().size() + device.getFailedDiskList().size();
        int riskNum = device.getRiskDiskNum();
        return this.buildCellData(row, cellIndex, deviceType, ip, deviceSN, diskNum, riskNum);
    }

    public void commonMergedColumn(Sheet sheet, int startIndex, int mergedLength, List<Integer> columnIndexs) {
        CellStyle style = ExcelResultBuilder.newDefaultCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int columnIndex : columnIndexs) {
            if (0 < mergedLength) {
                sheet.addMergedRegion(new CellRangeAddress(startIndex, startIndex + mergedLength, columnIndex, columnIndex));
            }
            Cell typeCell = sheet.getRow(startIndex).getCell(columnIndex);
            typeCell.setCellStyle(style);
        }
    }

    private int buildCellDataWithStyle(Row row, int startIndex, CellStyle style, Object ... values) {
        for (Object value : values) {
            Cell cell = row.createCell(startIndex++);
            cell.setCellValue(value.toString());
            cell.setCellStyle(style);
        }
        return startIndex;
    }

    private int buildCellData(Row row, int startIndex, Object ... values) {
        return this.buildCellDataWithStyle(row, startIndex, defaultStyle, values);
    }

    private boolean isHaveDHA(AnalyzeDisk analyzeDisk, String itemName) {
        if (!"DHA".equals(itemName)) {
            return true;
        }
        return !analyzeDisk.getSn().equals(AnalyzeThread.HAVEDHA.get(analyzeDisk.getSn() + "N/A"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExcel(String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path + File.separator + "DiskHealthReport" + '_' + DiskHealthAssistant.formatDate(new Date(), "yyyyMMddHHmmss") + ".xls");
            workBook.write((OutputStream)fos);
            DiskHealthAssistant.closeResource(fos, fos);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + path, (Throwable)e);
        }
        finally {
            DiskHealthAssistant.closeResource(fos, fos);
        }
    }

    private static Font createFont(String name, short fontSizez, short color) {
        HSSFFont font = workBook.createFont();
        font.setFontName(name);
        font.setFontHeightInPoints(fontSizez);
        font.setColor(color);
        return font;
    }

    private static CellStyle newDefaultCellStyle(boolean isCenter) {
        HSSFCellStyle style = workBook.createCellStyle();
        ExcelResultBuilder.addBorder((CellStyle)style);
        style.setFont(defaultFont);
        style.setDataFormat(workBook.createDataFormat().getFormat("@"));
        style.setWrapText(true);
        if (isCenter) {
            ExcelResultBuilder.setCenter((CellStyle)style);
        }
        return style;
    }

    private static CellStyle newDefaultCellStyle() {
        return ExcelResultBuilder.newDefaultCellStyle(true);
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static void setCenter(CellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    static {
        defaultFont = ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        defaultStyle = ExcelResultBuilder.newDefaultCellStyle();
        defaultStyleWithoutCenter = ExcelResultBuilder.newDefaultCellStyle(false);
        riskStyle = ExcelResultBuilder.newDefaultCellStyle();
        riskStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        riskStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        riskStyleWithoutCenter = ExcelResultBuilder.newDefaultCellStyle(false);
        riskStyleWithoutCenter.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        riskStyleWithoutCenter.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        waringStyle = ExcelResultBuilder.newDefaultCellStyle();
        waringStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.ORANGE.getIndex());
        waringStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        waringStyleWithoutCenter = ExcelResultBuilder.newDefaultCellStyle(false);
        waringStyleWithoutCenter.setFillForegroundColor(HSSFColor.HSSFColorPredefined.ORANGE.getIndex());
        waringStyleWithoutCenter.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        needCollectStyle = ExcelResultBuilder.newDefaultCellStyle();
        needCollectStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        needCollectStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        needCollectStyleWithoutCenter = ExcelResultBuilder.newDefaultCellStyle(false);
        needCollectStyleWithoutCenter.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        needCollectStyleWithoutCenter.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        failedStyle = ExcelResultBuilder.newDefaultCellStyle();
        failedStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        failedStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        failedStyleWithoutCenter = ExcelResultBuilder.newDefaultCellStyle(false);
        failedStyleWithoutCenter.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        failedStyleWithoutCenter.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        tittleStyle = ExcelResultBuilder.newDefaultCellStyle();
        tittleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
        tittleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        tittleStyle.setFont(ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
    }

    private static enum RowModel {
        PRODUCTNAME("productName", true, 5100),
        IP("ip", true, 7140),
        DEVICESN("deviceSN", true, 6375),
        DISKNUM("diskNum", true, 2550),
        RISKNUM("riskNum", true, 2550),
        ENCNUM("encNum", false, 2550),
        SLOTNUM("soltNum", false, 2040),
        DISKTYPE("diskType", false, 2550),
        VENDOR("vendor", false, 2550),
        MODEL("model", false, 2550),
        FWVERSION("fwVersion", false, 3825),
        DISKSN("diskSN", false, 6375),
        SCORE("score", false, 2040),
        DESC("desc", false, 10200);

        String nameKey;
        boolean mergedColumn;
        int rowWidth;

        private RowModel(String nameKey, boolean mergedColumn, int rowWidth) {
            this.nameKey = nameKey;
            this.mergedColumn = mergedColumn;
            this.rowWidth = rowWidth;
        }
    }

    private static enum ExcelModel {
        COMMON(Arrays.asList(RowModel.values()));

        List<Integer> index = null;
        List<RowModel> rowModels = null;

        private ExcelModel(List<RowModel> rowModels) {
            this.rowModels = rowModels;
        }

        public List<RowModel> getRowModels() {
            return this.rowModels;
        }

        public List<Integer> getAutoMergedIndex() {
            if (null != this.index) {
                return this.index;
            }
            this.index = new ArrayList<Integer>();
            for (int i = 0; i < this.rowModels.size(); ++i) {
                if (!this.rowModels.get((int)i).mergedColumn) continue;
                this.index.add(i);
            }
            return this.index;
        }
    }
}

