/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.worktaker.impl;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.exception.OutOfDiskSpaceException;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.util.LocalZipUtils;
import com.huawei.ism.tool.diskanalyze.worktaker.IParseWorktaker;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import utils.FilesUtil;

public class ParseWorktakerImpl
extends AbstractWorktaker
implements IParseWorktaker {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ParseWorktakerImpl.class);
    private static final int SLEEP_TIME = 10;
    private static final int TIME_OUT_COUNT = 30000;
    private static final int VOLUM_UNIT = 1024;
    private static final int VOLUM_MIN = 10;
    private static final int FILE_NUM_MAX = 20000;
    private static final String DEV_IP_KEY = "smart analyzelog device ip";
    private static final String DEFAULT_STRING = "--";
    private static int nowFileNum = 0;

    public int getNowFileNum() {
        return nowFileNum;
    }

    public static void setNowFileNum(int nowFileNum) {
        ParseWorktakerImpl.nowFileNum = nowFileNum;
    }

    @Override
    public boolean importPackage(String filePath) throws OutOfDiskSpaceException {
        Map<String, List<File>> fileOriginalMap = ParseWorktakerImpl.getValidFiles(filePath);
        return this.importPkg(fileOriginalMap);
    }

    private void parseZipFiles(List<File> files) throws OutOfDiskSpaceException {
        DiskAnalyzeContext context = DiskAnalyzeContext.getInstance();
        Map<String, List<AnalyzeDevice>> fileMap = context.getReduplicateMap();
        if (files.isEmpty()) {
            return;
        }
        for (File file2 : files) {
            this.parseOneZipFiles(file2, fileMap);
        }
    }

    private void parse7zFiles(List<File> files) throws OutOfDiskSpaceException {
        DiskAnalyzeContext context = DiskAnalyzeContext.getInstance();
        Map<String, List<AnalyzeDevice>> fileMap = context.getReduplicateMap();
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            this.parseOne7z(file, fileMap);
        }
    }

    private void parseOne7z(File file, Map<String, List<AnalyzeDevice>> fileMap) throws OutOfDiskSpaceException {
        try {
            List<String> list = LocalZipUtils.listFile(file.getCanonicalPath());
            if (!this.judgeValidStruct7z(list)) {
                this.recordSenceUnParseFile(file);
                LOGGER.info(String.format(Locale.ENGLISH, "Import log >> %s package][Failed", FilesUtil.getCanonicalPath(file)));
                return;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "Import log package >> %s][Success", FilesUtil.getCanonicalPath(file)));
            String targetPath = DiskHealthAssistant.getInstance().getPackagePath(file);
            String source7zPath = file.getCanonicalPath();
            String targetFiles = "DataCollect/disksmartinfo/";
            boolean result = LocalZipUtils.deCopmress7zFile(targetPath, source7zPath, targetFiles);
            if (!result) {
                LOGGER.error("deCopmress 7z file is failed...");
                return;
            }
            AnalyzeDevice dev = null;
            try {
                dev = this.createDev7z(file, targetPath, list);
            }
            catch (OutOfDiskSpaceException e) {
                LOGGER.error("parseOne7z OutOfDiskSpaceException");
                return;
            }
            String devSN = dev.getDeviceInfo().getDeviceSerialNumber();
            if (fileMap.containsKey(devSN)) {
                List<AnalyzeDevice> waitToAddDevList = fileMap.get(devSN);
                waitToAddDevList.add(dev);
            } else {
                ArrayList<AnalyzeDevice> analyzeDeviceList = new ArrayList<AnalyzeDevice>();
                analyzeDeviceList.add(dev);
                fileMap.put(devSN, analyzeDeviceList);
            }
        }
        catch (IOException e) {
            LOGGER.error("parse file error.", (Throwable)e);
        }
    }

    private void recordSenceUnParseFile(File logFile) {
        if (!DiskAnalyzeContext.getInstance().isScene()) {
            return;
        }
        List<AnalyzeDevice> unParseList = DiskAnalyzeContext.getInstance().getSenceUnParseList();
        AnalyzeDevice ad = new AnalyzeDevice();
        ad.setInfoPackage(logFile);
        unParseList.add(ad);
    }

    private AnalyzeDevice createDev7z(File devFile, String targetPath, List<String> list) throws OutOfDiskSpaceException {
        AnalyzeDevice dev = new AnalyzeDevice();
        dev.setIs7ZPkg(true);
        dev.setPkgPath(targetPath);
        DevNode devInfo = new DevNode();
        dev.setDeviceInfo(devInfo);
        dev.setFile7zSubList(list);
        StringBuilder summaryPath = new StringBuilder();
        StringBuilder basicPath = new StringBuilder();
        summaryPath.append(targetPath);
        summaryPath.append(File.separator);
        summaryPath.append("DataCollect\\disksmartinfo\\");
        summaryPath.append("summary.ini");
        basicPath.append(targetPath);
        basicPath.append(File.separator);
        basicPath.append("DataCollect\\disksmartinfo\\");
        basicPath.append("basicinfo.txt");
        this.readSummaryIni(devFile, dev, summaryPath.toString(), true);
        this.readBaisctTxt(devFile, dev, basicPath.toString(), true);
        return dev;
    }

    private boolean judgeValidStruct7z(List<String> list) {
        String summaryPath = "DataCollect\\disksmartinfo\\summary.ini";
        String basicPath = "DataCollect\\disksmartinfo\\basicinfo.txt";
        return list.contains(summaryPath) && list.contains(basicPath);
    }

    private void parseOneZipFiles(File file2, Map<String, List<AnalyzeDevice>> fileMap) throws OutOfDiskSpaceException {
        List<Boolean> validFileSign = this.judgeValidStruct(file2);
        if (validFileSign.get(0).booleanValue()) {
            AnalyzeDevice cAnalyzeDevice = null;
            try {
                cAnalyzeDevice = this.creatAnalyzeDevice(file2, validFileSign.get(1));
            }
            catch (OutOfDiskSpaceException e) {
                LOGGER.error("parseOneZipFiles OutOfDiskSpaceException");
                return;
            }
            String devSN = cAnalyzeDevice.getDeviceInfo().getDeviceSerialNumber();
            if (fileMap.containsKey(devSN)) {
                List<AnalyzeDevice> waitToAddDevList = fileMap.get(devSN);
                waitToAddDevList.add(cAnalyzeDevice);
            } else {
                ArrayList<AnalyzeDevice> analyzeDeviceList = new ArrayList<AnalyzeDevice>();
                analyzeDeviceList.add(cAnalyzeDevice);
                fileMap.put(devSN, analyzeDeviceList);
            }
            return;
        }
        this.recordSenceUnParseFile(file2);
    }

    private List<Boolean> judgeValidStruct(File file) {
        ArrayList<Boolean> validFileSign = new ArrayList<Boolean>();
        String summaryPath = "Information\\disksmartinfo\\summary.ini";
        String basicPath = "Information\\disksmartinfo\\basicinfo.txt";
        boolean validFileSign0 = true;
        boolean validFileSign1 = true;
        try {
            boolean subSign0 = ZipUtils.checkExistSubObj((File)file, (String)summaryPath);
            boolean subSign1 = ZipUtils.checkExistSubObj((File)file, (String)basicPath);
            boolean bl = validFileSign0 = subSign0 && subSign1;
            if (!validFileSign0) {
                summaryPath = "Information/disksmartinfo/summary.ini";
                basicPath = "Information/disksmartinfo/basicinfo.txt";
                subSign0 = ZipUtils.checkExistSubObj((File)file, (String)summaryPath);
                subSign1 = ZipUtils.checkExistSubObj((File)file, (String)basicPath);
                boolean bl2 = validFileSign0 = subSign0 && subSign1;
                if (validFileSign0) {
                    validFileSign1 = true;
                }
            } else {
                validFileSign1 = false;
            }
        }
        catch (IOException e) {
            LOGGER.error("check Exist SubObj failed. ");
        }
        if (validFileSign0) {
            LOGGER.info(String.format(Locale.ENGLISH, "Import log package >> %s][Success", FilesUtil.getCanonicalPath(file)));
        } else {
            LOGGER.info("Import log package][Failed");
        }
        validFileSign.add(validFileSign0);
        validFileSign.add(validFileSign1);
        return validFileSign;
    }

    private AnalyzeDevice creatAnalyzeDevice(File devFile, boolean validFileSign1) throws OutOfDiskSpaceException {
        AnalyzeDevice dev = new AnalyzeDevice();
        DevNode devInfo = new DevNode();
        dev.setDeviceInfo(devInfo);
        String summaryPath = DiskHealthAssistant.getInstance().getSummaryPath(dev, validFileSign1, devFile);
        String basicPath = DiskHealthAssistant.getInstance().getBasicPath(dev, validFileSign1, devFile);
        this.readSummaryIni(devFile, dev, summaryPath, false);
        this.readBaisctTxt(devFile, dev, basicPath, false);
        return dev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSummaryIni(File devFile, AnalyzeDevice dev, String summaryPath, boolean is7z) throws OutOfDiskSpaceException {
        String sunmmuryIni = "";
        if (!is7z) {
            try {
                sunmmuryIni = ZipUtils.readTxtFileOnZip((File)devFile, (String)summaryPath);
            }
            catch (IOException e) {
                LOGGER.error("read sunmmuryIni TxtFile On Zip failed. ");
            }
        } else {
            File summaryFile = new File(summaryPath);
            BufferedReader summaryReader = null;
            try {
                summaryReader = this.getBufferedReader(summaryFile);
                if (null == summaryReader && this.isOutOfDiskSpace()) {
                    throw new OutOfDiskSpaceException(ResourceUtil.getString((String)"diskhealthanalyze.warning.outofdiskspace"));
                }
                if (null == summaryReader) {
                    throw new NullPointerException("summaryReader is null");
                }
                StringBuilder summaryBuilder = new StringBuilder();
                String line = "";
                while (null != (line = summaryReader.readLine())) {
                    summaryBuilder.append(line);
                    summaryBuilder.append("\r\n");
                }
                sunmmuryIni = summaryBuilder.toString();
            }
            catch (IOException e) {
                LOGGER.error("read sunmmuryIni TxtFile On Zip failed. ");
            }
            finally {
                StreamUtils.closeResource(null, (Closeable)summaryReader);
            }
        }
        String[] subSummaryTxt = sunmmuryIni.split("\r\n");
        for (int i = 0; i < subSummaryTxt.length; ++i) {
            int indexOfEqual = subSummaryTxt[i].lastIndexOf("=");
            subSummaryTxt[i] = subSummaryTxt[i].substring(indexOfEqual + 1);
        }
        dev.setInfoPackage(devFile);
        dev.setTotalDisk(Integer.parseInt(subSummaryTxt[0]));
        String ipAddress = this.getIp(devFile);
        dev.getDeviceInfo().setIp(ipAddress);
        this.setPackageData(dev, subSummaryTxt[2]);
        dev.setSucceedDisk(Integer.parseInt(subSummaryTxt[1]));
    }

    private void setPackageData(AnalyzeDevice dev, String source) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date pacDate = sdf.parse(source);
            dev.setPackageDate(pacDate);
        }
        catch (ParseException e1) {
            LOGGER.error("parse Date failed. ");
        }
    }

    private boolean isOutOfDiskSpace() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        String[] subPath = workPath.split(":");
        File workDisk = new File(subPath[0] + ":");
        long freeM = workDisk.getFreeSpace() / 1024L / 1024L;
        return freeM <= 10L;
    }

    private void readBaisctTxt(File devFile, AnalyzeDevice dev, String basicPath, boolean is7z) throws OutOfDiskSpaceException {
        String basicTxt = this.getBasicTxt(devFile, basicPath, is7z);
        String[] subBasicTxt = basicTxt.split("\r\n");
        for (int i = 0; i < subBasicTxt.length; ++i) {
            this.parseLineInBasic(dev, subBasicTxt[i]);
        }
        this.getIpForDstorage(dev, subBasicTxt);
    }

    private void getIpForDstorage(AnalyzeDevice dev, String[] subBasicTxt) {
        if (!dev.getDeviceInfo().isDstorage()) {
            return;
        }
        Arrays.stream(subBasicTxt).filter(subBasicTxtStr -> subBasicTxtStr.contains(DEV_IP_KEY)).findFirst().ifPresent(subBasicTxtStr -> {
            int subStrNum = subBasicTxtStr.indexOf(":");
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            if (this.iPV4Check(subStr) || StringUtils.isValidIPV6((String)subStr)) {
                dev.getDeviceInfo().setIp(subStr);
            } else {
                dev.getDeviceInfo().setIp(DEFAULT_STRING);
            }
        });
    }

    private void parseLineInBasic(AnalyzeDevice dev, String subBasicTxtStr) throws OutOfDiskSpaceException {
        if (subBasicTxtStr.contains("System Name")) {
            int subStrNum = this.getIndexInBaisc(subBasicTxtStr);
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            this.isEscapable(subStr);
            dev.getDeviceInfo().setDeviceName(subStr);
        } else if (subBasicTxtStr.contains("Device Model") || subBasicTxtStr.contains("Device Type") || subBasicTxtStr.contains("Product Model")) {
            int subStrNum = this.getIndexInBaisc(subBasicTxtStr);
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            String validDevType = CommonCheckLogic.getInstance().getValidDevType(subStr);
            dev.getDeviceInfo().setDeviceType(DeviceType.valueOf((String)validDevType));
            String prompt = CommonCheckLogic.getInstance().getPromptMap().get(validDevType);
            if (StringUtils.isNULLStr((String)prompt)) {
                return;
            }
            this.isEscapable(prompt);
            Arrays.stream(ItDeviceType.values()).filter(type -> prompt.equalsIgnoreCase(type.getName())).findFirst().ifPresent(itDeviceType -> dev.getDeviceInfo().setItDeviceType(itDeviceType));
        } else if (subBasicTxtStr.contains("Device Serial Number") || subBasicTxtStr.trim().startsWith("SN")) {
            int subStrNum = this.getIndexInBaisc(subBasicTxtStr);
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            this.isEscapable(subStr);
            dev.getDeviceInfo().setDeviceSerialNumber(subStr);
        } else if (subBasicTxtStr.contains("Product Version")) {
            int subStrNum = this.getIndexInBaisc(subBasicTxtStr);
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            this.isEscapable(subStr);
            dev.getDeviceInfo().setProductVersion(subStr);
        } else if (subBasicTxtStr.contains(DEV_IP_KEY)) {
            int subStrNum = this.getIndexInBaisc(subBasicTxtStr);
            String subStr = subBasicTxtStr.substring(subStrNum + 1).trim();
            this.isEscapable(subStr);
            if (this.iPV4Check(subStr) || StringUtils.isValidIPV6((String)subStr)) {
                dev.getDeviceInfo().setIp(subStr);
            } else {
                dev.getDeviceInfo().setIp(DEFAULT_STRING);
            }
        }
    }

    private void isEscapable(String subStr) throws OutOfDiskSpaceException {
        if (!subStr.equals(StringEscapeUtils.escapeHtml4((String)subStr))) {
            LOGGER.error("subStr can be escaped");
            throw new OutOfDiskSpaceException("subStr can be escaped");
        }
    }

    private int getIndexInBaisc(String string) {
        int index = string.lastIndexOf("|");
        if (index < 0) {
            index = string.lastIndexOf(":");
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getBasicTxt(File devFile, String basicPath, boolean is7z) {
        String basicTxt;
        block11: {
            InputStreamReader reader;
            FileInputStream in;
            BufferedReader basicReader;
            basicTxt = "";
            if (!is7z) {
                try {
                    basicTxt = ZipUtils.readTxtFileOnZip((File)devFile, (String)basicPath);
                }
                catch (IOException e) {
                    LOGGER.error("get basicTxt TxtFile On Zip failed. ");
                }
            } else {
                File basicFile = new File(basicPath);
                basicReader = null;
                in = null;
                reader = null;
                in = new FileInputStream(basicFile);
                reader = new InputStreamReader((InputStream)in, "UTF-8");
                basicReader = new BufferedReader(reader);
                StringBuilder basicBuilder = new StringBuilder();
                String line = "";
                while (null != (line = basicReader.readLine())) {
                    basicBuilder.append(line);
                    basicBuilder.append("\r\n");
                }
                basicTxt = basicBuilder.toString();
                StreamUtils.closeResource(null, (Closeable)basicReader);
                StreamUtils.closeResource(null, (Closeable)reader);
                StreamUtils.closeResource(null, (Closeable)in);
            }
            break block11;
            catch (FileNotFoundException e) {
                LOGGER.error("File not found get sunmmuryIni TxtFile On Zip failed. ");
                StreamUtils.closeResource(null, basicReader);
                StreamUtils.closeResource(null, (Closeable)reader);
                StreamUtils.closeResource(null, (Closeable)in);
            }
            catch (IOException e2) {
                LOGGER.error("get sunmmuryIni TxtFile On Zip failed. ");
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeResource(null, basicReader);
                        StreamUtils.closeResource(null, reader);
                        StreamUtils.closeResource(null, (Closeable)in);
                        throw throwable;
                    }
                }
                StreamUtils.closeResource(null, basicReader);
                StreamUtils.closeResource(null, (Closeable)reader);
                StreamUtils.closeResource(null, (Closeable)in);
            }
        }
        return basicTxt;
    }

    private static Map<String, List<File>> getValidFiles(String path) {
        ArrayList<File> z7List = new ArrayList<File>();
        ArrayList<File> zipList = new ArrayList<File>();
        HashMap<String, List<File>> fileMap = new HashMap<String, List<File>>();
        File root = new File(FilePathUtils.checkFile((String)path));
        ParseWorktakerImpl.setNowFileNum(0);
        ParseWorktakerImpl.readFile(zipList, z7List, root);
        LOGGER.info(String.format(Locale.ENGLISH, "Final+FileNum=%d", nowFileNum));
        fileMap.put("zip", zipList);
        fileMap.put("7z", z7List);
        return fileMap;
    }

    private String getIp(File devFile) {
        String fileName = devFile.getName();
        String[] subNames = fileName.split("_");
        if (subNames.length < 1) {
            return DEFAULT_STRING;
        }
        if (this.iPV4Check(subNames[0]) || StringUtils.isValidIPV6((String)subNames[0])) {
            return subNames[0];
        }
        return DEFAULT_STRING;
    }

    private BufferedReader getBufferedReader(File file) {
        BufferedReader summaryReader = null;
        int count = 0;
        while (true) {
            if (30000 == count) {
                return null;
            }
            if (null != file && file.exists()) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error("getBufferedReader sleep failed ");
            }
            ++count;
        }
        try {
            summaryReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("getBufferedReader failed ");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("file unsupported Encoding");
        }
        return summaryReader;
    }

    private static void readFile(List<File> zipList, List<File> z7List, File file) {
        if (++nowFileNum >= 20000) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (null == files) {
                return;
            }
            for (File subFile : files) {
                ParseWorktakerImpl.readFile(zipList, z7List, subFile);
            }
        } else {
            String extName = DiskHealthAssistant.getInstance().getExtName(file.getName());
            try {
                if (DiskAnalyzeContext.getInstance().isScene() && !DiskAnalyzeContext.getInstance().isSceneLog(file.getCanonicalPath())) {
                    return;
                }
            }
            catch (IOException e) {
                LOGGER.error("get path error.", (Throwable)e);
                return;
            }
            if ("zip".equalsIgnoreCase(extName)) {
                zipList.add(file);
            } else if ("7z".equalsIgnoreCase(extName)) {
                z7List.add(file);
            }
        }
    }

    @Override
    public boolean autoImportPkg(List<String> pkgPathList) throws OutOfDiskSpaceException {
        Map<String, List<File>> fileOriginalMap = this.getZip7zFileListMap(pkgPathList);
        return this.importPkg(fileOriginalMap);
    }

    private boolean importPkg(Map<String, List<File>> fileOriginalMap) throws OutOfDiskSpaceException {
        List<File> zipFileList = fileOriginalMap.get("zip");
        List<File> z7FileList = fileOriginalMap.get("7z");
        if (zipFileList.isEmpty() && z7FileList.isEmpty()) {
            return false;
        }
        this.parseZipFiles(zipFileList);
        this.parse7zFiles(z7FileList);
        return true;
    }

    private Map<String, List<File>> getZip7zFileListMap(List<String> pkgPathList) {
        ArrayList<File> zipFileList = new ArrayList<File>();
        ArrayList<File> z7FileList = new ArrayList<File>();
        HashMap<String, List<File>> fileOriginalMap = new HashMap<String, List<File>>();
        for (String pkgPath : pkgPathList) {
            File pkgFile;
            if (pkgPath.trim().endsWith("zip")) {
                pkgFile = new File(pkgPath);
                zipFileList.add(pkgFile);
                continue;
            }
            if (!pkgPath.trim().endsWith("7z")) continue;
            pkgFile = new File(pkgPath);
            z7FileList.add(pkgFile);
        }
        fileOriginalMap.put("zip", zipFileList);
        fileOriginalMap.put("7z", z7FileList);
        return fileOriginalMap;
    }

    private boolean iPV4Check(String ip) {
        try {
            Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
            Matcher mat = pattern.matcher(ip);
            if (!mat.matches()) {
                throw new IllegalArgumentException("wrong IP format\uff1a" + ip);
            }
            String[] str = ip.split("\\.");
            int ipField1 = Integer.parseInt(str[0]);
            int ipField2 = Integer.parseInt(str[1]);
            int ipField3 = Integer.parseInt(str[2]);
            int ipField4 = Integer.parseInt(str[3]);
            if (1 <= ipField1 && 223 >= ipField1 && 0 <= ipField2 && 255 >= ipField2 && 0 <= ipField3 && 255 >= ipField3 && 0 <= ipField4 && 255 >= ipField4) {
                StringUtils.checkIPV4((String)ip);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("isValidIPV4 error.");
            return false;
        }
        catch (IllegalArgumentException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("isValidIPV4 error.");
            return false;
        }
    }
}

